/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.grants;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.grants.PrivilegesInfoPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;

public class RevokePrivilegesPanel
extends PrivilegesInfoPanel
implements ActionListener {
    private final ArrayList<String> _usersWithGrants = new ArrayList();
    private final HashMap<String, ArrayList> _usersPrivs = new HashMap();

    protected RevokePrivilegesPanel(DBObject dbObject) {
        super(dbObject);
        this.init();
    }

    protected void init() {
        this.populateUserGrants();
        this.mdlUsers.removeAllElements();
        for (int i = 0; i < this._usersWithGrants.size(); ++i) {
            this.mdlUsers.addElement(this._usersWithGrants.get(i));
        }
        this.mdlUsers.setSelectedItem("");
        this.mdlPrivFrom.removeAllElements();
        this.cbxUsers.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                Object obj = cb.getSelectedItem();
                if (obj != null) {
                    String user = (String)obj;
                    try {
                        RevokePrivilegesPanel.this.mdlPrivFrom.removeAllElements();
                        for (int i = 0; i < ((ArrayList)RevokePrivilegesPanel.this._usersPrivs.get(user)).size(); ++i) {
                            RevokePrivilegesPanel.this.mdlPrivFrom.addElement(((ArrayList)RevokePrivilegesPanel.this._usersPrivs.get(user)).get(i));
                        }
                        RevokePrivilegesPanel.this.lstPrivFrom.updateUI();
                    }
                    catch (Exception ex) {
                        SQLErrorDialog.showErrorDialog(null, (String)"Error updating privileges. ", (SQLException)((SQLException)ex));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateUserGrants() {
        String sql = "Select GRANTEE, PRIVILEGE  from sys.all_col_privs  where TABLE_SCHEMA = :OWNER  and TABLE_NAME =  :OBJECT_NAME  union all  Select  GRANTEE, PRIVILEGE from sys.all_tab_privs where TABLE_SCHEMA = :OWNER  and TABLE_NAME = :OBJECT_NAME";
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OWNER", this._dbObject.getSchemaName());
        binds.put("OBJECT_NAME", this._dbObject.getObjectName());
        DBUtil dbUtil = new DBUtil();
        ResultSet rs = dbUtil.executeQuery(this._dbObject.getDatabase().getConnectionName(), sql, binds);
        try {
            while (rs.next()) {
                if (!this._usersWithGrants.contains(rs.getString(1))) {
                    this._usersWithGrants.add(rs.getString(1));
                }
                if (this._usersPrivs.get(rs.getString(1)) == null) {
                    this._usersPrivs.put(rs.getString(1), new ArrayList());
                }
                this._usersPrivs.get(rs.getString(1)).add(rs.getString(2));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
            try {
                rs.getStatement().close();
            }
            catch (Exception e) {}
        }
    }

    protected void performRevoke() {
        StringBuilder sb = new StringBuilder();
        sb.append("revoke ");
        if (this.chkAll.isSelected()) {
            sb.append("ALL");
        } else {
            List privs = this.getSelectedPrivileges();
            for (int i = 0; i < privs.size(); ++i) {
                if (i != privs.size() - 1) {
                    sb.append(privs.get(i) + ",");
                    continue;
                }
                sb.append(privs.get(i));
            }
        }
        sb.append(" on ");
        sb.append("\"" + this._dbObject.getSchemaName() + "\".\"" + this._dbObject.getObjectName() + "\"");
        sb.append(" from ");
        sb.append((String)this.cbxUsers.getSelectedItem());
        DBUtil dbUtil = new DBUtil();
        Log.log("REVOKE:" + sb.toString());
        dbUtil.execute(this._dbObject.getDatabase().getConnectionName(), sb.toString(), (ArrayList)null);
    }

    public void actionPerformed(ActionEvent e) {
        this.performRevoke();
        this.close(e);
    }
}

