/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.mview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import oracle.dbtools.raptor.dialogs.mview.MViewInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.MaterializedView;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.relation.RelationInfoPanel;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdeveloper.cm.dt.verifier.relation.RelationInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class MViewInfoPanel
extends BaseInfoPanel
implements ActionListener {
    private RelationInfoPanel m_relPanel = new RelationInfoPanel();
    private JRadioButton m_readOnly = new JRadioButton();
    private JRadioButton m_checkOption = new JRadioButton();
    private JCheckBox m_restrict = new JCheckBox();
    private JCheckBox m_force = new JCheckBox();

    public MViewInfoPanel() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_relPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 15, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_restrict, (String)CmWizardsArb.getString((int)297));
        this.add(this.m_restrict, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_readOnly, (String)CmWizardsArb.getString((int)298));
        this.add(this.m_readOnly, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 30, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_checkOption, (String)CmWizardsArb.getString((int)299));
        this.add(this.m_checkOption, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 30, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_force, (String)CmWizardsArb.getString((int)300));
        this.add(this.m_force, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_readOnly);
        bg.add(this.m_checkOption);
        this.m_readOnly.setSelected(true);
        this.m_restrict.setSelected(false);
        this.m_readOnly.setEnabled(false);
        this.m_checkOption.setEnabled(false);
        this.m_restrict.addActionListener(this);
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        MaterializedView mview = (MaterializedView)dataContext.find("NewObject");
        MViewInfoVerifier verifier = (MViewInfoVerifier)dataContext.find("MViewInfoVerifier");
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.init(prov, mview, verifier, schemas);
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        if (callbacks != null) {
            callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE);
            this.m_relPanel.checkCallbacks(callbacks);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit((MaterializedView)dataContext.find("NewObject"), (Schema[])dataContext.find("SchemaList"), dataContext.getDirection() != 2);
    }

    protected void init(DBObjectProvider prov, MaterializedView mview, MViewInfoVerifier verifier, Schema[] schemas) {
        super.init(prov, (Verifier)verifier);
        this.m_relPanel.init(prov, (Relation)mview, (RelationInfoVerifier)verifier, schemas);
        String rest = mview.getType();
        if (rest != null) {
            this.m_restrict.setSelected(true);
            this.m_readOnly.setEnabled(true);
            this.m_checkOption.setEnabled(true);
            this.m_readOnly.setSelected(true);
        }
        if (null != verifier) {
            this.m_restrict.setEnabled(verifier.canEnableQueryReWrite());
            this.m_readOnly.setEnabled(this.m_restrict.isSelected() && verifier.canEnableQueryReWrite());
            this.m_checkOption.setEnabled(this.m_restrict.isSelected() && verifier.canEnableQueryReWrite());
            this.m_force.setEnabled(verifier.canEnableQueryReWrite());
        }
    }

    protected void commit(MaterializedView mview, Schema[] schema, boolean isForward) throws TraversalException {
        this.m_relPanel.commit((Relation)mview, schema, isForward);
    }

    protected void setOwnerLabel(String label) {
        this.m_relPanel.setOwnerLabel(label);
    }

    protected void setTopLabel(String label) {
        this.m_relPanel.setTopLabel(label);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_restrict) {
            if (this.m_restrict.isSelected()) {
                this.m_readOnly.setEnabled(true);
                this.m_checkOption.setEnabled(true);
            } else {
                this.m_readOnly.setEnabled(false);
                this.m_checkOption.setEnabled(false);
            }
        }
    }
}

