/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.mview;

import java.sql.SQLException;
import oracle.dbtools.raptor.dialogs.mview.CreateMViewVerifier;
import oracle.dbtools.raptor.dialogs.mview.MViewChoicePanel;
import oracle.dbtools.raptor.dialogs.mview.MViewInfoPanel;
import oracle.ide.Context;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdeveloper.cm.dt.wizard.SchemaObjectFinishPanel;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class OracleMViewWizardLauncher
extends DBWizardLauncher {
    private static final String WELCOME_KEY = "OracleViewWizardKey";
    public static final String HELP_WELCOME = "f1_dbviewwizardwelcome_html";
    public static final String HELP_VIEW_INFO = "f1_dbviewwizardviewinfo_html";
    public static final String HELP_VIEW_CHOICE = "f1_dbviewwizardviewcreation_html";
    public static final String HELP_MANUAL_QUERY = "f1_dbviewwizardentiresqlquery_html";
    public static final String HELP_FINISH = "f1_dbviewwizardfinish_html";

    public OracleMViewWizardLauncher(Context ctx, Database db) {
        super(ctx, db, CmWizardsArb.getString((int)185));
        this.setShowStepNumber(true);
        this.registerVerifier("MViewInfoVerifier", CreateMViewVerifier.class);
        Schema schema = (Schema)this.find("Schema");
        MaterializedView mview = new MaterializedView(db.getUniqueName("MATERIALIZED VIEW", (DBObject)schema, null), schema);
        mview.setID(TemporaryObjectID.createID((DBObject)mview));
        this.put("NewObject", mview);
        this.put("OriginalObject", null);
        this.put("DDlGenerator", new OracleDDLGenerator((DBObjectProvider)db));
        this.addWelcomePage(CmWizardsArb.getString((int)189), CmWizardsArb.getString((int)190), WELCOME_KEY, HELP_WELCOME);
        this.addPage(MViewInfoPanel.class.getName(), HELP_VIEW_INFO, CmWizardsArb.getString((int)285));
        this.addPage(MViewChoicePanel.class.getName(), HELP_VIEW_CHOICE, CmWizardsArb.getString((int)295));
        this.addFinishPage(SchemaObjectFinishPanel.class.getName(), HELP_FINISH, CmWizardsArb.getString((int)174));
        this.addCommitListener(new MViewCommitListener());
    }

    public boolean runWizardImpl() {
        return super.runGenericWizard();
    }

    private static class MViewCommitListener
    implements CommitListener {
        private MViewCommitListener() {
        }

        public void checkCommit(ApplyEvent event) {
        }

        public void rollback(ApplyEvent event) {
        }

        public void cancel(ApplyEvent event) {
        }

        public void commit(ApplyEvent event) throws TraversalException {
            TraversableContext tc = event.getTraversableContext();
            MaterializedView mview = (MaterializedView)tc.find("NewObject");
            OracleDatabase db = (OracleDatabase)tc.find("DBObjectProvider");
            try {
                db.createObject((SchemaObject)mview, false);
            }
            catch (DBException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(null, (String)CmWizardsArb.getString((int)187), (SQLException)((SQLException)cause));
                    if (((SQLException)cause).getErrorCode() != 955) {
                        try {
                            db.deleteObject((SchemaObject)mview, true);
                        }
                        catch (DBException ex) {}
                    }
                } else {
                    ExceptionDialog.showExceptionDialog((Context)new Context(), (Throwable)(cause != null ? cause : e), (String)CmWizardsArb.getString((int)187), (String)CmWizardsArb.getString((int)188), null);
                }
                throw new TraversalException(null);
            }
        }
    }
}

