/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.mview;

import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.TabbedDialogLauncher;
import oracle.dbtools.raptor.dialogs.mview.CreateMViewVerifier;
import oracle.dbtools.raptor.dialogs.mview.EditMViewVerifier;
import oracle.dbtools.raptor.dialogs.mview.ui.MviewPanel;
import oracle.ide.Context;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.ui.sql.QueryDisplayPanel;
import oracle.jdeveloper.cm.dt.ui.sql.QueryPanel;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class TabbedOracleMViewLauncher
extends TabbedDialogLauncher {
    public TabbedOracleMViewLauncher(OracleDatabase db, Schema schema, boolean isEdit) {
        super((Database)db, schema);
        this.put("Tablespaces", db.listTablespaces());
        if (isEdit) {
            this.addTab(QueryDisplayPanel.class, "f1_dbviewwizardentiresqlquery_html", CmWizardsArb.getString((int)294));
        } else {
            this.addTab(QueryPanel.class, "f1_dbviewwizardentiresqlquery_html", CmWizardsArb.getString((int)294));
        }
        this.addTab(MviewPanel.class, "f1_dbviewwizardviewinfo_html", CreateDialogArb.getString(307));
    }

    public boolean createObject() {
        Schema schema = this.getSchema();
        DBObjectProvider db = this.getProvider();
        MaterializedView mview = new MaterializedView(db.getUniqueName("MATERIALIZED VIEW", (DBObject)schema, null), schema);
        mview.setSQLQuery((SQLQuery)new OracleSQLQuery());
        mview.setID(TemporaryObjectID.createID((DBObject)mview));
        this.put("NewObject", mview);
        this.put("OriginalObject", null);
        this.put("DDlGenerator", new OracleDDLGenerator(db));
        this.registerVerifier("MViewInfoVerifier", CreateMViewVerifier.class);
        this.registerVerifier("SchemaObjectInfoVerifier", CreateMViewVerifier.class);
        this.addTab(TabbedDialogLauncher.CreateSQLTab.class, "f1_dbviewwizardviewcreation_html", "DDL");
        this.setTitle(CreateDialogArb.getString(176));
        this.setErrorTitle(CreateDialogArb.getString(178));
        return this.createObjectImpl();
    }

    public boolean editObject(SchemaObject object) {
        SchemaObject copy = (SchemaObject)DBUtil.makeTemporaryCopy((DBObject)object);
        DBObjectProvider db = this.getProvider();
        this.put("NewObject", object);
        this.put("OriginalObject", copy);
        this.put("DDlGenerator", new OracleDDLGenerator(db));
        this.registerVerifier("MViewInfoVerifier", EditMViewVerifier.class);
        this.registerVerifier("SchemaObjectInfoVerifier", EditMViewVerifier.class);
        this.addTab(TabbedDialogLauncher.EditSQLTab.class, "f1_dbviewwizardviewcreation_html", "DDL");
        this.setTitle(CreateDialogArb.getString(177));
        this.setErrorTitle(CreateDialogArb.getString(178));
        return this.createObjectImpl();
    }

    public static boolean createMView(Context ctx, OracleDatabase db) {
        try {
            Schema schema = DBWizardLauncher.determineSchema((Context)ctx, (Database)db);
            TabbedOracleMViewLauncher launcher = new TabbedOracleMViewLauncher(db, schema, false);
            return launcher.createObject();
        }
        catch (DBException dBException) {
            return false;
        }
    }

    public static boolean editMView(OracleDatabase db, MaterializedView mview) {
        TabbedOracleMViewLauncher launcher = new TabbedOracleMViewLauncher(db, mview.getSchema(), true);
        return launcher.editObject((SchemaObject)mview);
    }
}

