/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.mview.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.mview.MViewInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDatabase;

public class MviewLeftPanel
extends JPanel {
    private MViewInfoVerifier m_verifier = null;
    private MaterializedView _mview = null;
    private JLabel _refreshTypeLabel = new JLabel();
    private String[] _typeStrings = new String[]{CreateDialogArb.getString(532), CreateDialogArb.getString(533), CreateDialogArb.getString(531), CreateDialogArb.getString(530)};
    private String[] _periodStrings = new String[]{CreateDialogArb.getString(538), CreateDialogArb.getString(539), CreateDialogArb.getString(540), CreateDialogArb.getString(541)};
    private String[] _methodStrings = new String[]{CreateDialogArb.getString(535), CreateDialogArb.getString(536)};
    private JComboBox _refreshTypeComboBox = new JComboBox<String>(this._typeStrings);
    private JLabel _refreshMethodLabel = new JLabel();
    private JComboBox _refreshMethodComboBox = new JComboBox<String>(this._methodStrings);
    private JLabel _refreshPeriodLabel = new JLabel();
    private JComboBox _refreshPeriodComboBox = new JComboBox<String>(this._periodStrings);
    private Date _chosenDate = new Date(3L);
    private DateFormat oracleDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private DateEditor _dateChooser = new DateEditor(this._chosenDate);
    private DateEditor _nextDateChooser = new DateEditor(this._chosenDate);
    private JLabel _refreshAtLabel = new JLabel();
    private JLabel jLabel1 = new JLabel();
    private JCheckBox _rollbackCheckBox = new JCheckBox();
    private ButtonGroup defaultUse = new ButtonGroup();
    private JRadioButton _defaultRollbackRadio = new JRadioButton();
    private JRadioButton _useSpecificRadioButton = new JRadioButton();
    private JTextField _rollbackSegmentTextField = new JTextField();
    private ButtonGroup localMaster = new ButtonGroup();
    private JRadioButton _localRollbackRadio = new JRadioButton();
    private JRadioButton _masterRollbackRadio = new JRadioButton();
    private JCheckBox _refreshUseConstraintCheckBox = new JCheckBox();
    private JRadioButton _enforcedRadioButton = new JRadioButton();
    private JRadioButton _trustedRadioButton = new JRadioButton();
    private ButtonGroup _conButtonGroup = new ButtonGroup();
    private DBUtil dbutil = new DBUtil();

    public MviewLeftPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void init(DBObjectProvider prov, MaterializedView mview, MViewInfoVerifier verifier, Schema[] schemas) {
        this.m_verifier = verifier;
        this._mview = mview;
        switch (mview.getRefreshMethod()) {
            case 0: {
                this._refreshTypeComboBox.setSelectedIndex(1);
                break;
            }
            case 1: {
                this._refreshTypeComboBox.setSelectedIndex(2);
                break;
            }
            case 2: {
                this._refreshTypeComboBox.setSelectedIndex(0);
                break;
            }
            case 3: {
                this._refreshTypeComboBox.setSelectedIndex(3);
                break;
            }
            default: {
                this._refreshTypeComboBox.setSelectedIndex(3);
            }
        }
        switch (mview.getRefreshMode()) {
            case 0: {
                this._refreshPeriodComboBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this._refreshPeriodComboBox.setSelectedIndex(1);
                break;
            }
            case 2: {
                this._refreshPeriodComboBox.setSelectedIndex(2);
                break;
            }
            case 3: {
                this._refreshPeriodComboBox.setSelectedIndex(3);
                break;
            }
        }
        if (mview.getRollbackSegmentType() == 0) {
            this._rollbackCheckBox.setSelected(false);
            this._masterRollbackRadio.setEnabled(false);
            this._localRollbackRadio.setEnabled(false);
            this._defaultRollbackRadio.setEnabled(false);
            this._useSpecificRadioButton.setEnabled(false);
            this._rollbackSegmentTextField.setEnabled(false);
            this._rollbackCheckBox.setEnabled(verifier.canRefreshUseRollback());
        } else {
            this._rollbackCheckBox.setEnabled(verifier.canRefreshUseRollback());
            this._rollbackCheckBox.setSelected(true);
            this._localRollbackRadio.setEnabled(verifier.canRefreshUseRollback());
            this._masterRollbackRadio.setEnabled(verifier.canRefreshUseRollback());
            this._useSpecificRadioButton.setEnabled(verifier.canRefreshUseRollback());
            this._defaultRollbackRadio.setEnabled(verifier.canRefreshUseRollback());
            this._rollbackSegmentTextField.setEnabled(false);
            if (mview.getRollbackSegmentType() == 1) {
                this._localRollbackRadio.setSelected(true);
            } else {
                this._localRollbackRadio.setSelected(false);
            }
            if (mview.getRollbackSegmentType() == 2) {
                this._masterRollbackRadio.setSelected(true);
            } else {
                this._masterRollbackRadio.setSelected(false);
            }
            if (mview.getRollbackSegmentName() == null || mview.getRollbackSegmentName().trim().equals("")) {
                this._defaultRollbackRadio.setSelected(true);
            } else {
                this._defaultRollbackRadio.setSelected(false);
                this._useSpecificRadioButton.setSelected(true);
                this._rollbackSegmentTextField.setEnabled(verifier.canRefreshUseRollback());
                this._rollbackSegmentTextField.setText(mview.getRollbackSegmentName());
            }
        }
        Boolean usingTrustedConstraints = mview.isUsingTrustedConstraints();
        if (usingTrustedConstraints == null) {
            this._refreshUseConstraintCheckBox.setSelected(false);
        } else {
            this._refreshUseConstraintCheckBox.setSelected(true);
        }
        this._refreshUseConstraintCheckBox.setEnabled(this.m_verifier.canRefreshConstraints());
        this._enforcedRadioButton.setEnabled(this._refreshUseConstraintCheckBox.isSelected());
        this._trustedRadioButton.setEnabled(this._refreshUseConstraintCheckBox.isSelected());
        this._refreshTypeLabel.setEnabled(this._refreshUseConstraintCheckBox.isSelected());
        this._refreshMethodComboBox.setEnabled(this._refreshUseConstraintCheckBox.isSelected());
        this._refreshMethodLabel.setEnabled(this.m_verifier.canRefreshMethod());
        this._refreshTypeComboBox.setEnabled(this.m_verifier.canRefreshMethod());
        this._refreshPeriodLabel.setEnabled(this.m_verifier.canRefreshWhen());
        this._refreshPeriodComboBox.setEnabled(this.m_verifier.canRefreshWhen());
        if (usingTrustedConstraints != null && usingTrustedConstraints.booleanValue()) {
            this._trustedRadioButton.setSelected(true);
        } else {
            this._enforcedRadioButton.setSelected(true);
        }
        if (mview.getNextRefresh() != null) {
            try {
                SimpleDateFormat _startDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                Date _startDate = _startDateFormat.parse(mview.getNextRefresh());
                this._dateChooser.setDate(_startDate);
            }
            catch (ParseException pe) {
                System.err.println(pe.getMessage());
            }
        }
        if (mview.getInterval() != null) {
            // empty if block
        }
        Assert.println((String)mview.getNextRefresh());
        Assert.println((String)mview.getInterval());
        OracleDatabase db = (OracleDatabase)prov;
    }

    private Connection getConnection(DBObjectProvider prov) {
        Connection conn = null;
        if (prov instanceof Database) {
            conn = ((Database)prov).getConnection();
        }
        return conn;
    }

    public void commit(MaterializedView mview, Schema[] schema, boolean isForward) throws TraversalException {
        String refreshType = this.getType();
        if (refreshType.equals(CreateDialogArb.getString(532))) {
            mview.setRefreshMethod(2);
        } else if (refreshType.equals(CreateDialogArb.getString(533))) {
            mview.setRefreshMethod(0);
        } else if (refreshType.equals(CreateDialogArb.getString(531))) {
            mview.setRefreshMethod(1);
        } else if (refreshType.equals(CreateDialogArb.getString(530))) {
            mview.setRefreshMethod(3);
        }
        String periodString = this.getPeriod();
        if (periodString.equals(CreateDialogArb.getString(538))) {
            mview.setRefreshMode(0);
        } else if (periodString.equals(CreateDialogArb.getString(539))) {
            mview.setRefreshMode(1);
        } else if (periodString.equals(CreateDialogArb.getString(541))) {
            mview.setRefreshMode(3);
        } else if (periodString.equals(CreateDialogArb.getString(540))) {
            mview.setRefreshMode(2);
            Date nextRefreshDate = this.getStartDate();
            Date intervalDate = this.getNextDate();
            String nextRefreshStr = this.oracleDateFormat.format(nextRefreshDate);
            String intervalStr = this.oracleDateFormat.format(intervalDate);
            String oracleDateFormatStr = "dd-Mon-yyyy HH24:mi:ss";
            mview.setNextRefresh("TO_DATE('" + nextRefreshStr + "','" + oracleDateFormatStr + "') ");
            mview.setInterval("TO_DATE('" + intervalStr + "','" + oracleDateFormatStr + "') ");
        }
        String keyMethod = this.getMethod();
        if (keyMethod.equals(CreateDialogArb.getString(535))) {
            mview.setKeyType(1);
        } else if (keyMethod.equals(CreateDialogArb.getString(536))) {
            mview.setKeyType(2);
        }
        if (this._rollbackCheckBox.isSelected()) {
            if (this._localRollbackRadio.isSelected()) {
                mview.setRollbackSegmentType(1);
            } else if (this._masterRollbackRadio.isSelected()) {
                mview.setRollbackSegmentType(2);
            }
            if (this._defaultRollbackRadio.isSelected()) {
                mview.setRollbackSegmentName("");
            } else if (this._useSpecificRadioButton.isSelected()) {
                mview.setRollbackSegmentName(this._rollbackSegmentTextField.getText());
            }
        } else {
            mview.setRollbackSegmentName("");
            mview.setRollbackSegmentType(0);
        }
        if (this._refreshUseConstraintCheckBox.isSelected()) {
            if (this._enforcedRadioButton.isSelected()) {
                mview.setUsingTrustedConstraints(Boolean.valueOf(false));
            } else if (this._trustedRadioButton.isSelected()) {
                mview.setUsingTrustedConstraints(Boolean.valueOf(true));
            }
        } else {
            mview.setUsingTrustedConstraints(null);
        }
    }

    public String getType() {
        return (String)this._refreshTypeComboBox.getSelectedItem();
    }

    public void setType(String selection) {
        this._refreshTypeComboBox.setSelectedItem(selection);
    }

    public String getMethod() {
        return (String)this._refreshMethodComboBox.getSelectedItem();
    }

    public void setMethod(int selection) {
        this._refreshMethodComboBox.setSelectedIndex(selection);
    }

    public String getPeriod() {
        return (String)this._refreshPeriodComboBox.getSelectedItem();
    }

    public void setPeriod(String selection) {
        this._refreshPeriodComboBox.setSelectedItem(selection);
    }

    public Date getStartDate() {
        return this._dateChooser.getDate();
    }

    public void setStartDate(Date dateIn) {
        this._dateChooser.setDate(dateIn);
    }

    public Date getNextDate() {
        return this._nextDateChooser.getDate();
    }

    public void setNextDate(Date dateIn) {
        this._nextDateChooser.setDate(dateIn);
    }

    public boolean getRollbackSelected() {
        return this._rollbackCheckBox.isSelected();
    }

    public void setRollbackSelected(boolean set) {
        this._rollbackCheckBox.setSelected(set);
    }

    public boolean getMasterRollback() {
        return this._masterRollbackRadio.isSelected();
    }

    public void setMasterRollback(boolean set) {
        this._masterRollbackRadio.setSelected(set);
    }

    public boolean getLocalRollback() {
        return this._localRollbackRadio.isSelected();
    }

    public void setLocalRollback(boolean set) {
        this._localRollbackRadio.setSelected(set);
    }

    public void commit(MaterializedView mview) {
        String refreshType = this.getType();
        if (refreshType.equals(CreateDialogArb.getString(532))) {
            mview.setRefreshMethod(2);
        } else if (refreshType.equals(CreateDialogArb.getString(533))) {
            mview.setRefreshMethod(0);
        } else if (refreshType.equals(CreateDialogArb.getString(531))) {
            mview.setRefreshMethod(1);
        } else if (refreshType.equals(CreateDialogArb.getString(530))) {
            mview.setRefreshMethod(3);
        }
        String periodString = this.getPeriod();
        if (periodString.equals(CreateDialogArb.getString(538))) {
            mview.setRefreshMode(0);
        } else if (periodString.equals(CreateDialogArb.getString(539))) {
            mview.setRefreshMode(1);
        } else if (periodString.equals(CreateDialogArb.getString(541))) {
            mview.setRefreshMode(3);
        }
        String keyMethod = this.getMethod();
        if (keyMethod.equals(CreateDialogArb.getString(535))) {
            mview.setKeyType(1);
        } else if (keyMethod.equals(CreateDialogArb.getString(536))) {
            mview.setKeyType(2);
        }
        if (this._rollbackCheckBox.isSelected()) {
            if (this._localRollbackRadio.isSelected()) {
                mview.setRollbackSegmentType(1);
            } else if (this._masterRollbackRadio.isSelected()) {
                mview.setRollbackSegmentType(2);
            }
            if (this._defaultRollbackRadio.isSelected()) {
                mview.setRollbackSegmentName("");
            } else if (this._useSpecificRadioButton.isSelected()) {
                mview.setRollbackSegmentName(this._rollbackSegmentTextField.getText());
            }
        } else {
            mview.setRollbackSegmentName("");
            mview.setRollbackSegmentType(0);
        }
        if (this._refreshUseConstraintCheckBox.isSelected()) {
            if (this._enforcedRadioButton.isSelected()) {
                mview.setUsingTrustedConstraints(Boolean.valueOf(false));
            } else if (this._trustedRadioButton.isSelected()) {
                mview.setUsingTrustedConstraints(Boolean.valueOf(true));
            }
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.localMaster.add(this._localRollbackRadio);
        this.localMaster.add(this._masterRollbackRadio);
        this.defaultUse.add(this._defaultRollbackRadio);
        this.defaultUse.add(this._useSpecificRadioButton);
        this.setBorder(BorderFactory.createTitledBorder("Refresh Options"));
        this.setToolTipText("Choose the type of refresh you want to do");
        this.setSize(new Dimension(276, 300));
        this._refreshTypeLabel.setText("Type");
        this._refreshTypeLabel.setBounds(new Rectangle(7, 80, 48, 20));
        this._refreshTypeLabel.setToolTipText("null");
        this._refreshTypeLabel.setHorizontalAlignment(4);
        this._refreshTypeComboBox.setBounds(new Rectangle(60, 20, 144, 20));
        this._refreshTypeComboBox.setSelectedIndex(1);
        this._refreshTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewLeftPanel.this._refreshTypeComboBox_actionPerformed(e);
            }
        });
        this._refreshMethodLabel.setText("Method");
        this._refreshMethodLabel.setBounds(new Rectangle(-17, 21, 72, 20));
        this._refreshMethodLabel.setHorizontalAlignment(4);
        this._refreshMethodComboBox.setBounds(new Rectangle(60, 80, 90, 20));
        this._refreshMethodComboBox.setSelectedIndex(0);
        this._refreshPeriodLabel.setText("When");
        this._refreshPeriodLabel.setBounds(new Rectangle(6, 50, 49, 25));
        this._refreshPeriodLabel.setToolTipText("null");
        this._refreshPeriodLabel.setHorizontalAlignment(4);
        this._refreshPeriodComboBox.setBounds(new Rectangle(60, 50, 90, 20));
        this._refreshPeriodComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewLeftPanel.this._refreshPeriodComboBox_actionPerformed(e);
            }
        });
        this.add((Component)this._trustedRadioButton, null);
        this.add((Component)this._enforcedRadioButton, null);
        this.add((Component)this._refreshUseConstraintCheckBox, null);
        this.add((Component)this._masterRollbackRadio, null);
        this.add((Component)this._localRollbackRadio, null);
        this.add((Component)this._rollbackSegmentTextField, null);
        this.add((Component)this._useSpecificRadioButton, null);
        this.add((Component)this._defaultRollbackRadio, null);
        this.add((Component)this._rollbackCheckBox, null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this._refreshAtLabel, null);
        this.add((Component)this._refreshPeriodComboBox, null);
        this.add((Component)this._refreshPeriodLabel, null);
        this.add((Component)this._refreshMethodComboBox, null);
        this.add((Component)this._refreshMethodLabel, null);
        this.add((Component)this._refreshTypeComboBox, null);
        this.add((Component)this._refreshTypeLabel, null);
        this.add((Component)this._dateChooser, null);
        this.add((Component)this._nextDateChooser, null);
        this._dateChooser.setBounds(new Rectangle(60, 110, 150, 25));
        this._dateChooser.setToolTipText(CreateDialogArb.getString(568));
        this._dateChooser.setDateFormat(this.oracleDateFormat);
        this._dateChooser.setEnabled(false);
        this._refreshAtLabel.setText("Start on");
        this._refreshAtLabel.setBounds(new Rectangle(10, 115, 45, 15));
        this._refreshAtLabel.setToolTipText("null");
        this._refreshAtLabel.setHorizontalAlignment(4);
        this._refreshAtLabel.setEnabled(false);
        this._nextDateChooser.setBounds(new Rectangle(60, 140, 150, 25));
        this._nextDateChooser.setToolTipText(CreateDialogArb.getString(569));
        this._nextDateChooser.setDateFormat(this.oracleDateFormat);
        this._nextDateChooser.setEnabled(false);
        this.jLabel1.setText("Next");
        this.jLabel1.setBounds(new Rectangle(20, 140, 35, 15));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setEnabled(false);
        this._rollbackCheckBox.setText("Use RollbackSegment");
        this._rollbackCheckBox.setBounds(new Rectangle(25, 170, 192, 20));
        this._rollbackCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewLeftPanel.this._rollbackCheckBox_actionPerformed(e);
            }
        });
        this._defaultRollbackRadio.setText("Default");
        this._defaultRollbackRadio.setBounds(new Rectangle(140, 190, 86, 18));
        this._defaultRollbackRadio.setActionCommand("_defaultRollbackRadio");
        this._defaultRollbackRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewLeftPanel.this._defaultRollbackRadio_actionPerformed(e);
            }
        });
        this._defaultRollbackRadio.setEnabled(false);
        this._useSpecificRadioButton.setText("Use");
        this._useSpecificRadioButton.setBounds(new Rectangle(140, 210, 103, 20));
        this._useSpecificRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewLeftPanel.this._useSpecificRadioButton_actionPerformed(e);
            }
        });
        this._useSpecificRadioButton.setEnabled(false);
        this._rollbackSegmentTextField.setBounds(new Rectangle(25, 235, 185, 20));
        this._rollbackSegmentTextField.setEnabled(false);
        this._localRollbackRadio.setText("Local");
        this._localRollbackRadio.setBounds(new Rectangle(40, 210, 86, 18));
        this._localRollbackRadio.setEnabled(false);
        this._masterRollbackRadio.setText("Master");
        this._masterRollbackRadio.setBounds(new Rectangle(40, 190, 86, 18));
        this._masterRollbackRadio.setEnabled(false);
        this._refreshUseConstraintCheckBox.setText("Constraints");
        this._refreshUseConstraintCheckBox.setBounds(new Rectangle(25, 260, 91, 20));
        this._refreshUseConstraintCheckBox.setActionCommand("_refreshUseConstraintCheckBox");
        this._refreshUseConstraintCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewLeftPanel.this._useCheckContraints_actionPerformed(e);
            }
        });
        this._enforcedRadioButton.setText("Enforced");
        this._enforcedRadioButton.setBounds(new Rectangle(117, 260, 80, 18));
        this._enforcedRadioButton.setActionCommand("_enforcedRadioButton");
        this._trustedRadioButton.setText("Trusted");
        this._trustedRadioButton.setBounds(new Rectangle(201, 260, 71, 20));
        this._trustedRadioButton.setActionCommand("_TrustedRadioButton");
        this._conButtonGroup.add(this._trustedRadioButton);
        this._conButtonGroup.add(this._enforcedRadioButton);
        this._trustedRadioButton.setEnabled(false);
        this._trustedRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewLeftPanel.this._trustedRadioButton_actionPerformed(e);
            }
        });
        this._enforcedRadioButton.setEnabled(false);
    }

    private void _rollbackCheckBox_actionPerformed(ActionEvent e) {
        if (this._rollbackCheckBox.isSelected()) {
            this._defaultRollbackRadio.setEnabled(this.m_verifier.canRefreshUseRollback());
            this._useSpecificRadioButton.setEnabled(this.m_verifier.canRefreshUseRollback());
            this._localRollbackRadio.setEnabled(this.m_verifier.canRefreshUseRollback());
            this._masterRollbackRadio.setEnabled(this.m_verifier.canRefreshUseRollback());
            if (this._useSpecificRadioButton.isSelected()) {
                this._rollbackSegmentTextField.setEnabled(this.m_verifier.canRefreshUseRollback());
            }
        } else {
            this._defaultRollbackRadio.setEnabled(false);
            this._useSpecificRadioButton.setEnabled(false);
            this._localRollbackRadio.setEnabled(false);
            this._masterRollbackRadio.setEnabled(false);
            this._rollbackSegmentTextField.setEnabled(false);
        }
    }

    private void _useSpecificRadioButton_actionPerformed(ActionEvent e) {
        this._rollbackSegmentTextField.setEnabled(true);
    }

    private void _defaultRollbackRadio_actionPerformed(ActionEvent e) {
        this._rollbackSegmentTextField.setEnabled(false);
    }

    private void _useCheckContraints_actionPerformed(ActionEvent e) {
        if (this._refreshUseConstraintCheckBox.isSelected()) {
            this._enforcedRadioButton.setEnabled(true);
            this._trustedRadioButton.setEnabled(true);
        } else {
            this._enforcedRadioButton.setEnabled(false);
            this._trustedRadioButton.setEnabled(false);
        }
    }

    private void _refreshTypeComboBox_actionPerformed(ActionEvent e) {
        if (this._refreshTypeComboBox.getSelectedIndex() == 3) {
            this._dateChooser.setDate(null);
            this._dateChooser.setEnabled(false);
            this._nextDateChooser.setDate(null);
            this._nextDateChooser.setEnabled(false);
            this._rollbackCheckBox.setSelected(false);
            this._rollbackCheckBox_actionPerformed(new ActionEvent(new Object(), 1, ""));
            this._refreshUseConstraintCheckBox.setSelected(false);
            this._useCheckContraints_actionPerformed(new ActionEvent(new Object(), 1, ""));
        } else {
            this._rollbackCheckBox.setSelected(true);
            if (this._mview.getRollbackSegmentType() == 0) {
                this._refreshUseConstraintCheckBox.setSelected(true);
            }
            this._rollbackCheckBox_actionPerformed(new ActionEvent(new Object(), 1, ""));
            this._useCheckContraints_actionPerformed(new ActionEvent(new Object(), 1, ""));
        }
    }

    private void _refreshPeriodComboBox_actionPerformed(ActionEvent e) {
        if (this._refreshPeriodComboBox.getSelectedIndex() == 2) {
            this._dateChooser.setDate(new Date());
            this._dateChooser.setEnabled(true);
            this._nextDateChooser.setDate(new Date());
            this._nextDateChooser.setEnabled(true);
            this.jLabel1.setEnabled(true);
            this._refreshAtLabel.setEnabled(true);
        } else {
            this._dateChooser.setDate(null);
            this._dateChooser.setEnabled(false);
            this._nextDateChooser.setDate(null);
            this._nextDateChooser.setEnabled(false);
            this.jLabel1.setEnabled(false);
            this._refreshAtLabel.setEnabled(false);
        }
    }

    private void setRollbackUI(int rsType, String rsName) {
    }

    private void _trustedRadioButton_actionPerformed(ActionEvent e) {
    }
}

