/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.mview.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.mview.MViewInfoVerifier;
import oracle.ide.Context;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleStorageProperties;

public class MviewRightPanel
extends JPanel {
    private String[] _buildTypeStrings = new String[]{CreateDialogArb.getString(547), CreateDialogArb.getString(548)};
    private String[] _extentStrings = new String[]{"KB", "MB"};
    private MViewInfoVerifier m_verifier = null;
    OracleStorageProperties oProps = new OracleStorageProperties();
    Context ctx = null;
    private JCheckBox _useindexCheckBox = new JCheckBox();
    private JComboBox indexTablespaceComboBox = new JComboBox();
    private JCheckBox _parallelCheckBox = new JCheckBox();
    private JTextField _parallelValue = new JTextField();
    private JPanel northPane = new JPanel();
    private JPanel centerPane = new JPanel();
    private JCheckBox _enableCacheCheckBox = new JCheckBox();
    private JCheckBox _indexUseCheckBox = new JCheckBox();
    private JLabel _buildTypeLabel = new JLabel();
    private JComboBox _buildTypeComboBox = new JComboBox<String>(this._buildTypeStrings);
    private JCheckBox _queryRewriteCheck = new JCheckBox();
    private JCheckBox _prebuiltCheckBox = new JCheckBox();
    ButtonGroup bgPrebuilt = new ButtonGroup();
    private JRadioButton _reducedPrecisionRadio = new JRadioButton();
    private JRadioButton _noReducedRadio = new JRadioButton();
    ButtonGroup bg2 = new ButtonGroup();

    public MviewRightPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getParallelCheck() {
        return this._parallelCheckBox.isSelected();
    }

    public void setParallelCheck(boolean b) {
        this._parallelCheckBox.setSelected(b);
    }

    public String getParallelValue() {
        return this._parallelValue.getText();
    }

    public void setParallelValue(String s) {
        this._parallelValue.setText(s);
    }

    public boolean getEnableCache() {
        return this._enableCacheCheckBox.isSelected();
    }

    public void setEnableCache(boolean b) {
        this._enableCacheCheckBox.setSelected(b);
    }

    public boolean getEnableQueryRewrite() {
        return this._queryRewriteCheck.isSelected();
    }

    public void setEnableQueryRewrite(boolean b) {
        this._queryRewriteCheck.setSelected(b);
    }

    public boolean getUseIndex() {
        return this._useindexCheckBox.isSelected();
    }

    public void setUseIndex(boolean b) {
        this._useindexCheckBox.setSelected(b);
    }

    public String getBuildType() {
        return (String)this._buildTypeComboBox.getSelectedItem();
    }

    public void setBuildType(String s) {
        this._buildTypeComboBox.setSelectedItem(s);
    }

    protected void init(DBObjectProvider prov, MaterializedView mview, MViewInfoVerifier verifier, Schema[] schemas) {
        this.m_verifier = verifier;
        OracleDatabase db = (OracleDatabase)prov;
        int parallel = mview.getParallel();
        this._parallelValue.setText(Integer.toString(parallel));
        if (parallel == 0) {
            this._parallelCheckBox.setSelected(false);
            this._parallelCheckBox.setEnabled(this.m_verifier.canMVOParallel());
            this._parallelValue.setEnabled(false);
        } else {
            this._parallelCheckBox.setSelected(this.m_verifier.canMVOParallel());
            this._parallelCheckBox.setEnabled(this.m_verifier.canMVOParallel());
            this._parallelValue.setEnabled(this.m_verifier.canMVOParallel());
        }
        this._enableCacheCheckBox.setSelected(mview.isCache());
        this._enableCacheCheckBox.setEnabled(this.m_verifier.canMVOEnableCache());
        this._queryRewriteCheck.setSelected(mview.isRewrite());
        this._queryRewriteCheck.setEnabled(this.m_verifier.canMVOQueryRewrite());
        if (mview.getBuildType() == 0) {
            this._buildTypeComboBox.setSelectedItem(CreateDialogArb.getString(547));
        } else if (mview.getBuildType() == 1) {
            this._buildTypeComboBox.setSelectedItem(CreateDialogArb.getString(548));
        }
        this._buildTypeComboBox.setEnabled(this.m_verifier.canMVOPrebuilt());
        this._buildTypeLabel.setEnabled(this.m_verifier.canMVOPrebuilt());
        this._prebuiltCheckBox.setEnabled(this.m_verifier.canMVOPrebuilt());
        if (mview.isPrebuilt()) {
            this._prebuiltCheckBox.setEnabled(this.m_verifier.canMVOPrebuilt());
            this._prebuiltCheckBox.setSelected(true);
            this._reducedPrecisionRadio.setEnabled(this.m_verifier.canMVOPrebuilt());
            this._noReducedRadio.setEnabled(this.m_verifier.canMVOPrebuilt());
        } else {
            this._prebuiltCheckBox.setSelected(false);
            this._reducedPrecisionRadio.setEnabled(false);
            this._noReducedRadio.setEnabled(false);
        }
        String[] tsList = db.listTablespaces();
        this.indexTablespaceComboBox.removeAllItems();
        for (int i = 0; i < tsList.length; ++i) {
            this.indexTablespaceComboBox.addItem(tsList[i]);
        }
        this._useindexCheckBox.setEnabled(this.m_verifier.canUseIndex());
        if (mview.isUseNoIndex()) {
            this._useindexCheckBox.setSelected(false);
            this._indexUseCheckBox.setEnabled(false);
        } else {
            this._useindexCheckBox.setSelected(this.m_verifier.canUseIndex());
            this._indexUseCheckBox.setEnabled(this.m_verifier.canUseIndex());
        }
        if (mview.getTablespace() == null || mview.getTablespace().equals("")) {
            this._indexUseCheckBox.setSelected(false);
            this.indexTablespaceComboBox.setEnabled(false);
            this.indexTablespaceComboBox.setSelectedItem(null);
        } else {
            this._indexUseCheckBox.setEnabled(this.m_verifier.canUseIndex());
            this._indexUseCheckBox.setSelected(true);
            this.indexTablespaceComboBox.setEnabled(this.m_verifier.canUseIndex());
            this.indexTablespaceComboBox.setSelectedItem(mview.getTablespace());
        }
    }

    public void commit(MaterializedView mview, Schema[] schema, boolean isForward) throws TraversalException {
        int parallelValue = 0;
        if (this._parallelCheckBox.isSelected()) {
            String textIn = this._parallelValue.getText();
            try {
                parallelValue = textIn == null || textIn.equals("") ? 0 : Integer.parseInt(textIn);
            }
            catch (NumberFormatException e) {
                parallelValue = 0;
            }
        }
        mview.setParallel(parallelValue);
        mview.setCache(this._enableCacheCheckBox.isSelected());
        mview.setRewrite(this._queryRewriteCheck.isSelected());
        mview.setUseNoIndex(true);
        if (((String)this._buildTypeComboBox.getSelectedItem()).equals(CreateDialogArb.getString(547))) {
            mview.setBuildType(0);
        } else if (((String)this._buildTypeComboBox.getSelectedItem()).equals(CreateDialogArb.getString(548))) {
            mview.setBuildType(1);
        }
        mview.setUseNoIndex(!this._useindexCheckBox.isSelected());
        if (this._indexUseCheckBox.isSelected()) {
            mview.setTablespace((String)this.indexTablespaceComboBox.getSelectedItem());
        } else {
            mview.setTablespace(null);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridLayout(0, 1));
        this.northPane.setLayout(new GridBagLayout());
        this.northPane.add((Component)this._parallelCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.northPane.add((Component)this._parallelValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 71, 0));
        this.northPane.add((Component)this._enableCacheCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.northPane.add((Component)this._buildTypeLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.northPane.add((Component)this._buildTypeComboBox, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.northPane.add((Component)this._queryRewriteCheck, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.northPane.add((Component)this._prebuiltCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 0), 51, 0));
        this.northPane.add((Component)this._reducedPrecisionRadio, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 15, 0, 0), 0, 0));
        this.northPane.add((Component)this._noReducedRadio, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 15, 0, 0), 0, 0));
        this.centerPane.setLayout(new GridBagLayout());
        this.centerPane.add((Component)this._useindexCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 19, 1));
        this.centerPane.add((Component)this.indexTablespaceComboBox, new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 14), 26, 0));
        this.centerPane.add((Component)this._indexUseCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 6), 2, 0));
        this.add(this.northPane);
        this.add(this.centerPane);
        this.northPane.setBorder(BorderFactory.createTitledBorder("Materialized View Options"));
        this.centerPane.setBorder(BorderFactory.createTitledBorder("Index Storage"));
        this.centerPane.setToolTipText("null");
        this._enableCacheCheckBox.setText("Enable Cache");
        this._enableCacheCheckBox.setToolTipText("Place frequently accessed data to the top of the buffer cache");
        this._enableCacheCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewRightPanel.this._cacheCheck_actionPerformed(e);
            }
        });
        this._indexUseCheckBox.setText("Use Tablespace");
        this._indexUseCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewRightPanel.this.jRadioButton2_actionPerformed(e);
            }
        });
        this._buildTypeLabel.setText("Build Type");
        ButtonGroup bg = new ButtonGroup();
        this.setToolTipText("null");
        this._useindexCheckBox.setText("Use Index");
        this._useindexCheckBox.setToolTipText("null");
        this._useindexCheckBox.setEnabled(true);
        this._useindexCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewRightPanel.this._useindexCheckBox_actionPerformed(e);
            }
        });
        this._indexUseCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewRightPanel.this._indexUseCheckBox_actionPerformed(e);
            }
        });
        this._parallelCheckBox.setText("Parallel");
        this._parallelCheckBox.setToolTipText("Use multiple threads when creating this object or when executing DML against this object");
        this._parallelCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewRightPanel.this._parallelCheckBox_actionPerformed(e);
            }
        });
        this._parallelValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewRightPanel.this._parallelValue_actionPerformed(e);
            }
        });
        this._parallelValue.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                    MviewRightPanel.this.getToolkit().beep();
                    e.consume();
                }
            }
        });
        this._parallelValue.setEnabled(this._parallelCheckBox.isEnabled());
        this.indexTablespaceComboBox.setMaximumSize(new Dimension(40, 20));
        this.indexTablespaceComboBox.setSize(new Dimension(34, 20));
        this._buildTypeComboBox.setSelectedIndex(0);
        this._queryRewriteCheck.setText("Enable Query Rewrite");
        this._prebuiltCheckBox.setText("Prebuit Option");
        this._prebuiltCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MviewRightPanel.this._prebuiltCheckBox_actionPerformed(e);
            }
        });
        this._reducedPrecisionRadio.setText("Reduced Precision");
        this._noReducedRadio.setText("No Reduced Precision");
        this.bgPrebuilt.add(this._noReducedRadio);
        this.bgPrebuilt.add(this._reducedPrecisionRadio);
        this._noReducedRadio.setEnabled(false);
        this._reducedPrecisionRadio.setEnabled(false);
    }

    private void _indexUseCheckBox_actionPerformed(ActionEvent e) {
        if (this._indexUseCheckBox.isSelected()) {
            this.indexTablespaceComboBox.setEnabled(this.m_verifier.canUseIndex());
        } else {
            this.indexTablespaceComboBox.setEnabled(false);
            this.indexTablespaceComboBox.setSelectedItem(null);
        }
    }

    private void _useindexCheckBox_actionPerformed(ActionEvent e) {
        if (this._useindexCheckBox.isSelected()) {
            this._indexUseCheckBox.setEnabled(this.m_verifier.canUseIndex());
        } else {
            this._indexUseCheckBox.setEnabled(false);
            this._indexUseCheckBox.setSelected(false);
            this.indexTablespaceComboBox.setEnabled(false);
            this.indexTablespaceComboBox.setSelectedItem(null);
        }
    }

    private void _parallelValue_actionPerformed(ActionEvent e) {
    }

    private void _parallelCheckBox_actionPerformed(ActionEvent e) {
        if (this._parallelCheckBox.isSelected()) {
            this._parallelValue.setEnabled(this.m_verifier.canMVOParallel());
            if (this._parallelCheckBox.isSelected()) {
                this._parallelValue.setEditable(true);
            } else {
                this._parallelValue.setEditable(false);
            }
        } else {
            this._parallelValue.setEnabled(false);
            this._parallelValue.setEditable(false);
        }
    }

    private void _valueParallelRadio_actionPerformed(ActionEvent e) {
        this._parallelValue.setEditable(true);
    }

    private void _defaultParallelRadio_actionPerformed(ActionEvent e) {
        this._parallelValue.setEditable(false);
    }

    private void _cacheCheck_actionPerformed(ActionEvent e) {
    }

    private void jButton2_actionPerformed(ActionEvent e) {
    }

    private void jComboBox1_actionPerformed(ActionEvent e) {
    }

    private void jRadioButton2_actionPerformed(ActionEvent e) {
        if (this._indexUseCheckBox.isSelected()) {
            this.indexTablespaceComboBox.setEnabled(this.m_verifier.canUseIndex());
        } else {
            this.indexTablespaceComboBox.setEnabled(false);
        }
    }

    private void _extentTextField_actionPerformed(ActionEvent e) {
    }

    private void _prebuiltCheckBox_actionPerformed(ActionEvent e) {
        if (this._prebuiltCheckBox.isSelected()) {
            this._reducedPrecisionRadio.setEnabled(true);
            this._noReducedRadio.setEnabled(true);
        } else {
            this._reducedPrecisionRadio.setEnabled(false);
            this._noReducedRadio.setEnabled(false);
        }
    }
}

