/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.plsql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.dialogs.plsql.ParamsModel;
import oracle.dbtools.raptor.dialogs.plsql.PlSqlParametersVerifier;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class PlSqlParametersPanel
extends BaseInfoPanel {
    private JButton btnAdd = new JButton();
    private JButton btnRemove = new JButton();
    private JButton btnUp = new JButton();
    private JButton btnDown = new JButton();
    private JScrollPane scrParams = new JScrollPane();
    private JTable tblParams = new JTable();
    private DBObjectRenderer _renderer;
    private NonNullableComboBoxModel _mdlMode = new NonNullableComboBoxModel();
    private TableColumnModel _mdlCols = new DefaultTableColumnModel();
    private ParamsModel _mdlParams = new ParamsModel();
    private L _listener = new L();
    private static final String ADD_CMD = "ADD";
    private static final String REMOVE_CMD = "REMOVE";
    private static final String UP_CMD = "UP";
    private static final String DOWN_CMD = "DOWN";

    public PlSqlParametersPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.init((DBObjectProvider)traversableContext.find("DBObjectProvider"), (DeclarativePlSql)traversableContext.find("NewObject"), (Verifier)traversableContext.find("PlSqlParametersVerifier"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((DeclarativePlSql)traversableContext.find("NewObject"), (PlSqlParametersVerifier)traversableContext.find("PlSqlParametersVerifier"));
    }

    protected void init(DBObjectProvider prov, DeclarativePlSql plsql, Verifier ver) {
        super.init(prov, ver);
        this._mdlParams.init(prov, plsql, plsql instanceof Function);
    }

    protected void commit(DeclarativePlSql plsql, PlSqlParametersVerifier verifier) throws TraversalException {
        this._mdlParams.commit(plsql, verifier);
    }

    private void jbInit() throws Exception {
        TableColumn colName = new TableColumn(0);
        colName.setHeaderValue("Name");
        colName.setCellRenderer((TableCellRenderer)this._renderer);
        this._mdlCols.addColumn(colName);
        TableColumn colType = new TableColumn(1);
        colType.setHeaderValue("Type");
        colType.setCellRenderer((TableCellRenderer)this._renderer);
        this._mdlCols.addColumn(colType);
        this._mdlMode.addElement((Object)"");
        for (PlSqlParameter.Mode mode : PlSqlParameter.Mode.values()) {
            this._mdlMode.addElement((Object)mode);
        }
        TableColumn colMode = new TableColumn(2);
        colMode.setHeaderValue("Mode");
        colMode.setCellEditor(new DefaultCellEditor(new JComboBox(this._mdlMode)));
        this._mdlCols.addColumn(colMode);
        TableColumn colDefault = new TableColumn(3);
        colDefault.setHeaderValue("Default Value");
        this._mdlCols.addColumn(colDefault);
        this.tblParams.setModel(this._mdlParams);
        this.tblParams.setColumnModel(this._mdlCols);
        this.tblParams.getSelectionModel().addListSelectionListener(this._listener);
        this.setLayout(new BorderLayout());
        Dimension size = new Dimension(28, 25);
        this.btnUp.setPreferredSize(size);
        this.btnUp.setIcon(ComponentArb.getIcon((int)0));
        this.btnUp.setDisabledIcon(ComponentArb.getIcon((int)2));
        DBObjectRenderer.setToolTipText((JComponent)this.btnUp, (String)CmWizardsArb.getString((int)46));
        this.btnUp.setActionCommand(UP_CMD);
        this.btnUp.addActionListener(this._listener);
        this.btnUp.setEnabled(false);
        this.btnDown.setPreferredSize(size);
        this.btnDown.setIcon(ComponentArb.getIcon((int)1));
        this.btnDown.setDisabledIcon(ComponentArb.getIcon((int)3));
        DBObjectRenderer.setToolTipText((JComponent)this.btnDown, (String)CmWizardsArb.getString((int)47));
        this.btnDown.setActionCommand(DOWN_CMD);
        this.btnDown.addActionListener(this._listener);
        this.btnDown.setEnabled(false);
        this.btnAdd.setPreferredSize(size);
        this.btnAdd.setIcon(ConnectionArb.getIcon((int)493));
        DBObjectRenderer.setToolTipText((JComponent)this.btnAdd, (String)CmWizardsArb.getString((int)44));
        this.btnAdd.setActionCommand(ADD_CMD);
        this.btnAdd.addActionListener(this._listener);
        this.btnRemove.setPreferredSize(size);
        this.btnRemove.setIcon(ConnectionArb.getIcon((int)494));
        DBObjectRenderer.setToolTipText((JComponent)this.btnRemove, (String)CmWizardsArb.getString((int)45));
        this.btnRemove.setActionCommand(REMOVE_CMD);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(this._listener);
        JPanel pnlButtons = new JPanel(new GridBagLayout());
        pnlButtons.add((Component)this.btnAdd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlButtons.add((Component)this.btnRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        pnlButtons.add((Component)this.btnUp, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 0, 0), 0, 0));
        pnlButtons.add((Component)this.btnDown, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(pnlButtons, "East");
        this.tblParams.setSelectionMode(0);
        this.scrParams.getViewport().add((Component)this.tblParams, null);
        this.add(this.scrParams, "Center");
    }

    private class L
    implements ListSelectionListener,
    ActionListener {
        private L() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int row = PlSqlParametersPanel.this.tblParams.getSelectedRow();
            this.updateButtons(row);
        }

        private void updateButtons(int row) {
            PlSqlParametersPanel.this.btnRemove.setEnabled(PlSqlParametersPanel.this._mdlParams.canRemoveRow(row));
            PlSqlParametersPanel.this.btnUp.setEnabled(PlSqlParametersPanel.this._mdlParams.canMoveRowUp(row));
            PlSqlParametersPanel.this.btnDown.setEnabled(PlSqlParametersPanel.this._mdlParams.canMoveRowDown(row));
        }

        public void actionPerformed(ActionEvent e) {
            int sel = PlSqlParametersPanel.this.tblParams.getSelectedRow();
            String cmd = e.getActionCommand();
            if (PlSqlParametersPanel.ADD_CMD.equals(cmd)) {
                if (sel >= 0) {
                    PlSqlParametersPanel.this._mdlParams.addParameter(sel);
                } else {
                    PlSqlParametersPanel.this._mdlParams.addParameter();
                }
            } else if (PlSqlParametersPanel.REMOVE_CMD.equals(cmd)) {
                PlSqlParametersPanel.this._mdlParams.removeParameter(sel);
            } else if (PlSqlParametersPanel.UP_CMD.equals(cmd)) {
                PlSqlParametersPanel.this._mdlParams.moveUp(sel);
            } else if (PlSqlParametersPanel.DOWN_CMD.equals(cmd)) {
                PlSqlParametersPanel.this._mdlParams.moveDown(sel);
            }
        }
    }
}

