/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.plsql;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.sql.SQLException;
import oracle.dbtools.raptor.dialogs.plsql.PlSqlLauncher;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Database;
import oracle.javatools.db.PlSqlSubprogram;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.ui.TabbedDBPanel;

public class PlSqlTabbedPanel
extends TabbedDBPanel {
    public static final String CONN_NAME_KEY = "ConnectionName";

    public PlSqlTabbedPanel(Navigable[] navs) {
        super(navs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createObject(TraversableContext tc, String key) throws TraversalException {
        PlSqlSubprogram pls = (PlSqlSubprogram)tc.find(key);
        final OracleDatabase db = (OracleDatabase)tc.find("DBObjectProvider");
        String connName = (String)tc.find(CONN_NAME_KEY);
        DDLGenerator gen = (DDLGenerator)tc.find("DDlGenerator");
        final Schema schema = pls.getSchema();
        final String name = pls.getName();
        final String dbType = pls.getType();
        URL url = CmUtil.getNodeURL((String)connName, null, (String)schema.getName(), (String)dbType, (String)name, null);
        final Node cbn = JdbcNodeFactory.getNode((Database)db, (URL)url);
        if (cbn instanceof TextNode) {
            cbn.addNodeListener(new NodeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nodeSaved(NodeEvent e) {
                    try {
                        SchemaObject obj = db.getObject(dbType, schema, name);
                        if (obj != null && db instanceof AbstractDatabase) {
                            ((AbstractDatabase)db).fireObjectsAdded(schema, new SchemaObject[]{obj});
                        }
                    }
                    catch (DBException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof SQLException) {
                            SQLErrorDialog.showErrorDialog((Component)((Object)PlSqlTabbedPanel.this), (String)"Error Creating PL/SQL Subprogram", (SQLException)((SQLException)cause));
                        } else {
                            ExceptionDialog.showExceptionDialog((Component)((Object)PlSqlTabbedPanel.this), (Throwable)ex);
                        }
                    }
                    finally {
                        cbn.removeNodeListener((NodeListener)this);
                    }
                }

                public void nodeClosed(NodeEvent e) {
                    cbn.removeNodeListener((NodeListener)this);
                }
            });
            TextBuffer buf = null;
            try {
                buf = ((TextNode)cbn).acquireTextBuffer();
                buf.beginEdit();
                buf.removeToEnd(0);
                String text = PlSqlLauncher.getDDL(pls, gen);
                buf.append(text.toCharArray());
            }
            finally {
                if (buf != null) {
                    buf.endEdit();
                    ((TextNode)cbn).releaseTextBuffer();
                }
            }
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                EditorUtil.openDefaultEditorInFrame((Node)cbn);
            }
        });
    }
}

