/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.sequence;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dbtools.raptor.dialogs.sequence.SequenceInfoVerifier;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Sequence;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.DBObjectOnePagePanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.SchemaPicker;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class SequencePanel
extends DBObjectOnePagePanel
implements ItemListener {
    public static final String TABLESPACES_KEY = "Tablespaces";
    private GridBagLayout m_layCenter = new GridBagLayout();
    private JLabel m_lblSchemaName = new JLabel();
    private JLabel m_lblSequenceName = new JLabel();
    private JLabel m_lblStartWith = new JLabel();
    private JLabel m_lblIncrement = new JLabel();
    private JLabel m_lblMinValue = new JLabel();
    private JLabel m_lblMaxValue = new JLabel();
    private JLabel m_lblCacheSize = new JLabel();
    private SchemaPicker m_cmbSchema = new SchemaPicker();
    private JTextField m_txtSequenceName = new JTextField();
    private SequenceNumberField m_fldStartWith = new SequenceNumberField();
    private SequenceNumberField m_fldIncrement = new SequenceNumberField();
    private SequenceNumberField m_fldMinValue = new SequenceNumberField();
    private SequenceNumberField m_fldMaxValue = new SequenceNumberField();
    private SequenceNumberField m_fldCacheSize = new SequenceNumberField();
    private JCheckBox m_cbxCycle = new JCheckBox();
    private JCheckBox m_cbxCache = new JCheckBox();
    private JCheckBox m_cbxOrder = new JCheckBox();
    private static final String[] EXTENTS_SIZES = new String[]{"", "K", "M"};
    private static final int K = 1024;
    private static final int M = 0x100000;
    private DBObjectRenderer m_renderer = new DBObjectRenderer();
    private DefaultComboBoxModel m_mdlSchema = new NonNullableComboBoxModel();
    private Map m_schemaMap = new HashMap();

    public SequencePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layCenter);
        this.m_cmbSchema.setModel((ComboBoxModel)this.m_mdlSchema);
        this.m_cmbSchema.setRenderer((ListCellRenderer)this.m_renderer);
        ResourceUtils.resLabel((JLabel)this.m_lblSchemaName, (Component)this.m_cmbSchema, (String)CmWizardsArb.getString((int)17));
        ResourceUtils.resLabel((JLabel)this.m_lblSequenceName, (Component)this.m_txtSequenceName, (String)CmWizardsArb.getString((int)18));
        ResourceUtils.resLabel((JLabel)this.m_lblStartWith, (Component)((Object)this.m_fldStartWith), (String)CmWizardsArb.getString((int)364));
        ResourceUtils.resLabel((JLabel)this.m_lblIncrement, (Component)((Object)this.m_fldIncrement), (String)CmWizardsArb.getString((int)365));
        ResourceUtils.resLabel((JLabel)this.m_lblMinValue, (Component)((Object)this.m_fldMinValue), (String)CmWizardsArb.getString((int)366));
        ResourceUtils.resLabel((JLabel)this.m_lblMaxValue, (Component)((Object)this.m_fldMaxValue), (String)CmWizardsArb.getString((int)367));
        ResourceUtils.resButton((AbstractButton)this.m_cbxCycle, (String)CmWizardsArb.getString((int)368));
        this.m_cbxCycle.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_cbxCache, (String)CmWizardsArb.getString((int)369));
        this.m_cbxCache.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_cbxOrder, (String)CmWizardsArb.getString((int)370));
        this.m_cbxOrder.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblCacheSize, (Component)((Object)this.m_fldCacheSize), (String)CmWizardsArb.getString((int)371));
        this.m_fldCacheSize.setEnabled(false);
        this.m_fldCacheSize.setEditable(false);
        this.add(this.m_lblSchemaName, new GridBagConstraints(10, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbSchema, new GridBagConstraints(20, 10, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblSequenceName, new GridBagConstraints(10, 20, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_txtSequenceName, new GridBagConstraints(20, 20, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblIncrement, new GridBagConstraints(10, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldIncrement), new GridBagConstraints(20, 30, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 12, 0, 0), 0, 0));
        this.add(this.m_lblMinValue, new GridBagConstraints(30, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 24, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldMinValue), new GridBagConstraints(40, 30, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 12, 0, 0), 0, 0));
        this.add(this.m_lblStartWith, new GridBagConstraints(10, 40, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldStartWith), new GridBagConstraints(20, 40, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblMaxValue, new GridBagConstraints(30, 40, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldMaxValue), new GridBagConstraints(40, 40, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_cbxCycle, new GridBagConstraints(20, 50, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 12, 0, 0), 0, 0));
        this.add(this.m_cbxCache, new GridBagConstraints(20, 60, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblCacheSize, new GridBagConstraints(30, 60, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldCacheSize), new GridBagConstraints(40, 60, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_cbxOrder, new GridBagConstraints(20, 70, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return CmWizardsArb.getString((int)362);
    }

    public Image getHeaderImage() {
        return ConnectionArb.getImage((int)448);
    }

    public String getHeaderDescription() {
        return CmWizardsArb.getString((int)363);
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        Sequence sequence = (Sequence)dataContext.find("NewObject");
        SequenceInfoVerifier verifier = (SequenceInfoVerifier)((Object)dataContext.find(SequenceInfoVerifier.KEY));
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.init(prov, sequence, verifier, schemas);
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        if (callbacks != null) {
            callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            callbacks.wizardSetInitialFocus((Component)this.m_txtSequenceName);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        Sequence sequence = (Sequence)dataContext.find("NewObject");
        if (sequence == null) {
            sequence = new Sequence();
        }
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.commit(sequence, schemas, dataContext.getDirection() != 2);
    }

    private void init(DBObjectProvider prov, Sequence model, SequenceInfoVerifier verifier, Schema[] schemas) {
        BigInteger maxValue;
        BigInteger minValue;
        BigInteger increment;
        super.init(prov, (Verifier)verifier);
        this.m_cmbSchema.setProvider(prov);
        this.m_renderer.setProvider(prov);
        this.m_mdlSchema.removeAllElements();
        for (int i = 0; i < schemas.length; ++i) {
            this.m_mdlSchema.addElement(schemas[i]);
        }
        Schema schema = model.getSchema();
        if (schema != null) {
            if (this.m_mdlSchema.getIndexOf(schema) < 0) {
                this.m_mdlSchema.addElement(schema);
            }
            this.m_mdlSchema.setSelectedItem(schema);
        }
        this.m_cmbSchema.setEnabled(verifier == null || verifier.canChangeSchema());
        this.m_cmbSchema.setEditable(verifier == null || verifier.canCreateSchema());
        this.m_txtSequenceName.setText(this.getExternalName(model.getName()));
        this.m_txtSequenceName.setEnabled(verifier == null || verifier.canChangeName());
        BigInteger startWith = model.getStartWith();
        if (null != startWith) {
            this.m_fldStartWith.setNumber(startWith);
        }
        if (null != (increment = model.getIncrementBy())) {
            this.m_fldIncrement.setNumber(increment);
        }
        if (null != (minValue = model.getMinValue())) {
            this.m_fldMinValue.setNumber(minValue);
        }
        if (null != (maxValue = model.getMaxValue())) {
            this.m_fldMaxValue.setNumber(maxValue);
        }
        this.m_cbxCycle.setSelected(model.getCycleFlag() == Boolean.TRUE);
        BigInteger cacheSize = model.getCacheSize();
        if (null != cacheSize && cacheSize.signum() > 0) {
            this.m_cbxCache.setSelected(true);
            this.m_fldCacheSize.setNumber(cacheSize);
            this.m_fldCacheSize.setEditable(true);
            this.m_fldCacheSize.setEnabled(true);
        } else {
            this.m_cbxCache.setSelected(false);
            this.m_fldCacheSize.setEditable(false);
            this.m_fldCacheSize.setEnabled(false);
        }
        this.m_fldCacheSize.setSigned(false);
        this.m_cbxOrder.setSelected(model.getOrderFlag() == Boolean.TRUE);
        if (verifier != null) {
            this.m_lblSchemaName.setEnabled(verifier.canChangeSchema());
            this.m_lblSequenceName.setEnabled(verifier.canChangeName());
            this.m_txtSequenceName.setEditable(verifier.canChangeName());
            this.m_txtSequenceName.setEnabled(verifier.canChangeName());
            this.m_lblStartWith.setEnabled(verifier.canEditStartWith());
            this.m_fldStartWith.setEditable(verifier.canEditStartWith());
            this.m_fldStartWith.setEnabled(verifier.canEditStartWith());
            this.m_lblIncrement.setEnabled(verifier.canChangeIncrement());
            this.m_fldIncrement.setEditable(verifier.canChangeIncrement());
            this.m_fldIncrement.setEnabled(verifier.canChangeIncrement());
            this.m_lblMaxValue.setEnabled(verifier.canChangeMaxValue());
            this.m_fldMaxValue.setEditable(verifier.canChangeMaxValue());
            this.m_fldMaxValue.setEnabled(verifier.canChangeMaxValue());
            this.m_lblMinValue.setEnabled(verifier.canChangeMinValue());
            this.m_fldMinValue.setEditable(verifier.canChangeMinValue());
            this.m_fldMinValue.setEnabled(verifier.canChangeMinValue());
            this.m_cbxCache.setEnabled(verifier.canChangeCache());
            this.m_cbxCycle.setEnabled(verifier.canChangeCycle());
            this.m_cbxOrder.setEnabled(verifier.canChangeOrder());
            this.m_lblCacheSize.setEnabled(verifier.canChangeCacheSize());
            this.m_fldCacheSize.setEditable(verifier.canChangeCacheSize());
            this.m_fldCacheSize.setEnabled(verifier.canChangeCacheSize());
        }
    }

    private void commit(Sequence sequence, Schema[] schemas, boolean forward) throws TraversalException {
        SequenceInfoVerifier verifier = (SequenceInfoVerifier)this.getVerifier();
        DBObjectProvider prov = this.getProvider();
        Schema schema = this.m_cmbSchema.getSchema(schemas);
        BigInteger biStartWith = (BigInteger)this.m_fldStartWith.getNumber();
        BigInteger biIncrement = (BigInteger)this.m_fldIncrement.getNumber();
        BigInteger biMinValue = (BigInteger)this.m_fldMinValue.getNumber();
        BigInteger biMaxValue = (BigInteger)this.m_fldMaxValue.getNumber();
        Boolean cycle = this.m_cbxCycle.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        BigInteger biCacheSize = null;
        if (this.m_cbxCache.isSelected() && null == (biCacheSize = (BigInteger)this.m_fldCacheSize.getNumber())) {
            biCacheSize = this.getCacheSizeDefault();
        }
        Boolean order = this.m_cbxOrder.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        sequence.setStartWith(biStartWith);
        sequence.setIncrementBy(biIncrement);
        sequence.setMinValue(biMinValue);
        sequence.setMaxValue(biMaxValue);
        sequence.setCycleFlag(cycle);
        sequence.setCacheSize(biCacheSize);
        sequence.setOrderFlag(order);
        if (null != verifier) {
            verifier.verifyMinValue();
            verifier.verifyMaxValue();
            if (forward) {
                verifier.verifySequence();
            }
        }
        sequence.setSchema(schema);
        sequence.setName(this.getInternalName(this.m_txtSequenceName.getText()));
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() != this.m_cbxCycle) {
            if (e.getItem() == this.m_cbxCache) {
                if (this.m_cbxCache.isSelected()) {
                    this.m_fldCacheSize.setNumber(this.getCacheSizeDefault());
                    this.m_fldCacheSize.setEnabled(true);
                    this.m_fldCacheSize.setEditable(true);
                } else {
                    this.m_fldCacheSize.setNumber(null);
                    this.m_fldCacheSize.setEnabled(false);
                    this.m_fldCacheSize.setEditable(false);
                }
            } else if (e.getItem() == this.m_cbxOrder) {
                // empty if block
            }
        }
    }

    private BigInteger getCacheSizeDefault() {
        BigInteger twenty;
        BigInteger max = (BigInteger)this.m_fldMaxValue.getNumber();
        BigInteger min = (BigInteger)this.m_fldMinValue.getNumber();
        BigInteger inc = (BigInteger)this.m_fldIncrement.getNumber();
        if (null == inc) {
            inc = BigInteger.ONE;
        }
        if (null == max) {
            max = inc.signum() > 0 ? BigInteger.valueOf(10L).pow(27) : BigInteger.ONE.negate();
        }
        if (null == min) {
            min = inc.signum() > 0 ? BigInteger.ONE : BigInteger.valueOf(10L).pow(26).negate();
        }
        BigInteger[] dr = max.subtract(min).abs().divideAndRemainder(inc.abs());
        BigInteger def = dr[0];
        if (dr[1].signum() > 0) {
            def = def.add(BigInteger.ONE);
        }
        if (def.subtract(twenty = new BigInteger("20")).signum() > 0) {
            def = twenty;
        }
        return def;
    }

    private static class SequenceNumberField
    extends NumberTextField {
        private BigInteger m_maxValue = BigInteger.valueOf(10L).pow(28).subtract(BigInteger.ONE);

        public SequenceNumberField() {
            this.setDataType(BigInteger.class);
            this.setSigned(true);
        }

        protected String convertNumberToString(Number n) {
            return n.toString();
        }

        protected boolean validateNumber(Number n) {
            return n == null || ((BigInteger)n).abs().compareTo(this.m_maxValue) <= 0;
        }

        public BigInteger getMaximumValue() {
            return this.m_maxValue;
        }

        public void setMaximumValue(BigInteger max) {
            this.m_maxValue = max;
        }
    }
}

