/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.synonym;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.jdeveloper.cm.dt.ui.TabbedDBPanel;
import oracle.jdeveloper.cm.dt.verifier.SchemaObjectInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class TabbedSynonymPanel
extends TabbedDBPanel
implements ItemListener {
    public static final String PUBLIC = "PUBLIC";
    private JCheckBox _cbxPublic = new JCheckBox();
    private Schema _originalSchema = null;

    public TabbedSynonymPanel(Navigable[] navs) {
        super(navs);
    }

    protected JPanel buildPnlInfo() {
        JPanel pnlInfo = super.buildPnlInfo();
        ResourceUtils.resButton((AbstractButton)this._cbxPublic, (String)CmWizardsArb.getString((int)381));
        this._cbxPublic.addItemListener(this);
        pnlInfo.add((Component)this._cbxPublic, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        return pnlInfo;
    }

    protected void init(DBObjectProvider prov, SchemaObject obj, SchemaObjectInfoVerifier verifier, Schema[] schemas) {
        super.init(prov, obj, verifier, schemas);
        this._originalSchema = obj.getSchema();
        this._cbxPublic.setEnabled(verifier == null || verifier.canChangeSchema());
        if (obj instanceof Synonym) {
            Synonym model = (Synonym)obj;
            this._cbxPublic.setSelected(model.isPublic());
            this._cmbOwner.setEnabled((verifier == null || verifier.canChangeSchema()) && !model.isPublic());
            this._cmbOwner.setEditable((verifier == null || verifier.canChangeSchema()) && !model.isPublic());
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() == this._cbxPublic) {
            if (this._cbxPublic.isSelected()) {
                String name = PUBLIC;
                if (this._db != null) {
                    name = this._db.getInternalName(name, "SCHEMA");
                }
                Schema so = new Schema(name);
                this._cmbOwner.setSelectedItem((Object)so);
                this._cmbOwner.setEnabled(false);
                this._cmbOwner.setEditable(false);
                this._schemaObject.setSchema(so);
                if (this._schemaObject instanceof Synonym) {
                    Synonym synonym = (Synonym)this._schemaObject;
                    synonym.setPublic(true);
                }
            } else {
                this._cmbOwner.setEnabled(this._verifier == null || this._verifier.canChangeSchema());
                this._cmbOwner.setEditable(this._verifier == null || this._verifier.canChangeSchema());
                if (null == this._originalSchema || PUBLIC.equals(this._originalSchema.getName())) {
                    Schema[] schemas = this._schemas;
                    for (int i = 0; i < schemas.length; ++i) {
                        if (PUBLIC.equals(schemas[i].getName())) continue;
                        this._originalSchema = schemas[i];
                        break;
                    }
                }
                if (this._schemaObject instanceof Synonym) {
                    Synonym synonym = (Synonym)this._schemaObject;
                    synonym.setPublic(false);
                }
                this.setOriginalSchema();
                this.updateIdentifier(true);
            }
        }
    }

    protected void commit(SchemaObject orig, SchemaObject model, Schema[] schemas) throws TraversalException {
        if (model instanceof Synonym) {
            Synonym synonym = (Synonym)model;
            boolean pub = this._cbxPublic.isSelected();
            Schema schema = null;
            if (pub) {
                try {
                    schema = this._db.getSchema(PUBLIC);
                }
                catch (DBException dbe) {
                    Assert.println((String)dbe.getMessage());
                    Assert.printStackTrace((Throwable)dbe);
                }
            } else {
                schema = this._cmbOwner.getSchema(schemas);
            }
            synonym.setPublic(pub);
        }
        super.commit(orig, model, schemas);
    }

    private void setOriginalSchema() {
        if (this._originalSchema != null) {
            if (this._mdlOwner.getIndexOf(this._originalSchema) < 0) {
                this._mdlOwner.addElement(this._originalSchema);
            }
            if (!PUBLIC.equals(this._originalSchema.getName())) {
                try {
                    this._mdlOwner.removeElement(this._db.getSchema(PUBLIC));
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            this._mdlOwner.setSelectedItem(this._originalSchema);
        }
    }
}

