/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.table;

import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.jdeveloper.cm.dt.verifier.table.AbstractTableVerifier;
import oracle.jdeveloper.cm.dt.verifier.table.StorageInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class CreationStorageInfoVerifier
extends AbstractTableVerifier
implements StorageInfoVerifier {
    public boolean canChangeTablespace() {
        return true;
    }

    public boolean canChangePercentFree() {
        return true;
    }

    public boolean canChangePercentUsed() {
        return true;
    }

    public boolean canChangeInitrans() {
        return true;
    }

    public boolean canChangeMaxtrans() {
        return true;
    }

    public boolean canChangeInitialExtent() {
        return true;
    }

    public boolean canChangeNextExtent() {
        return true;
    }

    public boolean canChangeMinExtent() {
        return true;
    }

    public boolean canChangeMaxExtent() {
        return true;
    }

    public boolean canChangePercentIncrease() {
        return true;
    }

    public boolean canChangeLogging() {
        return true;
    }

    public boolean canChangeFreelists() {
        return true;
    }

    public boolean canChangeFreelistGroups() {
        return true;
    }

    public boolean canChangeBufferMode() {
        return true;
    }

    public void verifyRelation() throws TraversalException {
        Table table = (Table)this.getModifiedRelation();
        OracleStorageProperties oProps = (OracleStorageProperties)table.getProperty("OracleStorageProperties");
        if (oProps != null) {
            int i;
            int iUsed;
            int iFree;
            Integer pctFree = oProps.getPercentFree();
            int n = iFree = pctFree != null ? pctFree : 0;
            if (iFree < 0 || iFree > 99) {
                throw new TraversalException(CmWizardsArb.getString((int)168), CmWizardsArb.getString((int)173), null);
            }
            Integer pctUsed = oProps.getPercentUsed();
            int n2 = iUsed = pctUsed != null ? pctUsed : 0;
            if (iUsed < 0 || iUsed > 99) {
                throw new TraversalException(CmWizardsArb.getString((int)169), CmWizardsArb.getString((int)173), null);
            }
            if (iFree + iUsed > 100) {
                throw new TraversalException(CmWizardsArb.getString((int)170), CmWizardsArb.getString((int)173), null);
            }
            Integer iniTrans = oProps.getInitrans();
            int n3 = i = iniTrans != null ? iniTrans : 1;
            if (i < 1 || i > 255) {
                throw new TraversalException(CmWizardsArb.getString((int)171), CmWizardsArb.getString((int)173), null);
            }
            Integer maxTrans = oProps.getMaxtrans();
            int n4 = i = maxTrans != null ? maxTrans : 1;
            if (i < 1 || i > 255) {
                throw new TraversalException(CmWizardsArb.getString((int)172), CmWizardsArb.getString((int)173), null);
            }
        }
    }
}

