/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.table;

import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.dbtools.raptor.dialogs.table.PopulatePKPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Trigger;
import oracle.jdeveloper.cm.dt.ui.table.ConstraintColumnSelectionPanel;
import oracle.jdeveloper.cm.dt.ui.table.PKConstraintPanel;

public class PKConstraintTab
extends PKConstraintPanel {
    protected ConstraintColumnSelectionPanel createColumnPanel() {
        return new PopulatePKPanel();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        super.onExit(dataContext);
        PopulatePKPanel pnl = (PopulatePKPanel)this.pnlColumns;
        if (pnl.isAutoPopulate()) {
            Trigger autoPopTrigger = new Trigger(this._tbl.getSchema(), pnl.getTriggerName());
            autoPopTrigger.setTableName(this._tbl.getName());
            autoPopTrigger.setBaseType(0);
            autoPopTrigger.setTiming(0);
            ArrayList<String> events = new ArrayList<String>();
            events.add("INSERT");
            autoPopTrigger.setEvents(events);
            String template = "BEGIN  SELECT {0}.nextval   INTO :new.{1}   FROM dual; END;";
            String code = MessageFormat.format(template, pnl.getSequenceName(), pnl.getColumnName());
            autoPopTrigger.setCode(code);
            if (pnl.getNewSequence()) {
                Sequence autoPopSequence = new Sequence(pnl.getSequenceName(), this._tbl.getSchema());
                dataContext.put("AutoPopulatedSequence", (Object)autoPopSequence);
            }
            dataContext.put("AutoPopulatedTrigger", (Object)autoPopTrigger);
            dataContext.put("AutoPopulatedColumn", (Object)pnl.getColumnName());
            dataContext.put("AutoPopulatedNewSequence", (Object)new Boolean(pnl.getNewSequence()));
            dataContext.put("AutoPopulatedSequenceName", (Object)pnl.getSequenceName());
        } else {
            dataContext.remove("AutoPopulatedTrigger");
            dataContext.remove("AutoPopulatedColumn");
            dataContext.remove("AutoPopulatedNewSequence");
            dataContext.remove("AutoPopulatedSequenceName");
            dataContext.remove("AutoPopulatedSequence");
        }
    }
}

