/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.table;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;
import oracle.jdeveloper.cm.dt.ui.table.ConstraintColumnSelectionPanel;

public class PopulatePKPanel
extends ConstraintColumnSelectionPanel
implements ActionListener,
ListDataListener {
    private JLabel _lblColumns;
    private JComboBox _cmbColumns;
    private JLabel _lblFrom;
    private JRadioButton _rdbExisting;
    private JRadioButton _rdbNew;
    private JComboBox _cmbSequences;
    private JTextField _fldSequenceName;
    private JLabel _lblTriggerName;
    private JTextField _fldTriggerName;
    private DefaultComboBoxModel _mdlColumns;
    private DefaultComboBoxModel _mdlSequences;
    private Schema _schema;
    private boolean _init;

    public PopulatePKPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._init = false;
    }

    private void jbInit() throws Exception {
        this._lblColumns = new JLabel();
        this._cmbColumns = new JComboBox();
        this._lblFrom = new JLabel();
        this._rdbExisting = new JRadioButton();
        this._rdbNew = new JRadioButton();
        this._cmbSequences = new JComboBox();
        this._fldSequenceName = new JTextField();
        this._lblTriggerName = new JLabel();
        this._fldTriggerName = new JTextField();
        this._mdlColumns = new NonNullableComboBoxModel();
        this._mdlSequences = new NonNullableComboBoxModel();
        this._cmbColumns.setModel(this._mdlColumns);
        this._mdlColumns.addElement(CreateDialogArb.getString(513));
        this._cmbSequences.setModel(this._mdlSequences);
        this._cmbColumns.addActionListener(this);
        this._lblColumns.setText(CreateDialogArb.getString(508));
        this._lblFrom.setText(CreateDialogArb.getString(509));
        this._rdbExisting.setText(CreateDialogArb.getString(511));
        this._rdbNew.setText(CreateDialogArb.getString(510));
        this._lblTriggerName.setText(CreateDialogArb.getString(512));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._rdbExisting);
        bg.add(this._rdbNew);
        this._rdbExisting.setSelected(true);
        this._rdbExisting.addActionListener(this);
        this._rdbNew.addActionListener(this);
        this.add(this._lblColumns, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._cmbColumns, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._lblFrom, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._rdbExisting, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._cmbSequences, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._rdbNew, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._fldSequenceName, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._lblTriggerName, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._fldTriggerName, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void init(Namespace namespace) {
        super.init(namespace);
        this.mdlTo.addListDataListener(this);
        this._schema = (Schema)namespace.find("Schema");
        if (!this._init) {
            this._init = true;
            if (namespace.find("OriginalObject") != null) {
                this._lblColumns.setVisible(false);
                this._cmbColumns.setVisible(false);
                this._lblFrom.setVisible(false);
                this._rdbExisting.setVisible(false);
                this._rdbNew.setVisible(false);
                this._cmbSequences.setVisible(false);
                this._fldSequenceName.setVisible(false);
                this._lblTriggerName.setVisible(false);
                this._fldTriggerName.setVisible(false);
            }
            try {
                String[] sequences = this._prov.listObjects("SEQUENCE", this._schema);
                this._mdlSequences.removeAllElements();
                for (int i = 0; i < sequences.length; ++i) {
                    this._mdlSequences.addElement(new String(sequences[i]));
                }
            }
            catch (DBException ex) {
                ex.printStackTrace();
            }
        }
        this.rebuildColumnList();
        if (namespace.find("AutoPopulatedColumn") != null) {
            this.setColumnName((String)namespace.find("AutoPopulatedColumn"));
            Boolean newSeq = (Boolean)namespace.find("AutoPopulatedNewSequence");
            this.setNewSequence(newSeq);
            this.setSequenceName((String)namespace.find("AutoPopulatedSequenceName"));
            Trigger trigger = (Trigger)namespace.find("AutoPopulatedTrigger");
            this.setTriggerName(trigger.getName());
        }
    }

    public boolean isAutoPopulate() {
        String selection = (String)this._cmbColumns.getSelectedItem();
        String none = CreateDialogArb.getString(513);
        return selection != null && !selection.equals(none);
    }

    public String getColumnName() {
        return (String)this._cmbColumns.getSelectedItem();
    }

    public void setColumnName(String colName) {
        this._mdlColumns.setSelectedItem(colName);
    }

    public boolean getNewSequence() {
        return this._rdbNew.isSelected();
    }

    public void setNewSequence(boolean newSeq) {
        if (newSeq) {
            this._rdbNew.setSelected(true);
            this._cmbSequences.setEnabled(false);
            this._fldSequenceName.setEnabled(true);
        } else {
            this._rdbExisting.setSelected(true);
            this._cmbSequences.setEnabled(true);
            this._fldSequenceName.setEnabled(false);
        }
    }

    public String getSequenceName() {
        if (this._rdbNew.isSelected()) {
            return this._fldSequenceName.getText();
        }
        return (String)this._cmbSequences.getSelectedItem();
    }

    public void setSequenceName(String seqName) {
        if (this._rdbNew.isSelected()) {
            this._fldSequenceName.setText(seqName);
        } else {
            this._cmbSequences.setSelectedItem(seqName);
        }
    }

    public String getTriggerName() {
        return this._fldTriggerName.getText();
    }

    public void setTriggerName(String name) {
        this._fldTriggerName.setText(name);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this._rdbNew) {
            this._cmbSequences.setEnabled(false);
            this._fldSequenceName.setEnabled(true);
            String seqName = this._prov.getUniqueName("SEQUENCE", (DBObject)this._schema, this._table.getName() + "_SEQ");
            this._fldSequenceName.setText(seqName);
        } else if (src == this._rdbExisting) {
            this._cmbSequences.setEnabled(true);
            this._fldSequenceName.setEnabled(false);
        }
        if (src == this._cmbColumns) {
            String selection = (String)this._cmbColumns.getSelectedItem();
            if (selection == null || selection.equals(CreateDialogArb.getString(513))) {
                this._lblFrom.setEnabled(false);
                this._rdbExisting.setSelected(true);
                this._rdbExisting.setEnabled(false);
                this._rdbNew.setEnabled(false);
                this._cmbSequences.setEnabled(false);
                this._fldSequenceName.setEnabled(false);
                this._fldSequenceName.setText("");
                this._lblTriggerName.setEnabled(false);
                this._fldTriggerName.setEnabled(false);
                this._fldTriggerName.setText("");
            } else {
                this._lblFrom.setEnabled(true);
                this._rdbExisting.setEnabled(true);
                this._rdbNew.setEnabled(true);
                this._cmbSequences.setEnabled(true);
                this._fldSequenceName.setEnabled(false);
                this._lblTriggerName.setEnabled(true);
                this._fldTriggerName.setEnabled(true);
                String trigName = this._prov.getUniqueName("TRIGGER", (DBObject)this._schema, "INS_" + this._table.getName());
                this._fldTriggerName.setText(trigName);
            }
        }
    }

    public void intervalAdded(ListDataEvent e) {
        this.rebuildColumnList();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.rebuildColumnList();
    }

    public void contentsChanged(ListDataEvent e) {
        this.rebuildColumnList();
    }

    private void rebuildColumnList() {
        String selection = (String)this._cmbColumns.getSelectedItem();
        this._mdlColumns.removeAllElements();
        String none = CreateDialogArb.getString(513);
        this._mdlColumns.addElement(none);
        if (selection.equals(none)) {
            this._mdlColumns.setSelectedItem(none);
        }
        for (int i = 0; i < this.mdlTo.size(); ++i) {
            String element = this.mdlTo.get(i).toString();
            this._mdlColumns.addElement(element);
            if (!selection.equals(element)) continue;
            this._mdlColumns.setSelectedItem(element);
        }
    }
}

