/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.table.CreationColumnInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.CreationConstraintsInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.CreationTableInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.table.BaseConstraintPanel;

public class SimpleCreateTableTab
extends BaseInfoPanel {
    private GridBagLayout _layoutGB = new GridBagLayout();
    private SimpleTableModel _columnModel = new SimpleTableModel();
    private JTable _tblColumnList = new JTable();
    private JButton _btnAddColumn = new JButton();
    private JButton _btnRemoveColumn = new JButton();
    private DBObjectProvider _prov;
    private Table _table;
    protected CreationTableInfoVerifier _tableVerifier = null;
    protected CreationColumnInfoVerifier _columnVerifier = null;
    protected CreationConstraintsInfoVerifier _constraintVerifier = null;
    private ArrayList _typeArray = new ArrayList(5);
    private boolean _initialized = false;
    public static final String HELP_SIMPLE_TABLE = "f1_createsimpletable_html";

    public SimpleCreateTableTab() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layoutGB);
        this._btnAddColumn.setText(CreateDialogArb.getString(560));
        this._btnRemoveColumn.setText(CreateDialogArb.getString(561));
        this._btnAddColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = SimpleCreateTableTab.this._tblColumnList.getSelectedRow();
                row = row < 0 ? SimpleCreateTableTab.this._columnModel.size() : ++row;
                SimpleCreateTableTab.this._columnModel.addDefaultRow(row);
                SimpleCreateTableTab.this._tblColumnList.setRowSelectionInterval(row, row);
            }
        });
        this._btnRemoveColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = SimpleCreateTableTab.this._tblColumnList.getSelectedRow();
                if (row >= 0) {
                    SimpleCreateTableTab.this._columnModel.deleteRow(SimpleCreateTableTab.this._tblColumnList.getSelectedRow());
                    if (row > 0) {
                        SimpleCreateTableTab.this._tblColumnList.setRowSelectionInterval(row - 1, row - 1);
                    } else if (SimpleCreateTableTab.this._columnModel.size() > 0) {
                        SimpleCreateTableTab.this._tblColumnList.setRowSelectionInterval(0, 0);
                    }
                }
            }
        });
        this._tblColumnList.setModel(this._columnModel);
        TableColumn colType = this._tblColumnList.getColumnModel().getColumn(2);
        colType.setCellEditor(new DefaultCellEditor(new IntegerTextField()));
        TableColumnModel tableColumnModel = this._tblColumnList.getColumnModel();
        TableColumn col = tableColumnModel.getColumn(0);
        col.setMinWidth(110);
        col = tableColumnModel.getColumn(1);
        col.setMinWidth(110);
        col.setMaxWidth(150);
        col = tableColumnModel.getColumn(2);
        col.setMinWidth(50);
        col.setMaxWidth(60);
        col = tableColumnModel.getColumn(3);
        col.setMinWidth(60);
        col.setMaxWidth(60);
        col = tableColumnModel.getColumn(4);
        col.setMinWidth(70);
        col.setMaxWidth(70);
        JScrollPane scrollPane = new JScrollPane(this._tblColumnList);
        this._tblColumnList.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this._tblColumnList.setSelectionMode(0);
        ColumnListCellRenderer renderer = new ColumnListCellRenderer();
        try {
            this._tblColumnList.setDefaultRenderer(Class.forName("java.lang.Object"), renderer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.add(scrollPane, new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._btnAddColumn, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this._btnRemoveColumn, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
    }

    public void init(DBObjectProvider prov) {
        DataType[] types = prov.listSupportedDataTypes();
        boolean bVarCharAdded = false;
        for (int i = 0; i < types.length; ++i) {
            if (!(types[i] instanceof PredefinedDataType)) continue;
            if (types[i].getName().equals("VARCHAR2")) {
                if (bVarCharAdded) continue;
                this._typeArray.add(0, types[i]);
                bVarCharAdded = true;
                continue;
            }
            if (types[i].getName().equals("NUMBER")) {
                this._typeArray.add(1, types[i]);
                continue;
            }
            if (types[i].getName().equals("DATE")) {
                this._typeArray.add(1, types[i]);
                continue;
            }
            if (types[i].getName().equals("CLOB")) {
                this._typeArray.add(1, types[i]);
                continue;
            }
            if (!types[i].getName().equals("INTEGER")) continue;
            this._typeArray.add(1, types[i]);
        }
        TableColumn colType = this._tblColumnList.getColumnModel().getColumn(1);
        colType.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this._typeArray.toArray())));
        this._initialized = true;
    }

    public void onEntry(TraversableContext dataContext) {
        this._prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this._table = (Table)dataContext.find("NewObject");
        this._tableVerifier = (CreationTableInfoVerifier)((Object)dataContext.find("SchemaObjectInfoVerifier"));
        this._columnVerifier = (CreationColumnInfoVerifier)((Object)dataContext.find("ColumnInfoVerifier"));
        this._constraintVerifier = (CreationConstraintsInfoVerifier)((Object)dataContext.find("ConstraintsInfoVerifier"));
        this._tableVerifier.initializeVerifier(this._prov, null, (SchemaObject)this._table);
        this._columnVerifier.initializeVerifier(this._prov, null, (SchemaObject)this._table);
        this._constraintVerifier.initializeVerifier(this._prov, null, (SchemaObject)this._table);
        if (!this._initialized) {
            this.setup();
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        TableCellEditor ed = this._tblColumnList.getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
        int size = this._columnModel.size();
        ArrayList<Column> cols = new ArrayList<Column>(size);
        ArrayList<Column> pkCols = new ArrayList<Column>();
        for (int i = 0; i < size; ++i) {
            String colName = (String)this._columnModel.getValueAt(i, 0);
            DataType type = (DataType)this._columnModel.getValueAt(i, 1);
            String colSize = (String)this._columnModel.getValueAt(i, 2);
            Boolean notNull = (Boolean)this._columnModel.getValueAt(i, 3);
            Boolean isPK = (Boolean)this._columnModel.getValueAt(i, 4);
            String name = this._prov.getInternalName(colName);
            Column col = new Column(name);
            col.setNotNull(notNull.booleanValue());
            DataTypeUsage dataTypeUsage = type.createDefaultUsage();
            if ("VARCHAR2".equals(type.getName())) {
                dataTypeUsage.putAttributeValue("size", (Object)colSize);
            } else if ("NUMBER".equals(type.getName()) && ModelUtil.hasLength((String)colSize)) {
                dataTypeUsage.putAttributeValue("precision", (Object)colSize);
            }
            col.setDataTypeUsage(dataTypeUsage);
            if (this._columnVerifier != null) {
                this._columnVerifier.verifyColumn(null, col);
            }
            cols.add(col);
            if (!isPK.booleanValue()) continue;
            pkCols.add(col);
        }
        this._table.setColumns(cols.toArray(new Column[cols.size()]));
        if (this._columnVerifier != null) {
            this._columnVerifier.verifyRelation();
        }
        if (pkCols.size() > 0) {
            Constraint[] constraints;
            Constraint[] cons = this._table.getConstraints();
            PKConstraint pk = null;
            boolean pkFound = false;
            for (int i = 0; i < cons.length; ++i) {
                if (!"PKConstraint".equals(cons[i].getConstraintType())) continue;
                pk = (PKConstraint)cons[i];
                pkFound = true;
            }
            if (pk == null) {
                pk = new PKConstraint();
                String pkName = BaseConstraintPanel.findUniqueName((Table)this._table, (Constraint)pk, (Constraint[])new Constraint[0]);
                if (this._constraintVerifier != null) {
                    try {
                        this._constraintVerifier.verifyName(pkName);
                    }
                    catch (TraversalException ex) {
                        ex.printStackTrace();
                    }
                }
                pk.setName(pkName);
            }
            pk.setEnabled(true);
            pk.setID(TemporaryObjectID.createID((DBObject)pk));
            pk.setColumns(pkCols.toArray(new Column[pkCols.size()]));
            if (pkFound) {
                constraints = cons;
            } else {
                constraints = new Constraint[cons.length + 1];
                constraints[0] = pk;
                for (int j = 1; j <= cons.length; ++j) {
                    constraints[j] = cons[j - 1];
                }
            }
            this._table.setConstraints(constraints);
        }
    }

    private void setup() {
        Column[] cols = this._table.getColumns();
        this.init(this._prov);
        if (cols.length == 0 && this._columnModel.size() == 0) {
            this._columnModel.addDefaultRow(0);
            this._tblColumnList.setRowSelectionInterval(0, 0);
        } else {
            int i;
            Constraint[] cons = this._table.getConstraints();
            PKConstraint pk = null;
            for (i = 0; i < cons.length; ++i) {
                if (!"PKConstraint".equals(cons[i].getConstraintType())) continue;
                pk = (PKConstraint)cons[i];
            }
            for (i = 0; i < cols.length; ++i) {
                String name = cols[i].getName();
                DataTypeUsage dtusage = cols[i].getDataTypeUsage();
                DataType dt = null;
                boolean primaryKey = false;
                boolean notNull = cols[i].isNotNull();
                String size = "";
                try {
                    dt = DataTypeHelper.getDataType((DataTypeUsage)dtusage);
                }
                catch (DBException ex) {
                    // empty catch block
                }
                if (dt != null) {
                    if (dt.getName().equals("VARCHAR2")) {
                        size = dtusage.getAttributeValue("size").toString();
                    } else if (dt.getName().equals("NUMBER") && dtusage.getAttributeValue("precision") != null) {
                        size = dtusage.getAttributeValue("precision").toString();
                    }
                }
                if (pk != null) {
                    Column[] pkCols = pk.getColumns();
                    for (int j = 0; j < pkCols.length; ++j) {
                        if (!pkCols[j].equals((Object)cols[i])) continue;
                        primaryKey = true;
                        notNull = true;
                        break;
                    }
                }
                this._columnModel.addRow(i, name, dt, size, notNull, primaryKey);
            }
        }
    }

    private class IntegerTextField
    extends JTextField {
        static final String badchars = "`~!@#$%^&*()_+-=\\|\"':;?/>.<, ";

        private IntegerTextField() {
        }

        public void processKeyEvent(KeyEvent ev) {
            char c = ev.getKeyChar();
            if (Character.isLetter(c) && !ev.isAltDown() || badchars.indexOf(c) > -1) {
                ev.consume();
                return;
            }
            super.processKeyEvent(ev);
        }
    }

    private class ColumnListCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TableModel model = table.getModel();
            if (!table.isRowSelected(row)) {
                if (!model.isCellEditable(row, column)) {
                    cell.setBackground(Color.lightGray);
                } else {
                    cell.setBackground(Color.white);
                }
            }
            return cell;
        }
    }

    private class SimpleTableModel
    extends AbstractTableModel {
        public String[] columnNames = new String[]{CreateDialogArb.getString(562), CreateDialogArb.getString(563), CreateDialogArb.getString(564), CreateDialogArb.getString(565), CreateDialogArb.getString(566)};
        private ArrayList _data = new ArrayList(1);
        private DefaultListModel _mdlColumns = new DefaultListModel();

        public SimpleTableModel() {
            this._mdlColumns.addElement("COLUMN");
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this._data.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (row >= this._data.size()) {
                return null;
            }
            ArrayList colList = (ArrayList)this._data.get(row);
            if (col >= colList.size()) {
                return null;
            }
            return colList.get(col);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            if (col == 2) {
                Object o = this.getValueAt(row, 1);
                String type = o.toString();
                return type.equals("NUMBER") || type.equals("VARCHAR2");
            }
            if (col == 4) {
                Object o = this.getValueAt(row, 1);
                String type = o.toString();
                if (type.equals("CLOB")) {
                    return false;
                }
                if (!(type.equals("NUMBER") || type.equals("VARCHAR2") || type.equals("INTEGER") || type.equals("DATE") || type.equals("CLOB"))) {
                    return false;
                }
            } else if (col == 3) {
                Boolean b = (Boolean)this.getValueAt(row, 4);
                if (b.booleanValue()) {
                    return false;
                }
                Object o = this.getValueAt(row, 1);
                String type = o.toString();
                if (!(type.equals("NUMBER") || type.equals("VARCHAR2") || type.equals("INTEGER") || type.equals("DATE") || type.equals("CLOB"))) {
                    return false;
                }
            } else if (col == 1) {
                Object o = this.getValueAt(row, 1);
                String type = o.toString();
                return type.equals("NUMBER") || type.equals("VARCHAR2") || type.equals("INTEGER") || type.equals("DATE") || type.equals("CLOB");
            }
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            if (row >= this._data.size()) {
                return;
            }
            ArrayList colList = (ArrayList)this._data.get(row);
            if (col >= colList.size()) {
                return;
            }
            if (col == 0) {
                this._mdlColumns.removeElement(colList.get(0));
                this._mdlColumns.addElement(value);
            }
            colList.set(col, value);
            if (col == 1) {
                if (value.toString().equals("VARCHAR2")) {
                    colList.set(2, "4000");
                } else if (value.toString().equals("NUMBER")) {
                    colList.set(2, "");
                } else if (value.toString().equals("CLOB")) {
                    colList.set(4, new Boolean(false));
                    colList.set(2, "");
                    this.fireTableCellUpdated(row, 4);
                } else {
                    colList.set(2, "");
                }
                this.fireTableCellUpdated(row, 2);
            } else if (col == 4 && ((Boolean)value).booleanValue()) {
                colList.set(3, new Boolean(true));
                this.fireTableCellUpdated(row, 3);
            }
            this.fireTableCellUpdated(row, col);
        }

        public void addDefaultRow(int row) {
            ArrayList<Object> colList = new ArrayList<Object>(5);
            String name = SimpleCreateTableTab.getUniqueName((String)"COLUMN", (DefaultListModel)this._mdlColumns);
            this._mdlColumns.addElement(name);
            colList.add(name);
            colList.add(SimpleCreateTableTab.this._typeArray.get(0));
            colList.add("4000");
            colList.add(new Boolean(false));
            colList.add(new Boolean(false));
            this._data.add(row, colList);
            this.fireTableDataChanged();
        }

        public void addRow(int row, String name, DataType dt, String size, boolean notNull, boolean pk) {
            ArrayList<Object> colList = new ArrayList<Object>(5);
            colList.add(name);
            colList.add(dt);
            colList.add(size);
            colList.add(new Boolean(notNull));
            colList.add(new Boolean(pk));
            this._data.add(row, colList);
            this.fireTableDataChanged();
        }

        public void deleteRow(int row) {
            this._data.remove(row);
            this.fireTableDataChanged();
        }

        public int size() {
            return this._data.size();
        }
    }
}

