/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.table;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.TabbedDialogLauncher;
import oracle.dbtools.raptor.dialogs.table.CreationColumnInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.CreationConstraintsInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.CreationStorageInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.CreationTableInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.EditColumnInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.EditConstraintInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.EditIndexInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.EditStorageInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.EditTableInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.PKConstraintTab;
import oracle.dbtools.raptor.dialogs.table.SimpleCreateTableTab;
import oracle.dbtools.raptor.dialogs.table.TabbedTablePanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.verifier.table.AbstractIndexInfoVerifier;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;
import oracle.jdevimpl.cm.dt.wizards.table.TablePanelLibrary;

public class TabbedOracleTableLauncher
extends TabbedDialogLauncher {
    public TabbedOracleTableLauncher(OracleDatabase db, Schema schema) {
        super((Database)db, schema);
        this.put("Tablespaces", db.listTablespaces());
        this.put("DDlGenerator", db.getDDLGenerator());
    }

    public boolean createObject() {
        Schema schema = this.getSchema();
        DBObjectProvider db = this.getProvider();
        Table table = new Table(db.getUniqueName("TABLE", (DBObject)schema, null), schema);
        table.setID(TemporaryObjectID.createID((DBObject)table));
        this.put("NewObject", table);
        this.put("OriginalObject", null);
        table.setProperty("OracleStorageProperties", (Object)new OracleStorageProperties());
        this.registerVerifier("SchemaObjectInfoVerifier", CreationTableInfoVerifier.class);
        this.registerVerifier("TableInfoVerifier", CreationTableInfoVerifier.class);
        this.registerVerifier("ColumnInfoVerifier", CreationColumnInfoVerifier.class);
        this.registerVerifier("ConstraintsInfoVerifier", CreationConstraintsInfoVerifier.class);
        this.registerVerifier("IndexVerifier", AbstractIndexInfoVerifier.class);
        this.registerVerifier("StorageInfoVerifier", CreationStorageInfoVerifier.class);
        TabbedTablePanelLibrary lib = new TabbedTablePanelLibrary(false);
        this.put("PANEL_LIBRARY", (Object)lib);
        this.addTab(SimpleCreateTableTab.class, "f1_createsimpletable_html", CmWizardsArb.getString((int)41));
        this.addTab(CreateTableSQLTab.class, "f1_bdbwcreatetablefinish_html", CreateDialogArb.getString(514));
        this.setTitle(CmWizardsArb.getString((int)11));
        this.setErrorTitle(CmWizardsArb.getString((int)13));
        return this.createObjectImpl();
    }

    public boolean editObject(SchemaObject object) {
        SchemaObject copy = (SchemaObject)DBUtil.makeTemporaryCopy((DBObject)object);
        this.put("NewObject", copy);
        this.put("OriginalObject", object);
        this.registerVerifier("SchemaObjectInfoVerifier", EditTableInfoVerifier.class);
        this.registerVerifier("TableInfoVerifier", EditTableInfoVerifier.class);
        this.registerVerifier("ColumnInfoVerifier", EditColumnInfoVerifier.class);
        this.registerVerifier("ConstraintsInfoVerifier", EditConstraintInfoVerifier.class);
        this.registerVerifier("IndexVerifier", EditIndexInfoVerifier.class);
        this.registerVerifier("StorageInfoVerifier", EditStorageInfoVerifier.class);
        TabbedTablePanelLibrary lib = new TabbedTablePanelLibrary(true);
        this.put("PANEL_LIBRARY", (Object)lib);
        Navigable[] navs = lib.getEditNavigables((Table)object, this.getProvider());
        this._tabs.clear();
        this._tabs.addAll(Arrays.asList(navs));
        this.setTitle(CmWizardsArb.getString((int)12));
        this.setErrorTitle(CmWizardsArb.getString((int)13));
        return this.createObjectImpl();
    }

    public static boolean createTable(Context ctx, OracleDatabase db) {
        try {
            Schema schema = DBWizardLauncher.determineSchema((Context)ctx, (Database)db);
            TabbedOracleTableLauncher launcher = new TabbedOracleTableLauncher(db, schema);
            return launcher.createObject();
        }
        catch (DBException dBException) {
            return false;
        }
    }

    public static boolean editTable(OracleDatabase db, Table table) {
        TabbedOracleTableLauncher launcher = new TabbedOracleTableLauncher(db, table.getSchema());
        return launcher.editObject((SchemaObject)table);
    }

    protected boolean runDialog(String title) {
        Navigable[] simpleNavs = this._tabs.toArray(new Navigable[this._tabs.size()]);
        TabbedTablePanel panel = new TabbedTablePanel(simpleNavs);
        if (ModelUtil.hasLength((String)this._topLabel)) {
            panel.setTopLabel(this._topLabel);
        }
        if (ModelUtil.hasLength((String)this._errTitle)) {
            panel.setErrorTitle(this._errTitle);
        }
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), title, (Traversable)panel, (Namespace)this);
        launcher.setInitialSize(600, 550);
        return launcher.showDialog();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TabbedTablePanelLibrary
    extends TablePanelLibrary {
        private boolean m_editing;

        protected TabbedTablePanelLibrary(boolean editing) {
            this.m_editing = editing;
            this.setFlatten(true);
            this.initPanels2();
        }

        protected void initPanels() {
        }

        protected void initPanels2() {
            super.initPanels();
            if (!this.m_editing) {
                this.addPanel(CmWizardsArb.getString((int)115), PKConstraintTab.class, "f1_bdbwcreateprimarykey_html");
            }
            this.addPanel(CreateDialogArb.getString(514), this.m_editing ? TabbedDialogLauncher.EditSQLTab.class : CreateTableSQLTab.class, "f1_bdbwcreatetablefinish_html");
        }

        protected List<String> getTitles(Table tab, Table.TableType type, DBObjectProvider pro, boolean editing) {
            List titles = super.getTitles(tab, type, pro, editing);
            if (!editing) {
                titles.add(CreateDialogArb.getString(514));
            }
            return titles;
        }
    }

    protected static final class CreateTableSQLTab
    extends TabbedDialogLauncher.CreateSQLTab {
        protected CreateTableSQLTab() {
        }

        protected String getSQL(TraversableContext dataContext) {
            String text = super.getSQL(dataContext);
            if (dataContext.find("AutoPopulatedTrigger") != null) {
                DDLGenerator gen = (DDLGenerator)dataContext.get("DDlGenerator");
                if (dataContext.find("AutoPopulatedSequence") != null) {
                    Sequence autoPopSequence = (Sequence)dataContext.find("AutoPopulatedSequence");
                    text = text + System.getProperty("line.separator");
                    text = text + gen.getCreateDDL((SchemaObject)autoPopSequence, false, false).getDdl();
                }
                Trigger autoPopTrigger = (Trigger)dataContext.find("AutoPopulatedTrigger");
                Ddl ddl = gen.getCreateDDL((SchemaObject)autoPopTrigger, false, false);
                text = text + System.getProperty("line.separator");
                text = text + ddl.getDdl();
            }
            return text;
        }
    }
}

