/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.trigger;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.dbtools.raptor.dialogs.trigger.TriggerPanel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdeveloper.cm.dt.verifier.trigger.TriggerVerifier;

public class BaseTriggerPanel
extends BaseInfoPanel
implements ListDataListener,
FocusListener,
PropertyChangeListener {
    private Trigger _trigger;
    private ComboBoxModel _schemas;
    private boolean _canChangeSchema;
    private TriggerPanel _parent;

    public void init(DBObjectProvider prov, Trigger trigger, Schema[] schemas, boolean canChangeSchema, TriggerVerifier verifier) {
        super.init(prov, (Verifier)verifier);
        this._trigger = trigger;
        this._canChangeSchema = canChangeSchema;
        if (this._schemas == null) {
            this._schemas = new NonNullableComboBoxModel((Object[])schemas);
        }
    }

    public void commit() throws TraversalException {
    }

    protected Trigger getTrigger() {
        return this._trigger;
    }

    protected ComboBoxModel getSchemas() {
        return this._schemas;
    }

    protected boolean getCurrentOKState() {
        return true;
    }

    protected boolean canChangeSchema() {
        return this._canChangeSchema;
    }

    void setParent(TriggerPanel parent) {
        if (this._parent != parent) {
            this._parent = parent;
        }
    }

    protected void updateOK() {
        if (this._parent != null) {
            this._parent.updateOK();
        }
    }

    public void focusGained(FocusEvent fe) {
        int idx;
        JList list;
        Object src = fe.getSource();
        if (src instanceof JList && (list = (JList)src).getSelectedIndex() == -1 && (idx = list.getFirstVisibleIndex()) != -1) {
            list.setSelectedIndex(idx);
        }
    }

    public void focusLost(FocusEvent fe) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object oldObj = evt.getOldValue();
        Object newObj = evt.getNewValue();
        if (oldObj instanceof ListModel) {
            ((ListModel)oldObj).removeListDataListener(this);
        }
        if (newObj instanceof ListModel) {
            ((ListModel)newObj).addListDataListener(this);
            this.updateOK();
        }
    }

    public void intervalAdded(ListDataEvent e) {
        this.updateOK();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.updateOK();
    }

    public void contentsChanged(ListDataEvent e) {
        this.updateOK();
    }

    protected static final class ModelPair {
        private final DefaultListModel _avail = new DefaultListModel();
        private final DefaultListModel _sel = new DefaultListModel();

        protected ModelPair(String[] objs, boolean selected) {
            DefaultListModel model = selected ? this._sel : this._avail;
            for (int i = 0; i < objs.length; ++i) {
                model.addElement(objs[i]);
            }
        }

        public ListModel getAvailableModel() {
            return this._avail;
        }

        public ListModel getSelectedModel() {
            return this._sel;
        }
    }
}

