/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.trigger;

import java.util.List;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;
import oracle.jdeveloper.cm.dt.verifier.AbstractSchemaObjectVerifier;
import oracle.jdeveloper.cm.dt.verifier.trigger.TriggerVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class CreateTriggerVerifier
extends AbstractSchemaObjectVerifier
implements TriggerVerifier {
    private DBObjectProvider _prov;
    private Trigger _trigger;

    public CreateTriggerVerifier(DBObjectProvider prov, Trigger trigger) {
        this.initializeVerifier(prov, null, (SchemaObject)trigger);
    }

    public void verifyTrigger(boolean replace) throws TraversalException {
        Schema owner = this._trigger.getSchema();
        if (owner == null) {
            throw new TraversalException(CmWizardsArb.getString((int)228), CmWizardsArb.getString((int)227), null);
        }
        Schema tableOwner = this._trigger.getTableOwner();
        switch (this._trigger.getBaseType()) {
            case 0: 
            case 1: {
                if (tableOwner == null) {
                    throw new TraversalException(CmWizardsArb.getString((int)233), CmWizardsArb.getString((int)227), null);
                }
                String tableName = this._trigger.getTableName();
                if (ModelUtil.hasLength((String)tableName)) break;
                throw new TraversalException(CmWizardsArb.getString((int)232), CmWizardsArb.getString((int)227), null);
            }
            case 2: {
                if (tableOwner != null) break;
                throw new TraversalException(CmWizardsArb.getString((int)235), CmWizardsArb.getString((int)227), null);
            }
        }
        List events = this._trigger.getEvents();
        if (events.size() == 0) {
            throw new TraversalException(CmWizardsArb.getString((int)234), CmWizardsArb.getString((int)227), null);
        }
    }

    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject change) {
        this._prov = prov;
        this._trigger = (Trigger)change;
    }

    public void verifyName(String name) throws TraversalException {
        if (!this._prov.isValidName(name)) {
            throw new TraversalException(CmWizardsArb.format((int)236, (Object)name), CmWizardsArb.getString((int)227), null);
        }
    }
}

