/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.trigger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.dbtools.raptor.dialogs.trigger.BaseTriggerPanel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.verifier.trigger.TriggerVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class SchemaTriggerPanel
extends BaseTriggerPanel
implements ItemListener {
    private GridBagLayout _layMain = new GridBagLayout();
    private JRadioButton _radBefore = new JRadioButton();
    private JRadioButton _radAfter = new JRadioButton();
    private ButtonGroup _grpTiming = new ButtonGroup();
    private JLabel _lblSchema = new JLabel();
    private JComboBox _cmbSchema = new JComboBox();
    private DBObjectRenderer _schemaRenderer = new DBObjectRenderer();
    private Shuttle _shtEvents = new Shuttle();
    private JLabel _lblAvail = new JLabel();
    private JList _lstAvail = new JList();
    private ListPicker _pckAvail = new ListPicker(this._lstAvail);
    private JLabel _lblSel = new JLabel();
    private JList _lstSel = new JList();
    private ListPicker _pckSel = new ListPicker(this._lstSel);
    private BaseTriggerPanel.ModelPair _mdlBefore = SchemaTriggerPanel.createModel(Trigger.getEvents((int)0, (int)2));
    private BaseTriggerPanel.ModelPair _mdlAfter = SchemaTriggerPanel.createModel(Trigger.getEvents((int)1, (int)2));
    private Database _db;

    public SchemaTriggerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean getCurrentOKState() {
        return this._lstSel.getModel().getSize() > 0;
    }

    public void init(DBObjectProvider prov, Trigger trigger, Schema[] schemas, boolean canChangeSchema, TriggerVerifier verifier) {
        super.init(prov, trigger, schemas, canChangeSchema, verifier);
        this._cmbSchema.setModel(this.getSchemas());
        this._cmbSchema.setSelectedItem(trigger.getSchema());
        this._cmbSchema.setEnabled(canChangeSchema);
    }

    static final BaseTriggerPanel.ModelPair createModel(List list) {
        String[] events = list.toArray(new String[list.size()]);
        return new BaseTriggerPanel.ModelPair(events, false);
    }

    public void commit() throws TraversalException {
        int timing = this._radBefore.isSelected() ? 0 : 1;
        Schema schema = (Schema)this._cmbSchema.getSelectedItem();
        ArrayList events = new ArrayList();
        ListModel model = this._lstSel.getModel();
        int count = model.getSize();
        for (int i = 0; i < count; ++i) {
            events.add(model.getElementAt(i));
        }
        Trigger trigger = this.getTrigger();
        trigger.setTiming(timing);
        trigger.setTableOwner(schema);
        trigger.setEvents(events);
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layMain);
        this._lstAvail.addFocusListener(this);
        this._lstSel.addFocusListener(this);
        this._lstSel.addPropertyChangeListener("model", this);
        ResourceUtils.resButton((AbstractButton)this._radBefore, (String)CmWizardsArb.getString((int)208));
        this._grpTiming.add(this._radBefore);
        this._radBefore.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this._radAfter, (String)CmWizardsArb.getString((int)209));
        this._grpTiming.add(this._radAfter);
        this._radBefore.setSelected(true);
        this._cmbSchema.setRenderer(this._schemaRenderer);
        ResourceUtils.resLabel((JLabel)this._lblSchema, (Component)this._cmbSchema, (String)CmWizardsArb.getString((int)17));
        ResourceUtils.resLabel((JLabel)this._lblAvail, (Component)this._lstAvail, (String)CmWizardsArb.getString((int)225));
        ResourceUtils.resLabel((JLabel)this._lblSel, (Component)this._lstSel, (String)CmWizardsArb.getString((int)226));
        this._shtEvents.setFromPicker((ItemPicker)this._pckAvail);
        this._shtEvents.setToPicker((ItemPicker)this._pckSel);
        this._shtEvents.add((Component)this._lblAvail, (Object)"FromHeader");
        this._shtEvents.add((Component)this._lblSel, (Object)"ToHeader");
        this.add(this._radBefore, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._radAfter, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._lblSchema, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.add(this._cmbSchema, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 24, 0, 0), 0, 0));
        this.add((Component)this._shtEvents, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void itemStateChanged(ItemEvent e) {
        BaseTriggerPanel.ModelPair model = this._radBefore.isSelected() ? this._mdlBefore : this._mdlAfter;
        this._lstAvail.setModel(model.getAvailableModel());
        this._lstSel.setModel(model.getSelectedModel());
    }
}

