/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.type;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ObjectType;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.plsql.NewPlsqlPanel;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public final class NewUserDefinedTypePanel
extends NewPlsqlPanel {
    private NewPlsqlPanel.PlSqlComboItem m_default;
    private ObjectType _type;

    public NewUserDefinedTypePanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_sqlplsqlsubprogram_html");
    }

    public String getHeaderTitle() {
        return CmWizardsArb.getString((int)414);
    }

    public String getHeaderDescription() {
        return CmWizardsArb.getString((int)415);
    }

    public String getNameLabel() {
        return CmWizardsArb.getString((int)18);
    }

    public String getTypeLabel() {
        return CmWizardsArb.getString((int)416);
    }

    public String getDefaultName(TraversableContext dataContext) {
        ObjectType type = (ObjectType)dataContext.find("NewObject");
        return type.getName();
    }

    public List getTypeList(TraversableContext dataContext) {
        ArrayList<NewPlsqlPanel.PlSqlComboItem> typeList = new ArrayList<NewPlsqlPanel.PlSqlComboItem>();
        typeList.add(new NewPlsqlPanel.PlSqlComboItem((NewPlsqlPanel)this, "TYPE", 286, 290, true));
        this.m_default = new NewPlsqlPanel.PlSqlComboItem((NewPlsqlPanel)this, "TYPE", 283, 287, false);
        typeList.add(this.m_default);
        typeList.add(new NewPlsqlPanel.PlSqlComboItem((NewPlsqlPanel)this, "TYPE", 285, 289, true));
        return typeList;
    }

    public NewPlsqlPanel.PlSqlComboItem getDefaultComboItem() {
        return this.m_default;
    }

    public void performProcess(TraversableContext dataContext) throws TraversalException {
        DBObjectProvider prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this._type = (ObjectType)dataContext.find("NewObject");
        String name = this.getSelectedName();
        try {
            prov.validateName(name);
        }
        catch (InvalidNameException e) {
            throw new TraversalException(e.getMessage(), CmWizardsArb.format((int)246, (Object)name));
        }
        this._type.setName(prov.getInternalName(name));
        String extName = prov.getExternalName(this._type.getName());
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        Schema schema = this.getSelectedSchema(schemas);
        this._type.setSchema(schema);
        NewPlsqlPanel.PlSqlComboItem sel = this.getSelectedType();
        if (sel.isCollectionType()) {
            this._type.setTypeCode("COLLECTION");
        } else {
            this._type.setTypeCode("OBJECT");
        }
        this._type.setSource(ConnectionArb.format((int)sel.getPlsql(), (Object)extName));
        int extra = sel.getExtraPlsql();
        this._type.setBodySource(extra > 0 ? ConnectionArb.format((int)extra, (Object)extName) : null);
        try {
            prov.validateObject((DBObject)this._type);
        }
        catch (ValidationException e) {
            throw new TraversalException(e.getMessage(), CmWizardsArb.format((int)246, (Object)extName));
        }
    }

    public ObjectType getType() {
        return this._type;
    }
}

