/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.type;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import oracle.dbtools.raptor.dialogs.TabbedDialogLauncher;
import oracle.dbtools.raptor.dialogs.type.NewUserDefinedTypePanel;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.ObjectType;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;

public class PlSqlTypeLauncher
extends TabbedDialogLauncher {
    public static final String HELP_SYNONYM_INFO = "f1_dbnewtypewizardsynonyminfo_html";

    protected PlSqlTypeLauncher(Database db, Schema schema) {
        super(db, schema);
    }

    public boolean createObject() {
        final NewUserDefinedTypePanel panel = new NewUserDefinedTypePanel();
        this.put("NewObject", new ObjectType("NewUserDefinedType", this.getSchema()));
        panel.setHelpID(HELP_SYNONYM_INFO);
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), Translate.translate("Create Type"), (Traversable)panel, (Namespace)this);
        launcher.setInitialSize(600, 500);
        launcher.setPackDialog(true);
        launcher.addApplyListener(new ApplyListener(){

            public void apply(ApplyEvent e) {
                String s = "";
                PlSqlTypeLauncher.this.create(panel);
            }

            public void cancel(ApplyEvent e) {
            }
        });
        return launcher.showDialog();
    }

    public boolean editObject(SchemaObject object) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create(NewUserDefinedTypePanel panel) {
        final OracleDatabase db = (OracleDatabase)this.getProvider();
        final ObjectType type = panel.getType();
        URL url = CmUtil.getNodeURL((String)db.getConnectionName(), null, (String)type.getSchema().getName(), (String)"TYPE", (String)type.getName(), null);
        final Node cbn = JdbcNodeFactory.getNode((Database)db, (URL)url);
        if (cbn instanceof TextNode) {
            cbn.addNodeListener(new NodeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nodeSaved(NodeEvent e) {
                    try {
                        SchemaObject obj = db.getObject("TYPE", type.getSchema(), type.getName());
                        if (obj != null && db instanceof AbstractDatabase) {
                            ((AbstractDatabase)db).fireObjectsAdded(type.getSchema(), new SchemaObject[]{obj});
                        }
                    }
                    catch (DBException ex) {
                        ExceptionHandler.handleException((Exception)((Object)ex));
                    }
                    finally {
                        cbn.removeNodeListener((NodeListener)this);
                    }
                }

                public void nodeClosed(NodeEvent e) {
                    cbn.removeNodeListener((NodeListener)this);
                }
            });
            TextBuffer buf = null;
            try {
                buf = ((TextNode)cbn).acquireTextBuffer();
                buf.beginEdit();
                buf.removeToEnd(0);
                String text = "create or replace " + panel.getType().getSource();
                buf.append(text.toCharArray());
            }
            finally {
                if (buf != null) {
                    buf.endEdit();
                    ((TextNode)cbn).releaseTextBuffer();
                }
            }
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                EditorUtil.openDefaultEditorInFrame((Node)cbn);
            }
        });
    }

    public static boolean createType(Context ctx, OracleDatabase db) {
        try {
            Schema schema = DBWizardLauncher.determineSchema((Context)ctx, (Database)db);
            PlSqlTypeLauncher launcher = new PlSqlTypeLauncher((Database)db, schema);
            return launcher.createObject();
        }
        catch (DBException dBException) {
            return false;
        }
    }
}

