/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.view;

import oracle.dbtools.raptor.dialogs.view.AbstractViewInfoVerifier;
import oracle.dbtools.raptor.dialogs.view.ViewVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class CreateViewVerifier
extends AbstractViewInfoVerifier
implements ViewVerifier {
    private View _view;

    public CreateViewVerifier() {
    }

    public CreateViewVerifier(DBObjectProvider prov, View view) {
        this.initializeVerifier(prov, null, (SchemaObject)view);
    }

    public void verifyView(boolean replace) throws TraversalException {
        try {
            Schema schema = this._view.getSchema();
            String name = this._view.getName();
            if (!replace && this.getProvider().getObject("VIEW", schema, name) != null) {
                throw new TraversalException(CmWizardsArb.format((int)201, (Object)name), CmWizardsArb.getString((int)199), null);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject change) {
        super.initializeVerifier(prov, orig, change);
        this._view = (View)change;
    }

    public boolean canCreateSchema() {
        return false;
    }

    public void verifySchemaName(String name) throws TraversalException {
        if (!this.isValidName(name)) {
            throw new TraversalException(CmWizardsArb.format((int)40, (Object)name), CmWizardsArb.getString((int)202), null);
        }
    }

    protected String getErrorTitle() {
        return CmWizardsArb.getString((int)202);
    }

    protected String getInvalidNameMessage(String name) {
        return CmWizardsArb.format((int)(ModelUtil.hasLength((String)name) ? 200 : 203), (Object)name);
    }
}

