/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.view;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import oracle.dbtools.raptor.dialogs.view.ViewInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.View;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class ViewInfoTab
extends BaseInfoPanel
implements ActionListener {
    private JRadioButton m_readOnly = new JRadioButton();
    private JRadioButton m_checkOption = new JRadioButton();
    private JCheckBox m_restrict = new JCheckBox();
    private JCheckBox m_force = new JCheckBox();

    public ViewInfoTab() {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_restrict, (String)CmWizardsArb.getString((int)297));
        this.add(this.m_restrict, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(20, 20, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_readOnly, (String)CmWizardsArb.getString((int)298));
        this.add(this.m_readOnly, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 40, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_checkOption, (String)CmWizardsArb.getString((int)299));
        this.add(this.m_checkOption, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 40, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_force, (String)CmWizardsArb.getString((int)300));
        this.add(this.m_force, new GridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 20, 0, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_readOnly);
        bg.add(this.m_checkOption);
        this.m_readOnly.setSelected(true);
        this.m_restrict.setSelected(false);
        this.m_readOnly.setEnabled(false);
        this.m_checkOption.setEnabled(false);
        this.m_restrict.addActionListener(this);
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        View view = (View)dataContext.find("NewObject");
        ViewInfoVerifier verifier = (ViewInfoVerifier)dataContext.find("ViewInfoVerifier");
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.init(prov, view, verifier, schemas);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit((View)dataContext.find("NewObject"), (Schema[])dataContext.find("SchemaList"), dataContext.getDirection() != 2);
    }

    protected void init(DBObjectProvider prov, View view, ViewInfoVerifier verifier, Schema[] schemas) {
        super.init(prov, (Verifier)verifier);
        String rest = view.getQueryRestriction();
        if (rest != null) {
            this.m_restrict.setSelected(true);
            this.m_readOnly.setEnabled(true);
            this.m_checkOption.setEnabled(true);
            if (rest.equalsIgnoreCase("WITH READ ONLY")) {
                this.m_readOnly.setSelected(true);
            } else {
                this.m_checkOption.setSelected(true);
            }
        }
        this.m_force.setSelected(view.isForceOnCreate());
        if (null != verifier) {
            this.m_restrict.setEnabled(verifier.canChangeQueryRestriction());
            this.m_readOnly.setEnabled(this.m_restrict.isSelected() && verifier.canChangeQueryRestriction());
            this.m_checkOption.setEnabled(this.m_restrict.isSelected() && verifier.canChangeQueryRestriction());
            this.m_force.setEnabled(verifier.canChangeQueryRestriction());
        }
    }

    protected void commit(View view, Schema[] schema, boolean isForward) throws TraversalException {
        if (this.m_restrict.isSelected()) {
            view.setQueryRestriction(this.m_readOnly.isSelected() ? "WITH READ ONLY" : "WITH CHECK OPTION");
        } else {
            view.setQueryRestriction(null);
        }
        view.setForceOnCreate(this.m_force.isSelected());
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_restrict) {
            if (this.m_restrict.isSelected()) {
                this.m_readOnly.setEnabled(true);
                this.m_checkOption.setEnabled(true);
            } else {
                this.m_readOnly.setEnabled(false);
                this.m_checkOption.setEnabled(false);
            }
        }
    }
}

