/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.format.CSVFormatter;
import oracle.dbtools.raptor.format.InsertFormatter;
import oracle.dbtools.raptor.format.LoaderFormatter;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.format.SQLPLUSFormatter;
import oracle.dbtools.raptor.format.TxtFormatter;
import oracle.dbtools.raptor.format.XMLFormatter;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;

public class TableExporter
implements ContextMenuListener {
    private static final Object LOCK = new Object();
    private JTable _table;
    private View _view;
    private JTextField _baseName;
    private JMenu _menu;
    private static URL _lastUrl;
    private static TableExporter _instance;

    private TableExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableExporter getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new TableExporter();
            }
        }
        return _instance;
    }

    public void setTable(JTable table) {
        this._table = table;
    }

    public void save(int format) {
        if (format == 5 || format == 4) {
            this.promptForBaseTableName();
            if (!this._baseName.getText().equals("")) {
                this.saveFile(format);
            }
        } else {
            this.saveFile(format);
        }
    }

    public void saveFile(int format) {
        int saveState = 0;
        URLChooser saveDialog = new URLChooser();
        saveDialog.clearChooseableURLFilters();
        switch (format) {
            case 1: {
                saveDialog.setURLFilter(ResultsFormatter.CSV_FILTER);
                break;
            }
            case 0: {
                saveDialog.setURLFilter(ResultsFormatter.SQL_FILTER);
                break;
            }
            case 4: {
                saveDialog.setURLFilter(ResultsFormatter.SQL_FILTER);
                break;
            }
            case 2: {
                saveDialog.setURLFilter(ResultsFormatter.XML_FILTER);
                break;
            }
            case 5: {
                saveDialog.setURLFilter(ResultsFormatter.LDR_FILTER);
                break;
            }
            case 6: {
                saveDialog.setURLFilter(ResultsFormatter.TXT_FILTER);
                break;
            }
            default: {
                saveDialog.setURLFilter(ResultsFormatter.CSV_FILTER);
                saveDialog.setURLFilter(ResultsFormatter.SQL_FILTER);
                saveDialog.setURLFilter(ResultsFormatter.XML_FILTER);
                saveDialog.setURLFilter(ResultsFormatter.LDR_FILTER);
                saveDialog.setURLFilter(ResultsFormatter.TXT_FILTER);
            }
        }
        if (_lastUrl == null) {
            try {
                String s = System.getProperty("user.home");
                URL home = new URL("file://" + System.getProperty("user.home"));
                saveDialog.setSelectedURL(home);
            }
            catch (MalformedURLException e) {}
        } else {
            saveDialog.setSelectedURL(_lastUrl);
        }
        File f = new File(saveDialog.getSelectedURL().getFile());
        if (f.isDirectory()) {
            try {
                String defaultName = "export";
                if (this._table instanceof ResultSetTable && ((ResultSetTable)this._table).getDefaultExportName() != null) {
                    defaultName = ((ResultSetTable)this._table).getDefaultExportName();
                }
                if (defaultName != null) {
                    saveDialog.setSelectedURL(new URL(saveDialog.getSelectedURL() + File.separator + defaultName));
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if ((saveState = saveDialog.showSaveDialog((Component)this._table)) == 0) {
            URL filename;
            _lastUrl = filename = saveDialog.getSelectedURL();
            try {
                File file = null;
                if (filename.getPath().indexOf(".") < 0) {
                    if (format == 1) {
                        file = new File(filename.getPath() + ".csv");
                    } else if (format == 2) {
                        file = new File(filename.getPath() + ".xml");
                    } else if (format == 0) {
                        file = new File(filename.getPath() + ".sql");
                    } else if (format == 4) {
                        file = new File(filename.getPath() + ".sql");
                    } else if (format == 5) {
                        file = new File(filename.getPath() + ".ldr");
                    } else if (format == 6) {
                        file = new File(filename.getPath() + ".txt");
                    }
                } else {
                    file = new File(filename.getPath());
                }
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
                OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)output, "UTF-8");
                ResultsFormatter formatter = null;
                if (format == 1) {
                    formatter = new CSVFormatter(this._table, outWriter);
                } else if (format == 2) {
                    formatter = new XMLFormatter(this._table, outWriter);
                } else if (format == 0) {
                    formatter = new SQLPLUSFormatter(this._table, outWriter);
                } else if (format == 4) {
                    formatter = new InsertFormatter(this._table, outWriter, this._baseName.getText());
                } else if (format == 5) {
                    formatter = new LoaderFormatter(this._table, outWriter, this._baseName.getText());
                } else if (format == 6) {
                    formatter = new TxtFormatter(this._table, outWriter);
                }
                formatter.printWithDialog();
            }
            catch (IOException io) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)(filename.getPath() + filename.getFile()), null);
                System.err.println(io);
            }
        } else if (saveState == 1) {
            // empty if block
        }
    }

    public void promptForBaseTableName() {
        PropertyPanel tPanel = new PropertyPanel();
        String panelTitle = Translate.translate("Enter Target Table Name or Export");
        String lName = new String(Translate.translate("Table Name*"));
        this._baseName = new JTextField();
        this._baseName.setColumns(30);
        this._baseName.setEditable(true);
        this._baseName.setBorder(null);
        tPanel.addComp(lName, this._baseName);
        tPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        tPanel.setBorder(BorderFactory.createEtchedBorder());
        tPanel.setSize(tPanel.getPreferredSize());
        HelpSystem.getHelpSystem().registerTopic((JComponent)tPanel, "f1_getexporttargettable_html");
        final JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)tPanel, null, (String)panelTitle, (int)14);
        dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TableExporter.this._baseName.getText().equals("")) {
                    return;
                }
                dlg.dispose();
            }
        });
        Dimension dim = tPanel.getPreferredSize();
        int h = (int)dim.getHeight() + 100;
        int w = (int)dim.getWidth() + 10;
        dlg.setSize(w, h);
        dlg.setPreferredSize(w, h);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)dlg);
        dlg.setVisible(true);
    }

    public JMenu getMenu() {
        if (this._menu == null) {
            this._menu = new JMenu("Export");
            JMenuItem csv = new JMenuItem("CSV");
            JMenuItem xml = new JMenuItem("XML");
            JMenuItem ins = new JMenuItem("INSERT");
            JMenuItem load = new JMenuItem("LOADER");
            JMenuItem text = new JMenuItem("TEXT");
            text.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableExporter.this.save(6);
                }
            });
            csv.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableExporter.this.save(1);
                }
            });
            xml.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableExporter.this.save(2);
                }
            });
            ins.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableExporter.this.save(4);
                }
            });
            load.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableExporter.this.save(5);
                }
            });
            this._menu.add(csv);
            this._menu.add(xml);
            this._menu.add(ins);
            this._menu.add(load);
            this._menu.add(text);
        }
        return this._menu;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        View v = null;
        v = contextMenu.getContext().getView();
        EventObject e = contextMenu.getContext().getEvent();
        contextMenu.addSeparator();
        contextMenu.add((Component)this.getMenu());
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

