/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.raptor.DBDevExtensionResource;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.insight.DatabaseListInsightData;
import oracle.dbtools.raptor.insight.InsightableDatabase;
import oracle.dbtools.raptor.insight.InsightableOracleDatabase;
import oracle.dbtools.raptor.utils.CMHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.jdeveloper.cm.ds.db.insight.BaseInsightableItem;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;

public final class CompletionInsight
extends AbstractInsight
implements InsightProvider {
    private Context _ctx;
    private Thread _loadingThread;
    private InsightableDatabase _db;
    private static final String INSIGHT_DB = "insight-db-conn";
    private int lastContextStart;

    public CompletionInsight(Context ctx, Database database) {
        this._ctx = ctx;
        if (System.getProperty("sdev.insight", "true").equals("true")) {
            BaseInsightableItem bi;
            if (database instanceof OracleDatabase) {
                this._db = this.getInsightableOracleDatabase(database);
            }
            if ((bi = this.getBaseInsightableItem()) == null) {
                this._loadingThread = new Thread((Runnable)new InsightLoader(), "DB Insight Thread");
                this._loadingThread.start();
            }
        } else {
            Assert.print((String)"Code Insight has been disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsightableDatabase getInsightableOracleDatabase(Database db) {
        final ConnectionNode cNode = CMHelper.getConnectionNode(db.getConnectionName());
        InsightableOracleDatabase idb = (InsightableOracleDatabase)cNode.getClientProperty((Object)INSIGHT_DB);
        if (idb == null) {
            idb = new InsightableOracleDatabase((OracleDatabase)db);
            Connection connection = idb.getConnection();
            CallableStatement statement = null;
            try {
                statement = connection.prepareCall("begin dbms_application_info.set_module(?,'Code Insight'); end;");
                statement.setString(1, DBDevExtensionResource.getBundle("oracle.dbtools.raptor.DBDevExtensionResource").getString("EXTENSION_NAME"));
                boolean ret = statement.execute();
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {}
            }
            cNode.putClientProperty((Object)INSIGHT_DB, (Object)idb);
            final InsightableOracleDatabase finalIdb = idb;
            cNode.addNodeListener(new NodeListener(){

                public void nodeWillClose(NodeEvent e) {
                    try {
                        finalIdb.getConnection().close();
                        cNode.putClientProperty((Object)CompletionInsight.INSIGHT_DB, null);
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return idb;
    }

    public CompletionInsight(Context ctx) {
        this(ctx, null);
    }

    protected InsightProvider createInsightProvider() {
        return this;
    }

    public boolean isInsightTriggerChar(char typedChar) {
        return typedChar == '.';
    }

    protected boolean isAutomaticPartialComplete(InsightData data) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsightData getInsightData(BasicEditorPane editorPane) {
        if (!this.isValidContext()) {
            return null;
        }
        this.lastContextStart = this.getContextStartOffset();
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show();
        DatabaseListInsightData returnData = null;
        try {
            String defaultContext = this.getDefaultInsightContext();
            Assert.println((String)("getInsightData: " + defaultContext));
            returnData = new DatabaseListInsightData(this, defaultContext);
        }
        finally {
            waitCursor.hide();
        }
        return returnData;
    }

    public InsightData updateInsightData(BasicEditorPane editorPane, InsightData lastData) {
        TextBuffer textBuffer = this.getTextBuffer();
        int caretOffset = this.getCaretPosition();
        Assert.println((String)("updateInsightData: " + this.getDefaultInsightContext()));
        if (lastData instanceof DatabaseListInsightData) {
            if (this.getContextStartOffset() != this.lastContextStart) {
                return null;
            }
            DatabaseListInsightData data = (DatabaseListInsightData)lastData;
            String updatedContext = this.getDefaultInsightContext();
            data.updateContext(updatedContext);
            return data;
        }
        return lastData;
    }

    public InsightView getInsightView() {
        return new ListInsightView();
    }

    public URL getURL() {
        Node node = this._ctx != null ? this._ctx.getNode() : null;
        return node != null ? node.getURL() : null;
    }

    public InsightableDatabase getDatabase() {
        if (System.getProperty("sdev.insight", "true").equals("true")) {
            if (this._db == null) {
                OracleDatabase odb = this.findDatabase();
                this._db = this.getInsightableOracleDatabase((Database)odb);
            }
        } else {
            Assert.print((String)"Code Insight has been disabled");
        }
        return this._db;
    }

    private OracleDatabase findDatabase() {
        Node node = this._ctx != null ? this._ctx.getNode() : null;
        OracleDatabase db = null;
        if (node instanceof PlSqlBaseNode) {
            PlSqlBaseNode plSqlNode = (PlSqlBaseNode)node;
            db = (OracleDatabase)plSqlNode.getDatabase();
        } else {
            View activeView = this._ctx.getView();
            if (activeView instanceof IDBEditor) {
                db = (OracleDatabase)((IDBEditor)activeView).getDatabase();
            }
        }
        return db;
    }

    private static ConnectionNode _getConnNode(URL url) {
        if (url == null) {
            return null;
        }
        String cName = CompletionInsight.isWorksheetNode(url) ? Connections.getConnName(url) : CmUtil.getConnName((URL)url);
        ConnectionsProvider cns = ConnectionsProvider.getInstance();
        return cns.getConnectionNode(cName);
    }

    private static boolean isWorksheetNode(URL url) {
        String protocol = url.getProtocol();
        return protocol.equalsIgnoreCase("ide.sqleditor") || protocol.equalsIgnoreCase("ide.sqlEditorNode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized BaseInsightableItem getBaseInsightableItem() {
        ConnectionNode cNode;
        if (this._loadingThread != null) {
            try {
                this._loadingThread.join();
            }
            catch (InterruptedException ex) {
            }
            finally {
                this._loadingThread = null;
            }
        }
        if ((cNode = CompletionInsight._getConnNode(this.getURL())) == null && this.getDatabase() != null) {
            cNode = CMHelper.getConnectionNode(this.getDatabase().getDatabase().getConnectionName());
        }
        return (BaseInsightableItem)cNode.getClientProperty((Object)"database-insight-data");
    }

    static boolean isPlSqlDelimiter(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case ';': 
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    int getContextStartOffset() {
        TextBuffer textBuffer = this.getTextBuffer();
        int caretOffset = this.getCaretPosition();
        int prefixStart = CompletionInsight.getContextStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        return prefixStart;
    }

    static int getContextStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        char c;
        int pos;
        for (pos = caretOffset - 1; pos >= 0 && !CompletionInsight.isPlSqlDelimiter(c = textBuffer.getChar(pos)); --pos) {
        }
        return pos + 1;
    }

    String getDefaultInsightContext() {
        TextBuffer textBuffer = this.getTextBuffer();
        int caretOffset = this.getCaretPosition();
        int prefixStart = CompletionInsight.getContextStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        int prefixLength = caretOffset - prefixStart;
        String defaultPrefix = textBuffer.getString(prefixStart, prefixLength);
        Assert.println((String)("context = " + defaultPrefix));
        return defaultPrefix;
    }

    private boolean isValidContext() {
        int token;
        TextBuffer textBuffer = this.getTextBuffer();
        int caretOffset = this.getCaretPosition();
        Lexer lexer = PlsqlParser.createSqlLexer();
        LexerToken lexerToken = lexer.createLexerToken();
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setPosition(0);
        block4: while ((token = lexer.lex(lexerToken)) != 0) {
            int start = lexerToken.getStartOffset();
            int end = lexerToken.getEndOffset();
            if (end < caretOffset) continue;
            if (caretOffset < start || caretOffset == start) break;
            switch (token) {
                case 33: 
                case 49: {
                    if (caretOffset == end) break block4;
                    return false;
                }
                case 48: {
                    return false;
                }
            }
        }
        return true;
    }

    private final class InsightLoader
    implements Runnable {
        private InsightLoader() {
        }

        public void run() {
            InsightableDatabase db = CompletionInsight.this.getDatabase();
            if (db != null) {
                BaseInsightableItem bi = db.buildInsightableObjectTree();
                ConnectionNode cNode = CMHelper.getConnectionNode(db.getDatabase().getConnectionName());
                if (cNode != null) {
                    cNode.putClientProperty((Object)"database-insight-data", (Object)bi);
                }
            }
        }
    }
}

