/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.insight.AbstractListInsightData;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.insight.DatabaseDataItem;
import oracle.dbtools.raptor.insight.InsightableDatabase;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItemListModel;
import oracle.jdeveloper.cm.ds.db.insight.BaseInsightableItem;
import oracle.jdeveloper.cm.dt.CmUtil;

public class DatabaseListInsightData
extends AbstractListInsightData {
    final CompletionInsight _insight;
    private static final EditDescriptor _editDescriptor;
    private String _context = null;
    private String _schema;
    public static final String DATABASE_INSIGHT_PROPERTY = "database-insight-data";

    public DatabaseListInsightData(CompletionInsight insight, String context) {
        this._insight = insight;
        this._context = context;
        URL url = this._insight.getURL();
        this._schema = CmUtil.getSchema((URL)url);
        if (this._schema == null) {
            try {
                InsightableDatabase db = this._insight.getDatabase();
                this._schema = db.getDatabase().getUserName();
            }
            catch (Exception ex) {
                this._schema = null;
            }
        }
        this.updateContext(context);
    }

    protected String getUserPrefix() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        int prefixStart = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        int prefixLength = caretOffset - prefixStart;
        String defaultPrefix = textBuffer.getString(prefixStart, prefixLength);
        Assert.println((String)("defaultPrefix = " + defaultPrefix));
        return defaultPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(Object selectedObject) {
        DatabaseDataItem item = (DatabaseDataItem)((Object)selectedObject);
        String itemName = item.getName();
        BasicDocument document = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        int startOffset = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        int endOffset = this.getNameEndOffset((ReadTextBuffer)textBuffer, caretOffset);
        BasicEditorPane editor = this._insight.getEditorPane();
        editor.beginEdit(DatabaseListInsightData.getEditDescriptor());
        try {
            document.remove(startOffset, endOffset - startOffset);
            document.insertString(startOffset, itemName, null);
        }
        catch (BadLocationException e) {
            System.err.println("Exception occurred in completion: " + e);
            e.printStackTrace();
        }
        finally {
            editor.endEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialComplete() {
        BasicDocument document = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        document.readLock();
        try {
            int startOffset = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
            int endOffset = this.getNameEndOffset((ReadTextBuffer)textBuffer, caretOffset);
            int prefixLength = caretOffset - startOffset;
            String userPrefix = textBuffer.getString(startOffset, prefixLength);
            ListDataItemListModel ldiListModel = this.buildListModel();
            String commonPrefix = ldiListModel.findCommonPrefix(userPrefix);
            if (commonPrefix.length() == 0) {
                return;
            }
            BasicEditorPane editor = this._insight.getEditorPane();
            editor.beginEdit(DatabaseListInsightData.getEditDescriptor());
            try {
                document.remove(startOffset, endOffset - startOffset);
                document.insertString(startOffset, commonPrefix, null);
            }
            catch (BadLocationException e) {
                System.err.println("Exception occurred in partial completion: " + e);
                e.printStackTrace();
            }
            finally {
                editor.endEdit();
            }
        }
        finally {
            document.readUnlock();
        }
    }

    void updateContext(String context) {
        this._context = this._cleanContext(context);
        BaseInsightableItem root = this._insight.getBaseInsightableItem();
        if (root == null) {
            return;
        }
        List parsedContext = DatabaseListInsightData.parseContext(this._context);
        Iterator ctxIterator = parsedContext.iterator();
        BaseInsightableItem searchRoot = root;
        if (parsedContext.size() > 0) {
            while (ctxIterator.hasNext()) {
                String key = (String)ctxIterator.next();
                BaseInsightableItem item = searchRoot == root ? this.findItemTopLevel(root, key) : this.findItemInSearchRoot(searchRoot, key);
                if (item == null) break;
                searchRoot = item;
                Assert.println((String)("item for [" + key + "] = [" + item.toString() + "]"));
            }
        }
        if (parsedContext.size() > 0 && searchRoot == root) {
            this.clearData();
        } else {
            this.setDataAtItem(searchRoot);
        }
    }

    String _cleanContext(String context) {
        String s = context.trim();
        if (s.indexOf(46) == -1) {
            return "";
        }
        return s.substring(0, s.lastIndexOf(46));
    }

    BaseInsightableItem findItemInSearchRoot(BaseInsightableItem root, String key) {
        return root.getChild(key);
    }

    BaseInsightableItem findItemTopLevel(BaseInsightableItem topRoot, String key) {
        if (key == null) {
            return topRoot;
        }
        BaseInsightableItem schemaItem = topRoot.getChild(key);
        if (schemaItem != null) {
            return schemaItem;
        }
        schemaItem = topRoot.getChild(this._schema);
        if (schemaItem == null) {
            return topRoot.getChild(key);
        }
        BaseInsightableItem itemInCurrentSchema = schemaItem.getChild(key);
        if (itemInCurrentSchema == null) {
            schemaItem = topRoot.getChild("PUBLIC");
            return schemaItem.getChild(key);
        }
        return itemInCurrentSchema;
    }

    private void setDefaultRootData() {
        BaseInsightableItem bi = this._insight.getBaseInsightableItem();
        if (bi != null) {
            Iterator iter = Collections.EMPTY_LIST.iterator();
            iter = this._schema != null ? BaseInsightableItem.getSchemaLevelIterator((BaseInsightableItem)bi, (String)this._schema) : BaseInsightableItem.getTopLevelIterator((BaseInsightableItem)bi);
            this.setData(DatabaseDataItem.createDataItems(iter));
        }
    }

    private void setDataAtItem(BaseInsightableItem item) {
        BaseInsightableItem bi = this._insight.getBaseInsightableItem();
        if (item == bi) {
            this.setDefaultRootData();
        } else if (item == null) {
            this.clearData();
        } else {
            if (!item.isChildrenLoaded()) {
                this._insight.getDatabase().loadChildren(item);
            }
            Iterator iter = item.getChildrenIterator();
            this.setData(DatabaseDataItem.createDataItems(iter));
        }
    }

    private void clearData() {
        this.setData(DatabaseDataItem.EMPTY_LIST);
    }

    int getNameStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        char c;
        int pos;
        for (pos = caretOffset - 1; pos >= 0 && !DatabaseListInsightData.isPlSqlDelimiter(c = textBuffer.getChar(pos)); --pos) {
        }
        return pos + 1;
    }

    int getNameEndOffset(ReadTextBuffer textBuffer, int caretOffset) {
        char c;
        int checkPos;
        int bufferLength = textBuffer.getLength();
        for (checkPos = caretOffset; checkPos < bufferLength && !DatabaseListInsightData.isPlSqlDelimiter(c = textBuffer.getChar(checkPos)); ++checkPos) {
        }
        return checkPos;
    }

    static boolean isPlSqlDelimiter(char c) {
        return CompletionInsight.isPlSqlDelimiter(c) || c == '.';
    }

    static EditDescriptor getEditDescriptor() {
        return _editDescriptor;
    }

    static List parseContext(String context) {
        ArrayList<String> list = new ArrayList<String>(5);
        try {
            String cleanContext = context.trim();
            StringTokenizer st = new StringTokenizer(cleanContext, ".", false);
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                Assert.println((String)("parseContext: item=[" + next + "]"));
                next = next.startsWith("\"") && next.endsWith("\"") && next.length() > 2 ? next.substring(1, next.length() - 1) : next.toUpperCase();
                list.add(next);
            }
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
        return list;
    }

    static {
        String editName = Translate.translate("Undo Import");
        _editDescriptor = new EditDescriptor(editName);
    }
}

