/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.insight.InsightableDatabase;
import oracle.ide.util.Assert;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ds.db.DatabaseFactory;
import oracle.jdeveloper.cm.ds.db.insight.BaseInsightableItem;

public final class InsightableOracleDatabase
implements InsightableDatabase {
    private Connection _conn;
    private OracleDatabase _db;
    private BaseInsightableItem _tree;
    private volatile boolean _canceled;
    private static final String PUBLIC_SCHEMA = "PUBLIC";
    private static final String SQL_LIST_SCHEMAS = "SELECT username FROM sys.all_users ORDER BY username";
    private static final String SQL_ALL_OBJECT_LIST = "SELECT owner, object_name, object_type FROM sys.all_objects WHERE object_type IN ('PACKAGE', 'PROCEDURE', 'SEQUENCE', 'TABLE', 'TYPE', 'VIEW', 'FUNCTION' ) ORDER BY owner, object_name";
    private static final String SQL_ALL_SYNONYM_LIST = "SELECT s.owner, s.synonym_name, 'SYNONYM' as object_type FROM sys.all_synonyms s, sys.all_objects o WHERE s.table_name = o.object_name AND s.table_owner = o.owner AND object_type IN ('PACKAGE', 'PROCEDURE', 'SEQUENCE', 'TABLE', 'TYPE', 'VIEW', 'FUNCTION' ) ORDER BY s.owner, s.synonym_name";
    private static final String SQL_COLUMNS_FOR_TABLE = "SELECT column_name FROM sys.all_tab_columns WHERE owner = ? and table_name = ?";
    private static final String SQL_RESOLVE_SYNONYM = "select o.owner, o.object_name, o.object_type from sys.all_objects o, sys.all_synonyms s where s.table_name = o.object_name and s.table_owner = o.owner and s.synonym_name = ?";
    private static final String SQL_LIST_PACKAGE_SUBPROGRAMS = "select object_name, decode( min( position ), 0, 'FUNCTION', 1, 'PROCEDURE', 'PROCEDURE' ) from sys.all_arguments WHERE owner = ? AND package_name = ? group by object_name";
    private static final String SQL_LIST_OBJECT_METHODS = "select method_name, decode( results, 0, 'PROCEDURE', 1, 'FUNCTION', 'PROCEDURE' ) from sys.all_type_methods where owner=? and type_name=? and method_type = 'PUBLIC'";
    private static final String SQL_LIST_OBJECT_ATTRIBUTES = "select attr_name from sys.all_type_attrs where owner = ? and type_name = ?";
    private static final String SQL_LIST_PROCEDURES = "select object_name,argument_name,           decode(data_type,'PL/SQL TABLE',type_name,data_type) data_type,in_out            ,overload,sequence           from sys.all_arguments a    WHERE  owner = ?     and    package_name = ?     order by overload,sequence";
    private static final String[] EMPTY_ARGS = new String[0];

    public InsightableOracleDatabase(OracleDatabase db) {
        this._db = db;
        try {
            this._conn = DatabaseFactory.getConnection((String)this._db.getConnectionName());
        }
        catch (CMException cMException) {
            // empty catch block
        }
        if (this._conn == null) {
            this._conn = this._db.getConnection();
        }
    }

    public void close() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = InsightableOracleDatabase.this._conn;
                synchronized (connection) {
                    try {
                        InsightableOracleDatabase.this._conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this._canceled = true;
        Thread t = new Thread(r, "Insight Close Thread");
        t.start();
    }

    public Database getDatabase() {
        return this._db;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public BaseInsightableItem buildInsightableObjectTree() {
        if (this._tree == null) {
            this._tree = this._buildTree();
        }
        return this._tree;
    }

    public boolean loadChildren(BaseInsightableItem item) {
        String type = item.getType();
        if ("TABLE".equals(type) || "VIEW".equals(type)) {
            this._loadColumns(item);
        } else if ("SYNONYM".equals(type)) {
            BaseInsightableItem synItem = this._resolveSynonym(item);
            if (synItem != null) {
                this.loadChildren(synItem);
                synItem.copyChildrenTo(item);
            } else {
                Assert.println((String)("InsightableOracleDatabase loadChildren - Unable to resolve SYNONYM " + item.getName()));
            }
        } else if ("SEQUENCE".equals(type)) {
            this._loadSequence(item);
        } else if ("PACKAGE".equals(type)) {
            this._loadPackage(item);
        } else if ("TYPE".equals(type)) {
            this._loadObject(item);
        } else {
            Assert.println((String)("InsightableOracleDatabase loadChildren no code for type:" + type));
        }
        Assert.println((String)("InsightableOracleDatabase:loadChildren on " + item.toString()));
        return true;
    }

    private BaseInsightableItem _buildTree() {
        BaseInsightableItem result;
        try {
            BaseInsightableItem tree = new BaseInsightableItem(null, "", "");
            this._addSchemas(tree);
            this._addAllObjects(tree);
            InsightableOracleDatabase._addTopLevelPseudo(tree);
            this._addNumericBuiltinFunctions(tree);
            this._addStringBuiltinFunctions(tree);
            result = tree;
        }
        catch (SQLException ex) {
            boolean closed = false;
            try {
                closed = this._conn.isClosed();
            }
            catch (SQLException ex1) {
                // empty catch block
            }
            if (!closed) {
                Assert.println((String)ex.getLocalizedMessage());
            }
            result = new BaseInsightableItem(null, "", "");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addSchemas(BaseInsightableItem tree) throws SQLException {
        tree.putChild(new BaseInsightableItem("SCHEMA", PUBLIC_SCHEMA, PUBLIC_SCHEMA));
        Connection connection = this._conn;
        synchronized (connection) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareCall(SQL_LIST_SCHEMAS);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (this._canceled) {
                        break;
                    }
                    String schema = rs.getString(1);
                    tree.putChild(new BaseInsightableItem("SCHEMA", schema, schema));
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
    }

    private void _addAllObjects(BaseInsightableItem tree) throws SQLException {
        this._addAllNonSynonyms(tree);
        this._addAllSynonyms(tree);
    }

    private static void _addTopLevelPseudo(BaseInsightableItem tree) {
        BaseInsightableItem pub = tree.getChild(PUBLIC_SCHEMA);
        BaseInsightableItem item = new BaseInsightableItem("FUNCTION", PUBLIC_SCHEMA, "SYSDATE");
        pub.putChild(item);
        item = new BaseInsightableItem("FUNCTION", PUBLIC_SCHEMA, "USER");
        pub.putChild(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addAllNonSynonyms(BaseInsightableItem tree) throws SQLException {
        Connection connection = this._conn;
        synchronized (connection) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareCall(SQL_ALL_OBJECT_LIST);
                rs = stmt.executeQuery();
                BaseInsightableItem schemaItem = tree;
                while (rs.next()) {
                    if (this._canceled) {
                        break;
                    }
                    String schema = rs.getString(1);
                    String objName = rs.getString(2);
                    String objType = rs.getString(3);
                    BaseInsightableItem item = new BaseInsightableItem(objType, schema, objName);
                    if (schema != null) {
                        if (schemaItem == null || !schema.equals(schemaItem.getSchema())) {
                            schemaItem = tree.getChild(schema);
                        }
                        if (schemaItem == null) {
                            Assert.println((String)("No schemaItem for schema: [" + schema + "]"));
                            continue;
                        }
                        schemaItem.putChild(item);
                        continue;
                    }
                    Assert.println((String)(" null schema for [" + objType + "][" + objName + "]"));
                }
            }
            catch (RuntimeException ex) {
                throw new SQLException(ex.getLocalizedMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addAllSynonyms(BaseInsightableItem tree) throws SQLException {
        Connection connection = this._conn;
        synchronized (connection) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareCall(SQL_ALL_SYNONYM_LIST);
                rs = stmt.executeQuery();
                BaseInsightableItem schemaItem = tree;
                while (rs.next()) {
                    if (this._canceled) {
                        break;
                    }
                    String schema = rs.getString(1);
                    String objName = rs.getString(2);
                    String objType = rs.getString(3);
                    BaseInsightableItem item = new BaseInsightableItem(objType, schema, objName);
                    if (schema != null) {
                        if (schemaItem == null || !schema.equals(schemaItem.getSchema())) {
                            schemaItem = tree.getChild(schema);
                        }
                        if (schemaItem == null) {
                            Assert.println((String)("No schemaItem for schema: [" + schema + "]"));
                            continue;
                        }
                        schemaItem.putChild(item);
                        continue;
                    }
                    Assert.println((String)(" null schema for [" + objType + "][" + objName + "]"));
                }
            }
            catch (RuntimeException ex) {
                throw new SQLException(ex.getLocalizedMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addNumericBuiltinFunctions(BaseInsightableItem tree) throws SQLException {
        Connection connection = this._conn;
        synchronized (connection) {
            try {
                DatabaseMetaData dmd = this._conn.getMetaData();
                BaseInsightableItem pub = tree.getChild(PUBLIC_SCHEMA);
                String s = dmd.getNumericFunctions();
                StringTokenizer st = new StringTokenizer(s, ",", false);
                String type = "FUNCTION";
                while (st.hasMoreTokens() && !this._canceled) {
                    String tok = st.nextToken();
                    BaseInsightableItem tokItem = new BaseInsightableItem("FUNCTION", PUBLIC_SCHEMA, tok);
                    pub.putChild(tokItem);
                }
            }
            catch (RuntimeException ex) {
                throw new SQLException(ex.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addStringBuiltinFunctions(BaseInsightableItem tree) throws SQLException {
        Connection connection = this._conn;
        synchronized (connection) {
            try {
                DatabaseMetaData dmd = this._conn.getMetaData();
                BaseInsightableItem pub = tree.getChild(PUBLIC_SCHEMA);
                String s = dmd.getStringFunctions();
                StringTokenizer st = new StringTokenizer(s, ",", false);
                String type = "FUNCTION";
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    BaseInsightableItem tokItem = new BaseInsightableItem("FUNCTION", PUBLIC_SCHEMA, tok);
                    pub.putChild(tokItem);
                }
            }
            catch (RuntimeException ex) {
                throw new SQLException(ex.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseInsightableItem _resolveSynonym(BaseInsightableItem item) {
        BaseInsightableItem rsi = null;
        Connection connection = this._conn;
        synchronized (connection) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareCall(SQL_RESOLVE_SYNONYM, new String[]{item.getName()});
                rs = stmt.executeQuery();
                if (rs.next()) {
                    String schema = rs.getString(1);
                    String objName = rs.getString(2);
                    String objType = rs.getString(3);
                    rsi = new BaseInsightableItem(objType, schema, objName);
                }
            }
            catch (SQLException sqlEx) {
                Assert.printStackTrace((Throwable)sqlEx);
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        return rsi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _loadColumns(BaseInsightableItem item) {
        Assert.precondition(("TABLE".equals(item.getType()) || "VIEW".equals(item.getType()) || "SYNONYM".equals(item.getType()) ? 1 : 0) != 0, (String)"EnsureTypeOfLoadColumns");
        Connection connection = this._conn;
        synchronized (connection) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareCall(SQL_COLUMNS_FOR_TABLE, new String[]{item.getSchema(), item.getName()});
                rs = stmt.executeQuery();
                String type = "COLUMN";
                String schema = item.getSchema();
                while (rs.next() && !this._canceled) {
                    String name = rs.getString(1);
                    BaseInsightableItem rsi = new BaseInsightableItem("COLUMN", schema, name);
                    item.putChild(rsi);
                }
                BaseInsightableItem rowid = new BaseInsightableItem("COLUMN", schema, "ROWID");
                item.putChild(rowid);
            }
            catch (SQLException sqlEx) {
                Assert.printStackTrace((Throwable)sqlEx);
                boolean bl = false;
                return bl;
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {}
            }
            return true;
        }
    }

    private boolean _loadSequence(BaseInsightableItem item) {
        String type = "COLUMN";
        String schema = item.getSchema();
        String name = "CURRVAL";
        BaseInsightableItem rsi = new BaseInsightableItem("COLUMN", schema, name);
        item.putChild(rsi);
        name = "NEXTVAL";
        rsi = new BaseInsightableItem("COLUMN", schema, name);
        item.putChild(rsi);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean _loadPackage(BaseInsightableItem item) {
        Connection connection = this._conn;
        synchronized (connection) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareCall(SQL_LIST_PROCEDURES, new String[]{item.getSchema(), item.getName()});
                rs = stmt.executeQuery();
                String schema = item.getSchema();
                Object proc = null;
                String type = null;
                int overload = -1;
                String procName = null;
                StringBuffer name = null;
                while (rs.next()) {
                    if (this._canceled) {
                        break;
                    }
                    if (!rs.getString(1).equals(procName) || overload != rs.getInt(5)) {
                        if (procName != null) {
                            String typeAsString = rs.getString(2);
                            BaseInsightableItem rsi = new BaseInsightableItem(type, schema, name.length() == name.lastIndexOf(",") + 1 ? name.substring(0, name.length() - 1).toString() + ")" : name.toString() + ")");
                            item.putChild(rsi);
                            name = null;
                        }
                        procName = rs.getString(1);
                        type = rs.getInt(6) == 0 && rs.getString(3) != null ? "FUNCTION" : "PROCEDURE";
                    }
                    if (name == null) {
                        name = new StringBuffer(rs.getString(1) + "(");
                    }
                    if (rs.getString(2) == null) continue;
                    name.append(rs.getString(2) + ",");
                }
            }
            catch (SQLException sqlEx) {
                Assert.printStackTrace((Throwable)sqlEx);
                boolean bl = false;
                return bl;
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        return true;
    }

    private boolean _loadObject(BaseInsightableItem item) {
        boolean attrs = this._loadObjectAttributes(item);
        boolean methods = this._loadObjectMethods(item);
        return attrs && methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean _loadObjectMethods(BaseInsightableItem item) {
        Connection connection = this._conn;
        synchronized (connection) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareCall(SQL_LIST_OBJECT_METHODS, new String[]{item.getSchema(), item.getName()});
                rs = stmt.executeQuery();
                String schema = item.getSchema();
                while (rs.next()) {
                    if (this._canceled) {
                        break;
                    }
                    String name = rs.getString(1);
                    String typeAsString = rs.getString(2);
                    BaseInsightableItem rsi = new BaseInsightableItem(typeAsString, schema, name);
                    item.putChild(rsi);
                }
            }
            catch (SQLException sqlEx) {
                Assert.printStackTrace((Throwable)sqlEx);
                boolean bl = false;
                return bl;
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _loadObjectAttributes(BaseInsightableItem item) {
        Connection connection = this._conn;
        synchronized (connection) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.prepareCall(SQL_LIST_OBJECT_ATTRIBUTES, new String[]{item.getSchema(), item.getName()});
                rs = stmt.executeQuery();
                String type = "COLUMN";
                String schema = item.getSchema();
                while (rs.next() && !this._canceled) {
                    String name = rs.getString(1);
                    BaseInsightableItem rsi = new BaseInsightableItem("COLUMN", schema, name);
                    item.putChild(rsi);
                }
                BaseInsightableItem rowid = new BaseInsightableItem("COLUMN", schema, "ROWID");
                item.putChild(rowid);
            }
            catch (SQLException sqlEx) {
                Assert.printStackTrace((Throwable)sqlEx);
                boolean bl = false;
                return bl;
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {}
            }
            return true;
        }
    }

    private PreparedStatement prepareCall(String sql, String[] args) throws SQLException {
        PreparedStatement ps = this._conn.prepareStatement(sql);
        ps.setFetchSize(100);
        for (int i = 0; i < args.length; ++i) {
            ps.setString(i + 1, args[i]);
        }
        return ps;
    }

    private PreparedStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, EMPTY_ARGS);
    }
}

