/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metadata;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.metadata.MetaDataSql;
import oracle.dbtools.raptor.metadata.MetaObject;
import oracle.dbtools.raptor.utils.DBObject;

public class MetaData {
    public static Logger logger = Logger.getLogger(MetaData.class.toString());
    private MetaDataSql metaDataSql = new MetaDataSql();
    private static String META_SETUP = "begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', :SEGMENTS);   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'SQLTERMINATOR', :TERMINATOR);  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'PRETTY', :PRETTY);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'SIZE_BYTE_KEYWORD', :BYTE);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE', :FORCE);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS_AS_ALTER', :ALTER);end;";
    private boolean _segments = false;
    private boolean _terminiator = true;
    private boolean _pretty = true;
    private boolean _byte = true;
    private boolean _force = true;
    private boolean _alter = false;
    private BufferedOutputStream _out;
    private DataOutputStream _dataOut;
    private Connection _conn;
    private double _dbVer;
    private ArrayList<MetaObject> _metaObjects = new ArrayList();

    public void setSegments(boolean segments) {
        this._segments = segments;
    }

    public void setByte(boolean byteKeyword) {
        this._byte = byteKeyword;
    }

    public void setforce(boolean force) {
        this._force = force;
    }

    public void setTerminator(boolean term) {
        this._terminiator = term;
    }

    public void setPretty(boolean pretty) {
        this._pretty = pretty;
    }

    public void setAlter(boolean alter) {
        this._alter = alter;
    }

    public void setOutputStream(OutputStream out) {
        this._out = new BufferedOutputStream(out);
        this._dataOut = new DataOutputStream(this._out);
    }

    public void closeOutputStream() {
        try {
            this._out.close();
            this._dataOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup() {
        if (this._out == null) {
            this.setOutputStream(System.out);
        }
        Statement stmt = null;
        try {
            this._dbVer = Double.parseDouble(this._conn.getMetaData().getDatabaseMajorVersion() + "." + this._conn.getMetaData().getDatabaseMinorVersion());
            stmt = this._conn.prepareCall(META_SETUP);
            stmt.setBoolean(1, this._segments);
            stmt.setBoolean(2, this._terminiator);
            stmt.setBoolean(3, this._pretty);
            stmt.setBoolean(4, this._byte);
            stmt.setBoolean(5, this._force);
            stmt.setBoolean(6, this._alter);
            stmt.execute();
        }
        catch (SQLException e) {
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public void setConnection(Connection conn) {
        this._conn = conn;
        try {
            this._dbVer = this._conn.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void addObject(String schema, String type, String name) {
        this._metaObjects.add(new MetaObject(schema, type, name));
    }

    public void addObject(String schema, String type) {
        this._metaObjects.add(new MetaObject(schema, type));
    }

    private void write(String s) throws IOException {
        this._dataOut.write(s.getBytes("utf8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDDL() throws IOException {
        this.setup();
        long start = System.currentTimeMillis();
        HashMap<String, String> binds = new HashMap<String, String>();
        Statement stmt = null;
        ResultSet rset = null;
        for (MetaObject obj : this._metaObjects) {
            logger.info("Starting:" + obj.getName());
            long start2 = System.currentTimeMillis();
            binds.clear();
            try {
                binds.put("OWNER", obj.getSchema());
                binds.put("TYPE", obj.getType());
                if (!obj.isAll()) {
                    binds.put("NAME", obj.getName());
                }
                stmt = this._conn.prepareStatement(this.metaDataSql.getSelect(this._dbVer, obj.getType(), obj.getName(), obj.getSchema()));
                DBUtil.getInstance().bind((PreparedStatement)stmt, binds);
                rset = stmt.executeQuery();
                while (rset.next()) {
                    if (rset.getBytes(2) != null) {
                        this.write("\nREM " + rset.getString(2) + " " + rset.getString(3) + "\n");
                    }
                    this.printDDL(obj.getType(), rset.getString(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex) {}
                try {
                    if (rset != null) {
                        rset.close();
                    }
                }
                catch (SQLException ex) {}
            }
            logger.info("\tFinished:" + obj.getName());
            logger.info("\tElapsed:" + (System.currentTimeMillis() - start2) + "ms");
        }
        this._out.flush();
        logger.info("Elapsed:" + (System.currentTimeMillis() - start) + "ms");
    }

    private void printDDL(String type, String ddl) throws IOException {
        this.write(ddl);
    }

    public static String getDDL(DBObject dbObject) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MetaData meta = new MetaData();
        meta.addObject(dbObject.getSchemaName(), dbObject.getObjectType(), dbObject.getObjectName());
        meta.setConnection(dbObject.getDatabase().getConnection());
        meta.setOutputStream(out);
        try {
            meta.printDDL();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String s1 = null;
        try {
            s1 = out.toString("utf8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return s1;
    }

    public int getQueuedCount() {
        return this._metaObjects.size();
    }

    public void reset() {
        this._metaObjects.clear();
    }
}

