/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.models;

import java.awt.Color;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModelBuffer;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.util.Assert;
import oracle.ide.util.SwingWorker;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleResultSet;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.sql.Datum;
import oracle.sql.ROWID;

public final class EditableResultSetTableModel
extends ResultSetTableModel {
    private Statement _stmt;
    private ResultSetMetaData _rsmd;
    private ArrayList _log;
    private boolean _insertOnly;
    private String _modifiedSql;
    private boolean _changed;
    private boolean _valid = true;
    private int _colOffset;
    private boolean _dataIntegrity;
    private boolean _updatedByAnotherUser;
    private String _whereClause;
    private String _orderByClause;
    private SwingWorker _worker;
    private String _nlsDateFormat;
    private String _tsFormat;
    private String _tstzFormat;
    private TableColumnModel _tabColModel;

    public EditableResultSetTableModel(Connection conn, ResultSet rs, String sql, Database db) {
        super(conn, rs, sql, db);
        try {
            this._rsmd = this._rs.getMetaData();
        }
        catch (Exception ex) {
            this._valid = false;
        }
        this._stmt = null;
        this._log = new ArrayList();
        this._insertOnly = false;
        this._changed = false;
        this._updatedByAnotherUser = false;
        this.setTranslatedColNames(false);
    }

    public boolean open() {
        return this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(boolean skipSCN) {
        Connection connection = this._conn;
        synchronized (connection) {
            try {
                if (this._stmt == null) {
                    this._stmt = this._conn.createStatement();
                }
                if (this._rs == null || skipSCN) {
                    try {
                        this._stmt.setMaxRows(0);
                    }
                    catch (SQLException ex) {
                    }
                    catch (AbstractMethodError ex) {
                        // empty catch block
                    }
                    this._rs = (OracleResultSet)this._stmt.executeQuery(EditableResultSetTableModel._sanitizeOracleSQL(this._sql));
                }
                this._isExternalTable = this.isExternalTable(this._tablename);
                if (this._isExternalTable) {
                    this._valid = false;
                }
                this._buildModifiedSql(skipSCN);
                this._rs = (OracleResultSet)this._stmt.executeQuery(EditableResultSetTableModel._sanitizeOracleSQL(this._modifiedSql));
                this._createColumnNamesList();
                this._fetchNext(0);
                this.fireTableStructureChanged();
            }
            catch (SQLException ex) {
                if (!skipSCN) {
                    this.open(true);
                } else {
                    SQLErrorDialog.showErrorDialog(null, (String)ConnectionArb.getString((int)201), (SQLException)ex);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int row, int column) {
        if (this._rows != null) {
            Object rowObj;
            if (row >= this._rows.size()) {
                Object object = LOCK;
                synchronized (object) {
                    if (this._worker == null) {
                        this._fetchNext(row - this._rows.size());
                    }
                }
            }
            if (row < this._rows.size() && (rowObj = this._rows.get(row)) != null) {
                List rowList = null;
                if (rowObj instanceof ResultSetTableModelBuffer) {
                    ResultSetTableModelBuffer rowBuffer = (ResultSetTableModelBuffer)rowObj;
                    if (column == 0 && rowBuffer.getDeleted()) {
                        return new String("-" + (row + 1));
                    }
                    if (column == 0 && rowBuffer.getNew()) {
                        return new String("+" + (row + 1));
                    }
                    if (column == 0 && rowBuffer.getChanged()) {
                        return new String("*" + (row + 1));
                    }
                    rowList = rowBuffer.getChanged() || rowBuffer.getNew() ? rowBuffer.getChangedRow() : rowBuffer.getOriginalRow();
                } else {
                    rowList = (ArrayList)rowObj;
                }
                if (column == 0) {
                    return new Integer(row + 1);
                }
                if (rowList != null) {
                    return rowList.get(column - 1);
                }
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        if (this._isExternalTable) {
            return false;
        }
        if (col == 0) {
            return false;
        }
        return !this._insertOnly || this.isRowNew(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this._rows != null && rowIndex >= this._rows.size()) {
            Object object = LOCK;
            synchronized (object) {
                if (this._worker == null) {
                    this._fetchNext(rowIndex - this._rows.size());
                }
            }
        }
        if (columnIndex == 0) {
            return;
        }
        if (rowIndex < this._rows.size()) {
            List<Object> changedRow = null;
            Object rowObj = this._rows.get(rowIndex);
            ResultSetTableModelBuffer rowBuffer = null;
            if (rowObj != null) {
                Object rowList = null;
                if (rowObj instanceof ResultSetTableModelBuffer) {
                    rowBuffer = (ResultSetTableModelBuffer)rowObj;
                    changedRow = rowBuffer.getChanged() || rowBuffer.getNew() ? rowBuffer.getChangedRow() : new ArrayList<Object>(rowBuffer.getOriginalRow());
                } else {
                    ArrayList r = (ArrayList)rowObj;
                    changedRow = (ArrayList)r.clone();
                    rowBuffer = new ResultSetTableModelBuffer((ArrayList)rowObj);
                }
            }
            if (!(changedRow == null || changedRow.get(columnIndex - 1) != null && DataTypesUtil.isEqual(changedRow.get(columnIndex - 1), aValue, this._conn, this.getType(columnIndex - 1)) || changedRow.get(columnIndex - 1) == null && aValue.toString().length() == 0)) {
                changedRow.set(columnIndex - 1, aValue);
                rowBuffer.setChangedRow(changedRow);
                rowBuffer.setChanged(true);
                rowBuffer.setError(false);
                this._rows.set(rowIndex, rowBuffer);
                if (rowBuffer.getOriginalRow() != null && !ModelUtil.areDifferent(rowBuffer.getOriginalRow().get(columnIndex - 1), rowBuffer.getChangedRow().get(columnIndex - 1))) {
                    rowBuffer.reset();
                }
                this._changed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int save() {
        if (!this._valid) {
            return 1;
        }
        int numberOfErrors = 0;
        this._log.clear();
        Connection connection = this._conn;
        synchronized (connection) {
            int i;
            ResultSetTableModelBuffer rowBuffer;
            Object rowObj;
            this._nlsDateFormat = NLSUtils.getDateFormat(this._conn);
            this._tsFormat = NLSUtils.getFormat(this._conn, "NLS_TIMESTAMP_FORMAT");
            this._tstzFormat = NLSUtils.getFormat(this._conn, "NLS_TIMESTAMP_TZ_FORMAT");
            boolean autoCommit = true;
            try {
                autoCommit = this._conn.getAutoCommit();
                this._conn.setAutoCommit(false);
                if (this._stmt != null) {
                    this._stmt.close();
                }
                this._stmt = this._conn.createStatement();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!this._insertOnly) {
                int i2;
                for (i2 = 0; i2 < this._rows.size(); ++i2) {
                    rowObj = this._rows.get(i2);
                    if (rowObj == null || !(rowObj instanceof ResultSetTableModelBuffer) || !(rowBuffer = (ResultSetTableModelBuffer)rowObj).getDeleted() || rowBuffer.getNew() || this.deleteRow(rowBuffer)) continue;
                    ++numberOfErrors;
                }
                for (i2 = 0; i2 < this._rows.size(); ++i2) {
                    rowObj = this._rows.get(i2);
                    if (rowObj == null || !(rowObj instanceof ResultSetTableModelBuffer) || !(rowBuffer = (ResultSetTableModelBuffer)rowObj).getChanged() || rowBuffer.getNew() || rowBuffer.getDeleted() || this.updateRow(rowBuffer)) continue;
                    ++numberOfErrors;
                }
            }
            for (i = 0; i < this._rows.size(); ++i) {
                rowObj = this._rows.get(i);
                if (rowObj == null || !(rowObj instanceof ResultSetTableModelBuffer) || !(rowBuffer = (ResultSetTableModelBuffer)rowObj).getNew() || !rowBuffer.getChanged() || rowBuffer.getDeleted() || this.insertRow(rowBuffer)) continue;
                ++numberOfErrors;
            }
            boolean saveSuccess = true;
            if (numberOfErrors > 0) {
                saveSuccess = false;
                try {
                    this._conn.rollback();
                }
                catch (SQLException ex) {}
            } else {
                try {
                    this._conn.commit();
                }
                catch (SQLException e) {
                    saveSuccess = false;
                    numberOfErrors = 1;
                }
            }
            if (saveSuccess && this._dataIntegrity) {
                for (i = 0; i < this._rows.size(); ++i) {
                    Object rowObj2 = this._rows.get(i);
                    if (rowObj2 == null || !(rowObj2 instanceof ResultSetTableModelBuffer)) continue;
                    ResultSetTableModelBuffer rowBuffer2 = (ResultSetTableModelBuffer)rowObj2;
                    this.selectRowscn(rowBuffer2);
                }
            }
            if (saveSuccess) {
                this.clearChanges();
            }
            this.fireTableDataChanged();
            try {
                this._conn.setAutoCommit(autoCommit);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return numberOfErrors;
    }

    public int rollback() {
        if (!this._valid) {
            return 1;
        }
        int numberOfErrors = 0;
        this._log.clear();
        for (int i = this._rows.size() - 1; i >= 0; --i) {
            Object rowObj = this._rows.get(i);
            if (rowObj == null || !(rowObj instanceof ResultSetTableModelBuffer)) continue;
            ResultSetTableModelBuffer rowBuffer = (ResultSetTableModelBuffer)rowObj;
            if (rowBuffer.getNew()) {
                this._rows.remove(i);
                continue;
            }
            rowBuffer.setChangedRow(null);
            rowBuffer.setChanged(false);
            rowBuffer.setError(false);
            rowBuffer.setDeleted(false);
            rowBuffer.setNew(false);
        }
        this._changed = false;
        this._updatedByAnotherUser = false;
        this.fireTableDataChanged();
        return numberOfErrors;
    }

    public boolean isRowDeleted(int row) {
        ResultSetTableModelBuffer rowBuffer;
        Object rowObj;
        return row < this._rows.size() && (rowObj = this._rows.get(row)) != null && rowObj instanceof ResultSetTableModelBuffer && (rowBuffer = (ResultSetTableModelBuffer)rowObj).getDeleted();
    }

    public boolean isRowChanged(int row) {
        ResultSetTableModelBuffer rowBuffer;
        Object rowObj;
        return row < this._rows.size() && (rowObj = this._rows.get(row)) != null && rowObj instanceof ResultSetTableModelBuffer && (rowBuffer = (ResultSetTableModelBuffer)rowObj).getChanged();
    }

    public boolean isRowNew(int row) {
        ResultSetTableModelBuffer rowBuffer;
        Object rowObj;
        return row < this._rows.size() && (rowObj = this._rows.get(row)) != null && rowObj instanceof ResultSetTableModelBuffer && (rowBuffer = (ResultSetTableModelBuffer)rowObj).getNew();
    }

    public boolean isRowError(int row) {
        ResultSetTableModelBuffer rowBuffer;
        Object rowObj;
        return row < this._rows.size() && (rowObj = this._rows.get(row)) != null && rowObj instanceof ResultSetTableModelBuffer && (rowBuffer = (ResultSetTableModelBuffer)rowObj).getError();
    }

    public String getErrorMessage(int row) {
        Object rowObj;
        if (row < this._rows.size() && (rowObj = this._rows.get(row)) != null && rowObj instanceof ResultSetTableModelBuffer) {
            ResultSetTableModelBuffer rowBuffer = (ResultSetTableModelBuffer)rowObj;
            return rowBuffer.getErrorMessage();
        }
        return null;
    }

    public boolean markRowDeleted(int row, boolean deleted) {
        if (this._insertOnly) {
            return false;
        }
        if (row < this._rows.size()) {
            Object rowObj = this._rows.get(row);
            if (rowObj != null) {
                if (rowObj instanceof ResultSetTableModelBuffer) {
                    ResultSetTableModelBuffer rowBuffer = (ResultSetTableModelBuffer)rowObj;
                    rowBuffer.setDeleted(deleted);
                    rowBuffer.setError(false);
                } else {
                    ResultSetTableModelBuffer rowBuffer = new ResultSetTableModelBuffer((ArrayList)rowObj);
                    rowBuffer.setDeleted(deleted);
                    this._rows.set(row, rowBuffer);
                }
            }
            this.fireTableDataChanged();
            this._changed = true;
        }
        return true;
    }

    public boolean addRow(int row) {
        if (!this._valid) {
            return false;
        }
        ArrayList<String> newRow = null;
        ResultSetTableModelBuffer newBuffer = null;
        newRow = new ArrayList<String>();
        for (int i = 1; i < this.getColumnCount(); ++i) {
            newRow.add("");
        }
        newBuffer = new ResultSetTableModelBuffer();
        newBuffer.setChangedRow(newRow);
        newBuffer.setNew(true);
        newBuffer.setChanged(true);
        this._rows.add(row, newBuffer);
        this._changed = true;
        this.fireTableDataChanged();
        return true;
    }

    public String getTableName() {
        return this._tablename;
    }

    public ArrayList getLog() {
        return this._log;
    }

    public void setInsertOnly() {
        this._insertOnly = true;
    }

    /*
     * Exception decompiling
     */
    private boolean insertRow(ResultSetTableModelBuffer rowBuffer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean updateRow(ResultSetTableModelBuffer rowBuffer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 49[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRow(ResultSetTableModelBuffer rowBuffer) {
        block21: {
            StringBuffer sqlText = new StringBuffer("DELETE FROM ");
            sqlText.append(this._tablename + " WHERE ROWID = ");
            StringBuffer logText = new StringBuffer(sqlText.toString());
            sqlText.append("?");
            logText.append(this.quote(rowBuffer.getRowId()));
            if (this._dataIntegrity) {
                sqlText.append(" AND ORA_ROWSCN = ?");
                logText.append(" AND ORA_ROWSCN = " + this.quote(rowBuffer.getRowscn()));
                String col = this.getColumnDBName(1);
                sqlText.append(" and ( " + col + " is null or " + col + " is not null )");
                logText.append(" and /* workaround for base db bug */( " + col + " is null or " + col + " is not null )");
            }
            this._log.add(logText.toString());
            PreparedStatement prep = null;
            try {
                int numDeletes;
                prep = this._conn.prepareStatement(sqlText.toString());
                prep.setString(1, rowBuffer.getRowId());
                if (this._dataIntegrity) {
                    prep.setString(2, rowBuffer.getRowscn());
                }
                if ((numDeletes = prep.executeUpdate()) == 1) {
                    rowBuffer.setCommitted();
                    break block21;
                }
                if (numDeletes == 0) {
                    rowBuffer.setError(ConnectionArb.getString((int)666) + System.getProperty("line.separator"));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                Log.log(ex.getLocalizedMessage());
                rowBuffer.setError(ex.getLocalizedMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (prep != null) {
                        prep.close();
                    }
                }
                catch (SQLException e) {}
            }
        }
        return true;
    }

    public void clearChanges() {
        for (int i = this._rows.size() - 1; i >= 0; --i) {
            Object rowObj = this._rows.get(i);
            if (rowObj == null || !(rowObj instanceof ResultSetTableModelBuffer)) continue;
            ResultSetTableModelBuffer rowBuffer = (ResultSetTableModelBuffer)rowObj;
            if (rowBuffer.getDeleted() && (rowBuffer.getCommitted() || rowBuffer.getNew()) || rowBuffer.getNew() && !rowBuffer.getChanged()) {
                this._rows.remove(i);
                continue;
            }
            if (!rowBuffer.getChanged() && !rowBuffer.getNew()) continue;
            rowBuffer.clearChanges();
        }
        this._changed = false;
    }

    public boolean getChanged() {
        return this._changed;
    }

    public boolean getValid() {
        return this._valid;
    }

    public boolean getUpdatedByAnotherUser() {
        return this._updatedByAnotherUser;
    }

    public void setChanged(boolean changed) {
        this._changed = changed;
    }

    public void setOrderBy(String orderBy) {
        this._orderByClause = orderBy;
    }

    public void setWhere(String where) {
        this._whereClause = where;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _fetchNext(final int fetchAtLeast) {
        final int fetchSize = this._getFetchSize();
        int numCols = this._colNames.size() + this._colOffset;
        OracleResultSet rs = this._rs;
        int colOffset = this._colOffset;
        boolean dataIntegrity = this._dataIntegrity;
        WaitCursor wc = Ide.getWaitCursor();
        wc.show(500L);
        Object object = LOCK;
        synchronized (object) {
            if (this._rows == null) {
                this._rows = new ArrayList();
            }
            List rows = this._rows;
            this._worker = new SwingWorker((ResultSet)rs, colOffset, numCols, dataIntegrity, rows, wc){
                final /* synthetic */ ResultSet val$rs;
                final /* synthetic */ int val$colOffset;
                final /* synthetic */ int val$numCols;
                final /* synthetic */ boolean val$dataIntegrity;
                final /* synthetic */ List val$rows;
                final /* synthetic */ WaitCursor val$wc;
                {
                    this.val$rs = resultSet;
                    this.val$colOffset = n3;
                    this.val$numCols = n4;
                    this.val$dataIntegrity = bl;
                    this.val$rows = list;
                    this.val$wc = waitCursor;
                }

                public Object construct() {
                    ArrayList<ResultSetTableModelBuffer> newRows = new ArrayList<ResultSetTableModelBuffer>(fetchSize);
                    try {
                        for (int count = Math.max(fetchSize, fetchAtLeast); count > 0 && this.val$rs.next(); --count) {
                            ArrayList<Datum> row = new ArrayList<Datum>();
                            for (int i = 1 + this.val$colOffset; i <= this.val$numCols; ++i) {
                                int type = EditableResultSetTableModel.this.getType(i - (1 + this.val$colOffset));
                                Object o = ((OracleResultSet)this.val$rs).getOracleObject(i);
                                if (type == 1111 && o instanceof ROWID) {
                                    String urowidStr = this.val$rs.getString(i);
                                    byte[] urowidBytes = urowidStr.getBytes();
                                    o = new ROWID(urowidBytes);
                                } else if (o instanceof byte[]) {
                                    o = EditableResultSetTableModel.this.rawToHex((byte[])o);
                                }
                                row.add((Datum)o);
                            }
                            ResultSetTableModelBuffer rowBuffer = new ResultSetTableModelBuffer(row);
                            rowBuffer.setRowId(this.val$rs.getString(1));
                            if (this.val$dataIntegrity) {
                                rowBuffer.setRowscn(this.val$rs.getString(2));
                            }
                            newRows.add(rowBuffer);
                        }
                    }
                    catch (SQLException sqlEx) {
                        Assert.printStackTrace((Throwable)sqlEx);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return newRows;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished() {
                    try {
                        Object result = this.get();
                        if (result instanceof List) {
                            List l = (List)result;
                            int size = l.size();
                            if (size > 0) {
                                this.val$rows.addAll(l);
                            }
                            if (size < fetchSize) {
                                EditableResultSetTableModel.this._allFetched = true;
                                Log.status(Translate.translate("All Rows Fetched: ") + EditableResultSetTableModel.this.getRowCount());
                            } else {
                                Log.status(Translate.translate("Fetched Rows: ") + EditableResultSetTableModel.this.getRowCount());
                            }
                            EditableResultSetTableModel.this.fireTableDataChanged();
                        }
                    }
                    finally {
                        this.val$wc.hide();
                        Object object = ResultSetTableModel.LOCK;
                        synchronized (object) {
                            EditableResultSetTableModel.this._worker = null;
                        }
                    }
                }
            };
            this._worker.start();
        }
    }

    public int getRowCount() {
        int count = 0;
        if (this._rows != null) {
            count = this._rows.size();
            if (!this._allFetched) {
                count += 5;
            }
        }
        return count;
    }

    private String formatValue(Object value) {
        if (value == null) {
            return " null ";
        }
        try {
            return this._db.quoteIdentifier(value.toString(), true);
        }
        catch (Exception exception) {
            return this.quote(value.toString());
        }
    }

    private String quote(String value) {
        if (value == null) {
            return "";
        }
        String ret = value.replaceAll("'", "''");
        return "'" + ret + "'";
    }

    private void _createColumnNamesList() throws SQLException {
        ResultSetMetaData rsmd = this._rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        this._colNames = new ArrayList(numCols - 1);
        int[] types = new int[numCols - this._colOffset];
        int typeIdx = 0;
        for (int i = 1 + this._colOffset; i <= numCols; ++i) {
            this._colNames.add(rsmd.getColumnLabel(i));
            types[typeIdx++] = rsmd.getColumnType(i);
        }
        this.setTypes(types);
    }

    private void _buildModifiedSql(boolean skipSCN) throws SQLException {
        ResultSetMetaData rsmd = null;
        boolean skipRowID = false;
        StringBuffer modSql = new StringBuffer("SELECT ");
        if (this._isExternalTable && !(this._db instanceof Oracle10gR2)) {
            skipRowID = true;
            skipSCN = true;
        }
        if (!skipRowID) {
            modSql.append("ROWID,");
            this._colOffset = 1;
        }
        if (this._db instanceof Oracle10gR2 && !skipSCN) {
            modSql.append(" ORA_ROWSCN,");
            this._colOffset = 2;
            this._dataIntegrity = true;
        }
        rsmd = this._rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        for (int i = 1; i <= numCols; ++i) {
            int type;
            modSql.append("\"" + rsmd.getColumnLabel(i) + "\"");
            if (i != numCols) {
                modSql.append(",");
            }
            if ((type = rsmd.getColumnType(i)) == 1111) {
                modSql.append(" ||''  \"" + rsmd.getColumnLabel(i) + "\"");
            }
            Assert.println((String)("Type:" + type));
        }
        modSql.append(" FROM " + this._tablename);
        if (this._whereClause != null && this._whereClause.length() > 0) {
            modSql.append(" WHERE " + this._whereClause);
        }
        if (this._orderByClause != null && this._orderByClause.length() > 0) {
            modSql.append(" ORDER BY " + this._orderByClause);
        }
        this._modifiedSql = modSql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectRowscn(ResultSetTableModelBuffer rowBuffer) {
        String selectRowscn = "SELECT ORA_ROWSCN FROM " + this._tablename + " WHERE ROWID = ?";
        ResultSet rs = null;
        PreparedStatement prep2 = null;
        try {
            prep2 = this._conn.prepareStatement(selectRowscn);
            prep2.setString(1, rowBuffer.getRowId());
            rs = prep2.executeQuery();
            if (!rs.next()) {
                return;
            }
            rowBuffer.setRowscn(rs.getString(1));
        }
        catch (SQLException ex) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {}
            try {
                if (prep2 != null) {
                    prep2.close();
                }
            }
            catch (SQLException ex) {}
        }
    }

    public String getColumnDBName(int column) {
        int viewIndex = -1;
        for (int col = 0; col < this.getColumnCount(); ++col) {
            if (this._tabColModel.getColumn(col).getModelIndex() != column) continue;
            viewIndex = col;
            break;
        }
        if (column <= 0 || viewIndex == -1) {
            return null;
        }
        return this.getRawColumnName(viewIndex);
    }

    public String getRawColumnName(int column) {
        return (String)this._colNames.get(column);
    }

    public Border getRowCountBorder(int row, int column) {
        Object rowObj = this._rows.size() > row ? this._rows.get(row) : null;
        Border ret = null;
        if (rowObj != null && rowObj instanceof ResultSetTableModelBuffer) {
            ResultSetTableModelBuffer rowBuffer = rowObj;
            if (column == 0 && rowBuffer.getDeleted()) {
                ret = BorderFactory.createEtchedBorder(Color.RED, Color.BLACK);
            } else if (column == 0 && rowBuffer.getChanged()) {
                ret = BorderFactory.createEtchedBorder(Color.BLUE, Color.BLACK);
            } else if (rowBuffer.getChanged() || rowBuffer.getNew()) {
                ret = BorderFactory.createEtchedBorder(Color.GREEN, Color.BLACK);
            }
        }
        return ret;
    }

    public String getSQL() {
        if (this._modifiedSql != null) {
            return this._modifiedSql.replaceAll("ROWID,", "").replaceAll("ORA_ROWSCN,", "");
        }
        return null;
    }

    public void setColumnModel(TableColumnModel columnModel) {
        this._tabColModel = columnModel;
    }
}

