/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.models;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdbc.OracleResultSet;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.sql.Datum;
import oracle.sql.ROWID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetTableModel
extends AbstractTableModel {
    protected static final Object LOCK = new Object();
    private static final String[] LINK_COLS = new String[]{"SDEV_LINK_OWNER", "SDEV_LINK_NAME", "SDEV_LINK_TYPE"};
    protected volatile ProgressRunnable _runner;
    protected Connection _conn;
    protected String _sql;
    protected OracleResultSet _rs;
    private PreparedStatement _stmt;
    private Query _query = null;
    protected List _colNames;
    protected List _rows;
    protected boolean _allFetched;
    protected ArrayList _bindList = null;
    protected HashMap _bindMap = null;
    protected DBUtil _dbUtil = new DBUtil();
    protected Database _db;
    private int[] _colSizes;
    private int[] _types;
    private JLabel _label = new JLabel("");
    private boolean _runInThread = true;
    private boolean _translatedColNames = true;
    private boolean _verticalDisplay = false;
    private static final int FETCH_SIZE = 50;
    private final ArrayList<String> _skipCols = new ArrayList();
    private String _whereClause;
    private String _orderByClause;
    private boolean _isRunning;
    private final ArrayList<URL> _drillUrls = new ArrayList();
    private String _connName;
    protected String _schemaName;
    protected boolean _isExternalTable = false;
    protected String _tablename;
    private PreparedStatement stmt = null;
    private static final int MAX_RS_FETCHSIZE = 1000;

    public void cancelStmt() {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ResultSetTableModel() {
    }

    public ResultSetTableModel(Connection conn, ResultSet rs, String sql, ArrayList binds) {
        this.setBindList(binds);
        this.setBindMap(null);
        this.init(conn, rs, sql);
    }

    public ResultSetTableModel(Connection conn, ResultSet rs, Query query) {
        this(conn, rs, query.getSql(), query.getBindValues());
        this._query = query;
        this.setSkipCols(query.getSkipCols());
    }

    public ResultSetTableModel(Connection conn, ResultSet rs, String sql, HashMap binds) {
        this.setBindMap(binds);
        this.setBindList(null);
        this.init(conn, rs, sql);
    }

    public ResultSetTableModel(Connection conn, ResultSet rs, String sql) {
        this.init(conn, rs, sql);
    }

    public ResultSetTableModel(Connection conn, ResultSet rs, String sql, Database db) {
        this._db = db;
        this.init(conn, rs, sql);
    }

    public void init(Connection conn, ResultSet rs, String sql) {
        for (String s : LINK_COLS) {
            this._skipCols.add(s);
        }
        this.setConn(conn);
        this.setSql(sql);
        if (rs != null) {
            this._rs = (OracleResultSet)rs;
            try {
                this._stmt = (PreparedStatement)rs.getStatement();
            }
            catch (SQLException ex) {
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        this._tablename = this._sql.substring(14, this._sql.length());
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExternalTable(String tableName) {
        String selectExtTab = "SELECT OWNER,TABLE_NAME FROM all_external_tables";
        ArrayList<String> extTabList = new ArrayList<String>();
        ResultSet rs = null;
        PreparedStatement prep2 = null;
        try {
            prep2 = this._conn.prepareStatement(selectExtTab);
            rs = prep2.executeQuery();
            while (rs.next()) {
                String extTab = this._db.quoteIdentifier(rs.getString(1), true) + "." + this._db.quoteIdentifier(rs.getString(2), true);
                extTabList.add(extTab);
            }
        }
        catch (SQLException ex) {
        }
        catch (DBException e) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {}
            try {
                if (prep2 != null) {
                    prep2.close();
                }
            }
            catch (SQLException ex) {}
        }
        return extTabList.contains(tableName);
    }

    public String getSQL() {
        StringBuilder ret = new StringBuilder(this._sql);
        if (this._whereClause != null && this._whereClause.trim().length() > 0) {
            if (this._whereClause.trim().toLowerCase().indexOf("where") != 0) {
                ret.append(" where ");
            }
            ret.append(this._whereClause);
        }
        if (this._orderByClause != null && this._orderByClause.trim().length() > 0) {
            if (this._orderByClause.trim().toLowerCase().indexOf("order by") != 0) {
                ret.append(" order by  ");
            }
            ret.append(this._orderByClause);
        }
        return ResultSetTableModel._sanitizeOracleSQL(ret.toString());
    }

    public ResultSet openResultSet() throws SQLException {
        Log.log("Opening:" + this.getSql());
        this.stmt = this.getConn().prepareStatement(this.getSQL());
        if (this.getBindList() != null) {
            this._dbUtil.bind(this.stmt, this.getBindList());
        } else if (this.getBindMap() != null) {
            this._dbUtil.bind(this.getSql(), this.stmt, this.getBindMap());
        }
        return this.stmt.executeQuery();
    }

    public boolean open() {
        if (Connections.getInstance().getDatabase(this._conn) != null) {
            this._connName = Connections.getInstance().getDatabase(this._conn).getConnectionName();
        }
        this._drillUrls.clear();
        this._fetchNext(this._getFetchSize());
        this.fireTableStructureChanged();
        this._setColWidths();
        return true;
    }

    private void _cleanup() {
        this._rows = null;
        this._allFetched = false;
        try {
            if (this._rs != null) {
                this._rs.close();
            }
            this._rs = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean close() {
        if (this._rs != null) {
            try {
                Statement stmt = this._rs.getStatement();
                this._cleanup();
                if (stmt != null) {
                    stmt.close();
                }
                this._stmt = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    public void fetchAll() {
        if (this._allFetched) {
            Log.status(Translate.translate("All_Rows_Fetched"));
            return;
        }
        this._fetchNext(Integer.MAX_VALUE);
    }

    String rawToHex(byte[] ba) {
        int length = ba.length;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int n = ba[i] & 0xFF;
            int firstnibble = n >>> 4;
            sb.append(this.nibbletochar(firstnibble));
            int secondnibble = n & 0xF;
            sb.append(this.nibbletochar(secondnibble));
        }
        return sb.toString();
    }

    char nibbletochar(int nibble) {
        int localChar = 48;
        if (nibble < 10) {
            localChar = (char)(48 + nibble);
        } else if (nibble == 10) {
            localChar = 65;
        } else if (nibble == 11) {
            localChar = 66;
        } else if (nibble == 12) {
            localChar = 67;
        } else if (nibble == 13) {
            localChar = 68;
        } else if (nibble == 14) {
            localChar = 69;
        } else if (nibble == 15) {
            localChar = 70;
        }
        return (char)localChar;
    }

    public int getLoadedCount() {
        int count = 0;
        if (this._rows != null) {
            count = this._rows.size();
        }
        return count;
    }

    @Override
    public int getRowCount() {
        int count = 0;
        if (this._rows != null) {
            count = this._rows.size();
            if (!this._allFetched) {
                count += this._getFetchSize() + 1;
            }
        }
        return count;
    }

    @Override
    public int getColumnCount() {
        int realCount = this._colNames != null ? this._colNames.size() : 0;
        return realCount + 1;
    }

    public String getRawColumnName(int column) {
        return (String)this._colNames.get(column);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return ConnectionArb.getString((int)185);
        }
        if (!this._translatedColNames) {
            return (String)this._colNames.get(column - 1);
        }
        return this._colNames != null ? Translate.translate((String)this._colNames.get(column - 1)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int column) {
        if (this._rows != null) {
            boolean needMore = false;
            Object object = LOCK;
            synchronized (object) {
                if (row >= this._rows.size() && !this._isRunning) {
                    needMore = true;
                }
            }
            if (needMore) {
                this._fetchNext(row - this._rows.size());
            }
            if (row < this._rows.size()) {
                if (column == 0) {
                    return new Integer(row + 1);
                }
                ArrayList rowList = (ArrayList)this._rows.get(row);
                if (rowList != null && rowList.size() > column - 1) {
                    return rowList.get(column - 1);
                }
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Object obj = this.getValueAt(0, column);
        return obj != null ? obj.getClass() : Object.class;
    }

    protected static String _sanitizeOracleSQL(String sql) {
        String sqlStmt = sql.trim();
        String sqlStmtUp = sqlStmt.toUpperCase();
        if (sqlStmt.endsWith(";") && !sqlStmtUp.endsWith("END;")) {
            sqlStmt = sqlStmt.substring(0, sqlStmt.lastIndexOf(";"));
        }
        return sqlStmt;
    }

    private void _createColumnNamesList() throws SQLException {
        ResultSetMetaData rsmd = this._rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        this._colNames = new ArrayList();
        if (this._verticalDisplay) {
            this._types = new int[2];
            this._colSizes = new int[2];
            this._colNames.add(Translate.translate("Name"));
            this._colNames.add(Translate.translate("Value"));
            this._colSizes[0] = 30;
            this._colSizes[1] = 60;
            this._types[0] = 12;
            this._types[1] = 12;
        } else {
            int labelW = 0;
            int colW = 0;
            int size = this._skipCols == null ? numCols : numCols - this._skipCols.size();
            int[] types = new int[numCols];
            int[] colSizes = new int[numCols];
            int j = 0;
            boolean skipCol = false;
            for (int i = 1; i <= numCols; ++i) {
                skipCol = false;
                String name = rsmd.getColumnLabel(i);
                for (int ii = 0; this._skipCols != null && ii < this._skipCols.size(); ++ii) {
                    if (!this._skipCols.get(ii).toUpperCase().equals(rsmd.getColumnName(i).toUpperCase())) continue;
                    skipCol = true;
                }
                if (skipCol) continue;
                this._colNames.add(rsmd.getColumnLabel(i));
                this._label.setText(rsmd.getColumnLabel(i));
                labelW = new Double(this._label.getPreferredSize().getWidth()).intValue();
                colW = rsmd.getColumnDisplaySize(i);
                colSizes[j] = labelW > colW ? labelW : colW;
                types[j] = rsmd.getColumnType(i);
                ++j;
            }
            this._types = types;
            this._colSizes = colSizes;
        }
    }

    public void reorderColumnNamesList(int colMovedFrom, int colMovedTo) throws Exception {
        if (!this._verticalDisplay) {
            if (this._types != null) {
                int fromType = this._types[colMovedFrom];
                this._types[colMovedFrom] = this._types[colMovedTo];
                this._types[colMovedTo] = fromType;
            }
            if (this._colSizes != null) {
                int fromSize = this._colSizes[colMovedFrom];
                this._colSizes[colMovedFrom] = this._colSizes[colMovedTo];
                this._colSizes[colMovedTo] = fromSize;
            }
            if (this._colNames != null) {
                String fromName = (String)this._colNames.get(colMovedFrom);
                this._colNames.set(colMovedFrom, (String)this._colNames.get(colMovedTo));
                this._colNames.set(colMovedTo, fromName);
            }
        }
    }

    protected void _setColWidths() {
        this.getColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _fetchNext(int fetchAtLeast) {
        if (this._allFetched) {
            return;
        }
        final int fetchSize = this._getFetchSize();
        if (this._rows == null) {
            this._rows = new ArrayList();
        }
        final List rows = this._rows;
        final int count = Math.max(fetchSize, fetchAtLeast);
        final ArrayList newRows = new ArrayList(fetchSize);
        this._runner = new ProgressRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws Exception {
                ResultSetTableModel.this.setRunning(true);
                int cnt = count;
                ArrayList<String> row = null;
                Object object = LOCK;
                synchronized (object) {
                    try {
                        if (ResultSetTableModel.this._rs == null) {
                            ResultSetTableModel.this._rs = (OracleResultSet)ResultSetTableModel.this.openResultSet();
                            ResultSetTableModel.this._createColumnNamesList();
                        }
                        while (cnt > 0 && ResultSetTableModel.this._rs.next()) {
                            if (ResultSetTableModel.this._verticalDisplay) {
                                for (int i = 1; i <= ResultSetTableModel.this._rs.getMetaData().getColumnCount(); ++i) {
                                    row = new ArrayList();
                                    row.add(ResultSetTableModel.this._rs.getMetaData().getColumnName(i));
                                    Datum o = ResultSetTableModel.this._rs.getOracleObject(i);
                                    if (o instanceof byte[]) {
                                        row.add(ResultSetTableModel.this.rawToHex((byte[])o));
                                    } else if (ResultSetTableModel.this._rs.getMetaData().getColumnType(i) == 1111 && o instanceof ROWID) {
                                        String urowidStr = ResultSetTableModel.this._rs.getString(i);
                                        byte[] urowidBytes = urowidStr.getBytes();
                                        row.add((String)new ROWID(urowidBytes));
                                    } else if (ResultSetTableModel.this._rs.getMetaData().getColumnType(i) == 91) {
                                        row.add((String)ResultSetTableModel.this._rs.getDATE(i));
                                    } else {
                                        row.add((String)o);
                                    }
                                    newRows.add(row);
                                }
                                continue;
                            }
                            row = new ArrayList<String>();
                            for (int i = 1; i <= ResultSetTableModel.this._rs.getMetaData().getColumnCount(); ++i) {
                                boolean skipCol = false;
                                for (int ii = 0; !skipCol && ResultSetTableModel.this._skipCols != null && ii < ResultSetTableModel.this._skipCols.size(); ++ii) {
                                    String s = ((String)ResultSetTableModel.this._skipCols.get(ii)).toUpperCase();
                                    String s1 = ResultSetTableModel.this._rs.getMetaData().getColumnName(i).toUpperCase();
                                    if (!((String)ResultSetTableModel.this._skipCols.get(ii)).toUpperCase().equals(ResultSetTableModel.this._rs.getMetaData().getColumnName(i).toUpperCase())) continue;
                                    skipCol = true;
                                }
                                if (skipCol) continue;
                                Datum o = ResultSetTableModel.this._rs.getOracleObject(i);
                                if (o instanceof byte[]) {
                                    row.add(ResultSetTableModel.this.rawToHex((byte[])o));
                                    continue;
                                }
                                if (ResultSetTableModel.this._rs.getMetaData().getColumnType(i) == 1111 && o instanceof ROWID) {
                                    String urowidStr = ResultSetTableModel.this._rs.getString(i);
                                    byte[] urowidBytes = urowidStr.getBytes();
                                    row.add((String)new ROWID(urowidBytes));
                                    continue;
                                }
                                if (ResultSetTableModel.this._rs.getMetaData().getColumnType(i) == 91) {
                                    row.add((String)ResultSetTableModel.this._rs.getDATE(i));
                                    continue;
                                }
                                row.add((String)o);
                            }
                            try {
                                String name = ResultSetTableModel.this._rs.getString("SDEV_LINK_NAME");
                                String owner = ResultSetTableModel.this._rs.getString("SDEV_LINK_OWNER");
                                String type = ResultSetTableModel.this._rs.getString("SDEV_LINK_TYPE");
                                if (type.equals("PACKAGE BODY")) {
                                    type = "PACKAGE/Body";
                                }
                                ResultSetTableModel.this._drillUrls.add(CmUtil.getNodeURL((String)ResultSetTableModel.this._connName, null, (String)owner, (String)type, (String)name));
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            Log.status(Translate.translate("Fetched Rows:") + (ResultSetTableModel.this.getLoadedCount() + newRows.size()));
                            newRows.add(row);
                            if (--cnt % 100 != 0) continue;
                            Thread.sleep(1L);
                        }
                    }
                    catch (SQLException sqlEx) {
                        final SQLException sqlException = sqlEx;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                int offset = DBUtil.getInstance().getErrorOffset(ResultSetTableModel.this._conn, ResultSetTableModel.this._sql);
                                ExceptionHandler.handleException(sqlException, ResultSetTableModel.this._sql, offset);
                            }
                        });
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    List l = newRows;
                    int size = l.size();
                    if (size > 0) {
                        rows.addAll(l);
                    }
                    if (size < fetchSize || ResultSetTableModel.this._allFetched) {
                        ResultSetTableModel.this._allFetched = true;
                        Log.status(Translate.translate("All Rows Fetched: ") + ResultSetTableModel.this.getLoadedCount());
                    } else {
                        Log.status(Translate.translate("Fetched Rows: ") + ResultSetTableModel.this.getLoadedCount());
                    }
                }
                ResultSetTableModel.this.setRunning(false);
                ResultSetTableModel.this.fireTableDataChanged();
                return null;
            }
        };
        try {
            this._runner.setTitle("Running Query");
            this._runner.setMessage("Fetching Results");
            this._runner.setCancelable(this._runInThread);
            this._runner.start(this._runInThread);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refresh() {
        this._cleanup();
        this.open();
    }

    protected int _getFetchSize() {
        return 50;
    }

    private String _getDataAsTabDelimitedText() {
        StringBuffer buf = new StringBuffer(this.getRowCount() * this.getColumnCount() * 20);
        try {
            Iterator colNamesIter = this._colNames.iterator();
            boolean firstTime = true;
            while (colNamesIter.hasNext()) {
                if (!firstTime) {
                    buf.append("\t");
                } else {
                    firstTime = false;
                }
                Object o = colNamesIter.next();
                buf.append(o != null ? o.toString() : "");
            }
            buf.append("\n");
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            for (ArrayList curRow : this._rows) {
                Iterator colIter = curRow.iterator();
                boolean firstTime = true;
                while (colIter.hasNext()) {
                    if (!firstTime) {
                        buf.append("\t");
                    } else {
                        firstTime = false;
                    }
                    Object o = colIter.next();
                    buf.append(o != null ? o.toString() : "");
                }
                buf.append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toString();
    }

    private static int getRSFetchSize(int size) {
        return Math.max(Math.min(size, 1000), 1);
    }

    public int[] getColSizes() {
        return this._colSizes;
    }

    public void setColSizes(int[] colSizes) {
        this._colSizes = colSizes;
    }

    public int[] getTypes() {
        return this._types;
    }

    public int getType(int column) {
        return this._types != null && this._types.length > column ? this._types[column] : 0;
    }

    public void setTypes(int[] types) {
        this._types = types;
    }

    public Query getQuery() {
        return this._query;
    }

    public boolean allFetched() {
        return this._allFetched;
    }

    public ResultSet getResultSet() {
        return this._rs;
    }

    public void setResultSet(OracleResultSet rs) {
        this._rs = rs;
    }

    public ResultSet getResultSetCopy() throws SQLException {
        return this.openResultSet();
    }

    public void setRunning(boolean running) {
        this._isRunning = running;
    }

    public boolean getRunning() {
        return this._isRunning;
    }

    public void setThreaded(boolean thread) {
        this._runInThread = thread;
    }

    public boolean getThreaded() {
        return this._runInThread;
    }

    public void setTranslatedColNames(boolean _translatedColNames) {
        this._translatedColNames = _translatedColNames;
    }

    public boolean isTranslatedColNames() {
        return this._translatedColNames;
    }

    public void setConn(Connection _conn) {
        this._conn = _conn;
    }

    public Connection getConn() {
        return this._conn;
    }

    public void setSql(String _sql) {
        this._sql = _sql;
    }

    protected String getSql() {
        return this._sql;
    }

    public void setBindList(ArrayList _bindList) {
        this._bindList = _bindList;
    }

    protected ArrayList getBindList() {
        return this._bindList;
    }

    public void setBindMap(HashMap _bindMap) {
        this._bindMap = _bindMap;
    }

    protected HashMap getBindMap() {
        return this._bindMap;
    }

    public boolean isVerticalDisplay() {
        return this._verticalDisplay;
    }

    public void setVerticalDisplay(boolean display) {
        this._verticalDisplay = display;
    }

    public ArrayList<String> getSkipCols() {
        return this._skipCols;
    }

    public void setSkipCols(ArrayList<String> cols) {
        this._skipCols.clear();
        for (String s : LINK_COLS) {
            this._skipCols.add(s);
        }
        if (cols != null) {
            this._skipCols.addAll(cols);
        }
    }

    public void setWhere(String where) {
        this._whereClause = where;
    }

    public void setOrderBy(String orderBy) {
        this._orderByClause = orderBy;
    }

    public ArrayList<URL> getDrillUrls() {
        return this._drillUrls;
    }

    public String getConnName() {
        return this._connName;
    }

    public void setSchemaName(String schemaName) {
        this._schemaName = schemaName;
    }

    public boolean isExternalTable() {
        return this._isExternalTable;
    }
}

