/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.ZONEIDMAP;

public class OraTIMESTAMPTZFormat
extends OraSimpleDateFormat {
    private static final int SIZE_TIMESTAMPTZ = 13;
    private static final int BYTE_YEAR1 = 0;
    private static final int BYTE_YEAR2 = 1;
    private static final int BYTE_MONTH = 2;
    private static final int BYTE_DAY = 3;
    private static final int BYTE_HOUR = 4;
    private static final int BYTE_MINUTE = 5;
    private static final int BYTE_SECOND = 6;
    private static final int BYTE_NANOS1 = 7;
    private static final int BYTE_NANOS2 = 8;
    private static final int BYTE_NANOS3 = 9;
    private static final int BYTE_NANOS4 = 10;
    private static final int BYTE_TIMEZONE1 = 11;
    private static final int BYTE_TIMEZONE2 = 12;
    private static final int REGIONIDBIT = 128;
    private static final byte OFFSET_HOUR = 20;
    private static final byte OFFSET_MINUTE = 60;
    private static final String[] digit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private TimeZone UTC = TimeZone.getTimeZone("UTC");
    private OraLocaleInfo localeInfo = null;

    public OraTIMESTAMPTZFormat(String pattern, OraLocaleInfo localeInfo) throws ParseException {
        super(pattern, localeInfo);
        this.localeInfo = localeInfo;
        this.applyPattern(pattern);
    }

    public void applyPattern(String pattern) throws ParseException {
        if (this.localeInfo != null) {
            int cnt;
            int i;
            boolean shrink = false;
            String uc = pattern.toUpperCase(Locale.US);
            StringBuffer pat = new StringBuffer(pattern);
            int pos = -1;
            while ((pos = uc.indexOf("X", pos + 1)) >= 0) {
                if (pos > 0 && uc.charAt(pos - 1) == 'F') continue;
                i = -1;
                cnt = 0;
                while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                    ++cnt;
                }
                if (cnt % 2 != 0) continue;
                pat.setCharAt(pos, this.localeInfo.getOraTerritory().getDecimalCharacter().charAt(0));
            }
            pos = -1;
            while ((pos = uc.indexOf("SP", pos + 1)) >= 0) {
                i = -1;
                cnt = 0;
                while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                    ++cnt;
                }
                if (cnt % 2 != 0) continue;
                pat.setCharAt(pos, '\uffff');
                pat.setCharAt(pos + 1, '\uffff');
                shrink = true;
            }
            pos = -1;
            while ((pos = uc.indexOf("TH", pos + 1)) >= 0) {
                if (pos > 2 && uc.substring(pos - 3, pos + 2).equals("MONTH")) continue;
                i = -1;
                cnt = 0;
                while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                    ++cnt;
                }
                if (cnt % 2 == 0) {
                    pat.setCharAt(pos, '\uffff');
                }
                pat.setCharAt(pos + 1, '\uffff');
                shrink = true;
            }
            super.applyPattern(shrink ? pat.toString().replace("\uffff", "") : pat.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraTIMESTAMPTZFormat && super.equals(object);
    }

    public String format(TIMESTAMPTZ date) {
        return this.format(date, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(TIMESTAMPTZ date, StringBuffer toAppendTo, FieldPosition pos) {
        byte[] bytes = date.shareBytes();
        if (bytes.length != 13) {
            throw new IllegalArgumentException("TIMESTAMPTZ to be formatted is of wrong length");
        }
        Calendar cal = (Calendar)this.calendar.clone();
        cal.clear();
        cal.setTimeZone(this.UTC);
        int year = ((bytes[0] & 0xFF) - 100) * 100 + ((bytes[1] & 0xFF) - 100);
        cal.set(1, year);
        cal.set(2, bytes[2] - 1);
        cal.set(5, bytes[3]);
        cal.set(11, bytes[4] - 1);
        cal.set(12, bytes[5] - 1);
        cal.set(13, bytes[6] - 1);
        cal.set(14, 0);
        String tzID = this.getTimeZoneID(bytes);
        int nanos = ((bytes[7] & 0xFF) << 24) + ((bytes[8] & 0xFF) << 16) + ((bytes[9] & 0xFF) << 8) + (bytes[10] & 0xFF);
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(nanos);
        this.calendar.setTimeZone(tzID == null ? this.UTC : TimeZone.getTimeZone(tzID));
        return super.format((Date)ts, toAppendTo, pos);
    }

    public TIMESTAMPTZ parseTIMESTAMPTZ(String text, ParsePosition pos, TimeZone tz) {
        int regID;
        byte[] bytes = new byte[13];
        this.calendar.setTimeZone(TimeZone.getDefault());
        this.calendar.setTimeInMillis(new Date().getTime());
        Date date = super.parse(text, pos);
        long time = date.getTime();
        int nanos = date instanceof Timestamp ? ((Timestamp)date).getNanos() : 0;
        Calendar cal = Calendar.getInstance(this.UTC, Locale.US);
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        bytes[0] = (byte)(year / 100 + 100);
        bytes[1] = (byte)(year % 100 + 100);
        bytes[2] = (byte)(cal.get(2) + 1);
        bytes[3] = (byte)cal.get(5);
        bytes[4] = (byte)(cal.get(11) + 1);
        bytes[5] = (byte)(cal.get(12) + 1);
        bytes[6] = (byte)(cal.get(13) + 1);
        bytes[7] = (byte)(nanos >> 24 & 0xFF);
        bytes[8] = (byte)(nanos >> 16 & 0xFF);
        bytes[9] = (byte)(nanos >> 8 & 0xFF);
        bytes[10] = (byte)(nanos & 0xFF);
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        if ((regID = ZONEIDMAP.getID((String)tz.getID())) > 0) {
            bytes[11] = (byte)((regID & 0x1FC0) >> 6 | 0x80);
            bytes[12] = (byte)((regID & 0x3F) << 2);
        } else {
            int offset = tz.getOffset(time) / 60000;
            bytes[11] = (byte)(offset / 60 + 20);
            bytes[12] = (byte)(offset % 60 + 60);
        }
        return new TIMESTAMPTZ(bytes);
    }

    private String getTimeZoneID(byte[] bytes) {
        boolean negative;
        if (bytes.length < 13) {
            return null;
        }
        if ((bytes[11] & 0x80) != 0) {
            int regID = ((bytes[11] & 0x7F) << 6) + ((bytes[12] & 0xFC) >> 2);
            return ZONEIDMAP.getRegion((int)regID);
        }
        int hours = bytes[11] - 20;
        int minutes = bytes[12] - 60;
        boolean bl = negative = hours < 0 || minutes < 0;
        if (negative) {
            hours = -hours;
            minutes = -minutes;
        }
        return "GMT" + (negative ? "-" : "+") + digit[hours / 10] + digit[hours % 10] + ":" + digit[minutes / 10] + digit[minutes % 10];
    }
}

