/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdevimpl.cm.dt.explorer.BaseElement;

public class PLSQLContextMenu
implements ContextMenuListener {
    private PLSQLController _controller = PLSQLController.getInstance();

    public PLSQLContextMenu() {
        this.initializeListeners();
    }

    private void initializeListeners() {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu menu = editorManager.getContextMenu();
        menu.addContextMenuListener((ContextMenuListener)this);
        NavigatorManager connectionNavigatorManager = NavigatorManager.getConnectionNavigatorManager();
        ContextMenu contextMenu = connectionNavigatorManager.getContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)this);
    }

    public void menuWillShow(ContextMenu popup) {
        Element[] selection;
        for (int i = 0; i < popup.getGUI(true).getComponentCount(); ++i) {
            if (((JMenuItem)popup.getGUI(true).getComponent(i)).getAction() == null || ((IdeAction)((JMenuItem)popup.getGUI(true).getComponent(i)).getAction()).getCommandId() != 57) continue;
            popup.getGUI(true).remove(i);
        }
        Context context = popup.getContext();
        View view = context.getView();
        if (view != null && (selection = view.getSelection()) != null && selection.length > 0) {
            IdeAction action;
            boolean areAllPlSqlNodes = true;
            for (int i = 0; areAllPlSqlNodes && i < selection.length; ++i) {
                Element element = selection[i];
                if (element instanceof PlSqlBaseNode) continue;
                areAllPlSqlNodes = false;
            }
            if (areAllPlSqlNodes && (action = IdeAction.find((int)JCompiler.MAKE_SELECTED_CMD_ID)) != null) {
                this._controller.update(action, context);
                if (this._controller.compileMenu == null) {
                    this._controller.compileMenu = popup.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
                }
                popup.add((Component)this._controller.compileMenu, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                if (this._controller.compileDebugMenu == null) {
                    this._controller.compileDebugMenu = popup.createMenuItem((ToggleAction)this._controller.actionCompileDebug, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
                }
                popup.add((Component)this._controller.compileDebugMenu, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        Element[] els = context.getSelection();
        if (els.length > 0 && els[els.length - 1] instanceof BaseElement) {
            BaseElement el = (BaseElement)els[els.length - 1];
            el.handleDoubleClick();
            return true;
        }
        return false;
    }
}

