/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;

public class CommandRegistry {
    private static HashMap<String, ArrayList<CommandListener>> _listeners = new HashMap();
    private static Component _comp;
    public static final String ACTIVE_OUTPUT_COMPONENT = "ACTIVE_OUTPUT_COMPONENT";

    public static void addListener(CommandListener listener) {
        CommandRegistry.addListener(listener, "0");
    }

    public static void addListener(CommandListener listener, String type) {
        if (_listeners.get(type) == null) {
            _listeners.put(type, new ArrayList());
        }
        _listeners.get(type).add(listener);
    }

    public static boolean fireListeners(Connection conn, ScriptRunnerContext ctx, SQLCommand cmd) {
        boolean ret = false;
        ctx.putProperty(ACTIVE_OUTPUT_COMPONENT, _comp);
        if (_listeners.get("0") != null) {
            for (CommandListener lis : _listeners.get("0")) {
                if (ret) continue;
                ret = lis.handleEvent(conn, ctx, cmd);
            }
        }
        if (_listeners.get(cmd.getStmtClass()) != null) {
            for (CommandListener lis : _listeners.get(cmd.getStmtClass())) {
                if (ret) continue;
                ret = lis.handleEvent(conn, ctx, cmd);
            }
        }
        return ret;
    }

    public static void setOutputComponenet(Component comp) {
        _comp = comp;
    }

    public static void fireBeginListeners(Connection conn, ScriptRunnerContext ctx, SQLCommand cmd) {
        boolean ret = false;
        ctx.putProperty(ACTIVE_OUTPUT_COMPONENT, _comp);
        if (_listeners.get("0") != null) {
            for (CommandListener lis : _listeners.get("0")) {
                lis.beginEvent(conn, ctx, cmd);
            }
        }
        if (_listeners.get(cmd.getStmtClass()) != null) {
            for (CommandListener lis : _listeners.get(cmd.getStmtClass())) {
                lis.beginEvent(conn, ctx, cmd);
            }
        }
    }

    public static void fireEndListeners(Connection conn, ScriptRunnerContext ctx, SQLCommand cmd) {
        boolean ret = false;
        ctx.putProperty(ACTIVE_OUTPUT_COMPONENT, _comp);
        if (_listeners.get("0") != null) {
            for (CommandListener lis : _listeners.get("0")) {
                lis.endEvent(conn, ctx, cmd);
            }
        }
        if (_listeners.get(cmd.getStmtClass()) != null) {
            for (CommandListener lis : _listeners.get(cmd.getStmtClass())) {
                lis.endEvent(conn, ctx, cmd);
            }
        }
    }
}

