/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.sql.SQLException;
import java.sql.SQLWarning;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.util.Debug;

public class PLSQL
extends SQLCommandRunner {
    public static boolean running = false;

    public PLSQL(SQLCommand cmd, BufferedOutputStream out) {
        super(cmd, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Debug.debug("PLSQL:" + this.cmd.getSql());
        String objectType = "anon";
        String objectName = null;
        try {
            while (PLSQL.isRunning()) {
                System.out.println(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString(31)));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            PLSQL.toggleRunning();
            if (this.cmd.getStmtId().equals("27") && this.cmd.getBinds().size() == 0) {
                this.cstmt = this.conn.createStatement();
                this.cstmt.setEscapeProcessing(false);
                this.cstmt.executeUpdate(this.cmd.getSql());
            } else {
                this.stmt = this.conn.prepareCall(this.cmd.getSql());
                this.stmt.setEscapeProcessing(false);
                this.dbUtil.bind(this.stmt, this.cmd.getBinds());
                this.stmt.execute();
            }
            Debug.debug("PLSQL Complete:");
            String[] tokens = this.cmd.getSql().split("[ \n\r]");
            if (tokens[0].toLowerCase().equals("create")) {
                if (tokens[1].toLowerCase().equals("or")) {
                    if (objectType.toLowerCase().equals("package") && tokens[4].toLowerCase().equals("body")) {
                        objectType = tokens[3] + " " + tokens[4];
                        objectName = tokens[5];
                    } else {
                        objectType = tokens[3];
                        objectName = tokens[4];
                    }
                } else if (objectType.toLowerCase().equals("package") && tokens[2].toLowerCase().equals("body")) {
                    objectType = tokens[1] + " " + tokens[2];
                    objectName = tokens[3];
                } else {
                    objectType = tokens[1];
                    objectName = tokens[2];
                }
            }
            if (this.cmd.getStmtId().equals("27") && this.cmd.getBinds().size() == 0) {
                SQLWarning warn = this.cstmt.getWarnings();
            } else {
                SQLWarning warn = this.stmt.getWarnings();
            }
            if (objectType.equals("anon")) {
                this.report(Translate.translate("anonymous_block_completed"));
            } else {
                this.report(objectType + " " + objectName + " Compiled.");
                this.reportErrors(objectName);
            }
        }
        catch (SQLException e) {
            this.doWhenever(true);
            this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), e.getMessage()));
        }
        finally {
            if (this.cstmt != null) {
                try {
                    this.cstmt.close();
                }
                catch (SQLException e) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        PLSQL.toggleRunning();
    }

    public void reportErrors(String objectName) {
    }

    public static synchronized void toggleRunning() {
        running = !running;
    }

    public static boolean isRunning() {
        return running;
    }
}

