/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Debug;
import oracle.ide.Ide;

public abstract class SQLCommandRunner
extends Thread {
    public static final int EXIT = 4;
    public static final int CONTINUE = 0;
    public static final int EXITMASK = 4;
    public static final int ACTIONMASK = 3;
    public static final int ACTIONNONE = 0;
    public static final int ACTIONCOMMIT = 1;
    public static final int ACTIONROLLBACK = 2;
    private ScriptRunnerContext scriptRunnerContext = null;
    protected SQLCommand cmd;
    protected Connection conn;
    protected String connName;
    protected BufferedOutputStream out;
    protected DBUtil dbUtil;
    protected PreparedStatement stmt;
    Statement st;
    Statement cstmt;
    protected Debug debug = new Debug();
    protected String statusLine = null;

    public void interrupt() {
        try {
            if (this.stmt != null) {
                this.stmt.cancel();
            }
            if (this.st != null) {
                this.st.cancel();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.interrupt();
    }

    public SQLCommandRunner(SQLCommand cmd, BufferedOutputStream out) {
        this.cmd = cmd;
        this.out = out;
        this.dbUtil = new DBUtil();
    }

    protected void report(String s) {
        if (this.statusLine != null) {
            Ide.getStatusBar().setText(s);
        }
        if (this.out != null) {
            try {
                this.out.write(s.getBytes("UTF-8"));
                this.out.write(10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void doWhenever(boolean SqlError) {
        int flags = 0;
        flags = SqlError ? this.scriptRunnerContext.getSqlError() : this.scriptRunnerContext.getOsError();
        int threeOptions = flags & 3;
        if (threeOptions == 2) {
            try {
                this.conn.rollback();
                this.report("Rollback");
            }
            catch (SQLException e) {
                this.report(ScriptRunnerDbArb.format(11, "Rollback"));
            }
        } else if (threeOptions == 1) {
            try {
                this.conn.commit();
                this.report("Commit");
            }
            catch (SQLException e) {
                this.report(ScriptRunnerDbArb.format(11, "Commit"));
            }
        }
        if ((flags & 4) == 4) {
            this.scriptRunnerContext.setExited(true);
        }
    }

    public SQLCommand getCmd() {
        return this.cmd;
    }

    public void setCmd(SQLCommand cmd) {
        this.cmd = cmd;
    }

    public String getConnName() {
        return this.connName;
    }

    public void setConnName(String connName) {
        this.connName = connName;
        Connections conns = new Connections();
        this.conn = conns.getConnection(connName);
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public void write(String s) throws IOException {
        this.out.write(s.getBytes());
    }

    public String getStatusLine() {
        return Ide.getStatusBar().getText();
    }

    public void setStatusLine(String statusLine) {
        Ide.getStatusBar().setText(statusLine);
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.scriptRunnerContext;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.scriptRunnerContext = scriptRunnerContext;
    }
}

