/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.scriptrunner.PLSQL;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.jdbc.driver.OracleConnection;

public class SQLPLUS
extends SQLCommandRunner {
    public String iconnectName;
    public String iconnectPassword;
    public String iconnectDB;
    public String retryText;
    private String substitutionString = "";
    private String promptName = "";
    private String directory = null;

    public SQLPLUS(SQLCommand cmd, BufferedOutputStream out) {
        super(cmd, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String sql = this.cmd.getSql().trim();
        if (sql.endsWith(";") && sql.length() > 1) {
            this.cmd.setSql(sql.substring(0, sql.length() - 1));
        }
        if (this.cmd.getStmtId() == "1") {
            this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString(28)));
        } else if (this.cmd.getStmtId() == "37") {
            String localSql = this.cmd.getSql();
            localSql = localSql.trim();
            boolean found = false;
            int i = 0;
            for (i = 0; i < localSql.length(); ++i) {
                if (!Character.isWhitespace(localSql.charAt(i))) continue;
                found = true;
                break;
            }
            if (found) {
                if (localSql.endsWith(";")) {
                    this.cmd.setSql("BEGIN" + localSql.substring(i) + " END;");
                } else {
                    this.cmd.setSql("BEGIN" + localSql.substring(i) + ";" + " END;");
                }
                PLSQL plsql = new PLSQL(this.cmd, this.out);
                plsql.setScriptRunnerContext(this.getScriptRunnerContext());
                plsql.setConn(this.conn);
                plsql.run();
                plsql = null;
            } else {
                this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(17, this.cmd.getSql())));
            }
        } else if (this.cmd.getStmtId() == "59") {
            String localSql = this.cmd.getSql();
            localSql = localSql.trim();
            boolean found = false;
            int i = 0;
            for (i = 0; i < localSql.length(); ++i) {
                if (!Character.isWhitespace(localSql.charAt(i))) continue;
                found = true;
                break;
            }
            if (found) {
                this.report(localSql.substring(i).trim());
            } else {
                this.report("");
            }
        } else if (this.cmd.getStmtId() == "81" || this.cmd.getStmtId() == "8" || this.cmd.getStmtId() == "9") {
            boolean found;
            boolean callFile = false;
            String localSql = "";
            int i = 0;
            if (this.cmd.getStmtId() == "81") {
                localSql = this.cmd.getSql();
                localSql = localSql.trim();
                found = false;
                for (i = 0; i < localSql.length(); ++i) {
                    if (!Character.isWhitespace(localSql.charAt(i))) continue;
                    found = true;
                    break;
                }
                if (found) {
                    localSql = localSql.substring(i).trim();
                    callFile = true;
                }
            } else if (this.cmd.getStmtId() == "8") {
                localSql = this.cmd.getSql();
                if ((localSql = localSql.trim()).length() != 1) {
                    localSql = localSql.substring(1).trim();
                    callFile = true;
                }
            } else if (this.cmd.getStmtId() == "9") {
                localSql = this.cmd.getSql();
                if ((localSql = localSql.trim()).length() != 2) {
                    localSql = localSql.substring(2).trim();
                    callFile = true;
                }
            }
            if (callFile) {
                found = false;
                for (i = 0; i < localSql.length(); ++i) {
                    if (!Character.isWhitespace(localSql.charAt(i))) continue;
                    found = true;
                    break;
                }
                if (found || localSql.length() != 0) {
                    String arguments = "";
                    String inputFile = "";
                    if (found) {
                        inputFile = localSql.substring(0, i);
                        if (localSql.length() > i + 1) {
                            arguments = localSql.substring(i).trim();
                        }
                    } else {
                        inputFile = localSql;
                    }
                    if (inputFile.startsWith("?") && inputFile.length() > 1) {
                        String OH = System.getenv("ORACLE_HOME");
                        if (OH == null) {
                            OH = "?";
                        }
                        if (OH.endsWith(File.separator)) {
                            OH = OH.substring(0, OH.length() - 1);
                        }
                        inputFile = OH + inputFile.substring(1);
                    }
                    int filesep = inputFile.lastIndexOf(File.separator);
                    int dot = inputFile.lastIndexOf(46);
                    if (dot <= filesep) {
                        inputFile = inputFile + ".sql";
                    }
                    if (this.cmd.getStmtId() == "9") {
                        boolean prependDirectory = false;
                        if (System.getProperty("os.name").startsWith("Windows")) {
                            if (inputFile.length() <= 3 || !inputFile.substring(1, 3).equals(":\\")) {
                                prependDirectory = true;
                            }
                        } else if (!inputFile.startsWith(File.separator)) {
                            prependDirectory = true;
                        }
                        if (prependDirectory && this.getDirectory() != null) {
                            inputFile = this.getDirectory().endsWith(File.separator) ? this.getDirectory() + inputFile : this.getDirectory() + File.separator + inputFile;
                        }
                    }
                    FileInputStream fileInputStream = null;
                    try {
                        boolean prependUrl = false;
                        if (System.getProperty("os.name").startsWith("Windows")) {
                            if (inputFile.length() <= 3 || !inputFile.substring(1, 3).equals(":\\")) {
                                prependUrl = true;
                            }
                        } else if (!inputFile.startsWith(File.separator)) {
                            prependUrl = true;
                        }
                        if (prependUrl) {
                            String lastDirName = this.getScriptRunnerContext().getLastDirName();
                            inputFile = lastDirName.endsWith(File.separator) ? lastDirName + inputFile : lastDirName + File.separator + inputFile;
                        }
                        fileInputStream = new FileInputStream(new File(inputFile));
                        if (!arguments.equals("")) {
                            int argnumber = 0;
                            while (!arguments.equals("")) {
                                String[] localStringArray = this.nextWordAndRest(arguments);
                                Map m = this.getScriptRunnerContext().getMap();
                                m.put(Integer.toString(++argnumber), localStringArray[0].trim());
                                arguments = localStringArray[1].trim();
                            }
                        }
                        ScriptRunner runner = new ScriptRunner(fileInputStream);
                        runner.setConn(this.conn);
                        runner.setOut(this.out);
                        boolean localTopLevel = this.getScriptRunnerContext().getTopLevel();
                        this.getScriptRunnerContext().setTopLevel(false);
                        runner.setScriptRunnerContext(this.getScriptRunnerContext());
                        String pathval = new File(inputFile).getCanonicalPath();
                        int ii = pathval.lastIndexOf(File.separator);
                        pathval = pathval.substring(0, ii);
                        runner.setDirectory(pathval);
                        runner.run();
                        this.setScriptRunnerContext(runner.getScriptRunnerContext());
                        this.getScriptRunnerContext().setTopLevel(localTopLevel);
                        this.setConn(runner.getConn());
                    }
                    catch (FileNotFoundException fnfe) {
                        this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(26, inputFile)));
                        this.doWhenever(false);
                    }
                    catch (IOException ioe) {
                        this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(26, inputFile)));
                        this.doWhenever(false);
                    }
                }
            }
        } else if (this.cmd.getStmtId() == "39" || this.cmd.getStmtId() == "61") {
            String localSql = this.cmd.getSql().toUpperCase();
            if (localSql.endsWith(";")) {
                localSql = localSql.substring(0, localSql.length() - 1).trim();
            }
            if (localSql.endsWith("ROLLBACK")) {
                try {
                    this.conn.rollback();
                    this.report("Rollback");
                }
                catch (SQLException e) {
                    this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(11, "Rollback")));
                }
            } else {
                try {
                    this.conn.commit();
                    this.report("Commit");
                }
                catch (SQLException e) {
                    this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(11, "Commit")));
                }
            }
            this.getScriptRunnerContext().setExited(true);
        } else if (this.cmd.getStmtId() == "24") {
            String localSql = this.cmd.getSql().trim();
            boolean found = false;
            boolean callDialog = false;
            String connectName = "";
            String connectPassword = "";
            String connectDB = "";
            int i = 0;
            for (i = 0; i < localSql.length(); ++i) {
                if (!Character.isWhitespace(localSql.charAt(i))) continue;
                found = true;
                break;
            }
            if (found) {
                String[] retVal;
                localSql = localSql.substring(i).trim();
                String remainder = "";
                if (localSql.indexOf("/") != -1) {
                    retVal = this.nextToChar(localSql, '/');
                    connectName = retVal[0].trim();
                    remainder = retVal[1].trim();
                    if (connectName.equals("")) {
                        callDialog = true;
                    }
                    if (remainder.indexOf("@") != -1) {
                        retVal = this.nextToChar(remainder, '@');
                        connectPassword = retVal[0].trim();
                        connectDB = retVal[1].trim();
                    } else {
                        connectPassword = remainder.trim();
                    }
                } else {
                    callDialog = true;
                    if (localSql.indexOf("@") != -1) {
                        retVal = this.nextToChar(localSql, '@');
                        connectName = retVal[0].trim();
                        connectDB = retVal[1].trim();
                    } else {
                        connectName = localSql.trim();
                    }
                }
            } else {
                callDialog = true;
            }
            boolean cancelPressed = false;
            if (callDialog) {
                for (int ii = 0; ii < 3; ++ii) {
                    String[] threeFields = this.get3Fields(connectName, connectPassword, connectDB, ii > 0);
                    if (threeFields == null) {
                        cancelPressed = true;
                        break;
                    }
                    connectName = threeFields[0];
                    connectPassword = threeFields[1];
                    connectDB = threeFields[2];
                    Connection myconn = this.getConnection(connectName, connectPassword, connectDB);
                    if (myconn != null) {
                        try {
                            myconn.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        myconn = null;
                        break;
                    }
                    this.doWhenever(true);
                    if (this.getScriptRunnerContext().getExited()) break;
                    this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString(4)));
                }
            }
            if (!this.getScriptRunnerContext().getExited()) {
                Connection myconn = null;
                if (!cancelPressed) {
                    myconn = this.getConnection(connectName, connectPassword, connectDB);
                }
                if (myconn != null) {
                    if (this.getScriptRunnerContext().getCloseConnection()) {
                        try {
                            this.conn.commit();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        try {
                            this.conn.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.conn = myconn;
                    this.getScriptRunnerContext().setCloseConnection(true);
                    this.report("Connected");
                } else {
                    try {
                        this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString(3)));
                        this.doWhenever(true);
                        this.conn.commit();
                        this.report("Commit");
                    }
                    catch (SQLException e) {
                        this.report(ScriptRunnerDbArb.format(11, "Commit"));
                    }
                    this.getScriptRunnerContext().setExited(true);
                }
            }
        } else if (this.cmd.getStmtId() == "91") {
            String[] stringArray;
            boolean localMatchFound = false;
            boolean localSqlError = false;
            int localFlags = 0;
            String cmdUpper = this.cmd.getSql().toUpperCase();
            if (cmdUpper.length() > 1 && (cmdUpper.endsWith(";") || cmdUpper.endsWith("/"))) {
                cmdUpper = cmdUpper.substring(0, cmdUpper.length() - 1);
            }
            if ((stringArray = this.nextWordAndRest(cmdUpper)) != null && !stringArray[1].equals("")) {
                String nextWord = stringArray[0];
                String theRest = stringArray[1];
                if ((stringArray = this.nextWordAndRest(theRest)) != null && !stringArray[1].equals("")) {
                    nextWord = stringArray[0];
                    theRest = stringArray[1];
                    if (nextWord.equals("SQLERROR") || nextWord.equals("OSERROR")) {
                        localSqlError = nextWord.equals("SQLERROR");
                        stringArray = this.nextWordAndRest(theRest);
                        if (stringArray != null) {
                            nextWord = stringArray[0];
                            theRest = stringArray[1];
                            if (nextWord.equals("CONTINUE") || nextWord.equals("EXIT")) {
                                localFlags = nextWord.equals("EXIT") ? 4 : 0;
                                localFlags = theRest.endsWith(" COMMIT") || theRest.endsWith("\tCOMMIT") || theRest.endsWith("\nCOMMIT") || theRest.endsWith("\rCOMMIT") || theRest.endsWith("/COMMIT") || theRest.equals("COMMIT") ? (localFlags |= 1) : (theRest.endsWith(" ROLLBACK") || theRest.endsWith("\tROLLBACK") || theRest.endsWith("\nROLLBACK") || theRest.endsWith("\rROLLBACK") || theRest.endsWith("/ROLLBACK") || theRest.equals("ROLLBACK") ? (localFlags |= 2) : (localFlags |= 1));
                                localMatchFound = true;
                            }
                        }
                    }
                }
            }
            if (localMatchFound) {
                if (localSqlError) {
                    this.getScriptRunnerContext().setSqlError(localFlags);
                } else {
                    this.getScriptRunnerContext().setOsError(localFlags);
                }
            } else {
                this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), "Usage: WHENEVER OSERROR\n    { EXIT\n      [SUCCESS | FAILURE | n | variable | :BindVariable]\n      [COMMIT | ROLLBACK]\n    | CONTINUE [COMMIT | ROLLBACK | NONE] }\nUsage: WHENEVER SQLERROR\n    { CONTINUE  [ COMMIT | ROLLBACK | NONE ]\n     | EXIT  [ SUCCESS | FAILURE | WARNING | n | <variable> | :<bindvariable> ] \n       [ COMMIT | ROLLBACK ] }"));
            }
        } else if (this.cmd.getStmtId() == "29") {
            String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
            if (stringArray[1].trim().equals("")) {
                Map m = this.getScriptRunnerContext().getMap();
                Set s = m.keySet();
                Map cmdUpper = m;
                synchronized (cmdUpper) {
                    for (String nextKey : s) {
                        String value = (String)m.get(nextKey);
                        this.report("DEFINE " + nextKey + " = \"" + value + "\"");
                    }
                }
            } else {
                String localSubName = "";
                if (stringArray[1].indexOf("=") == -1) {
                    String nextKey;
                    Map m = this.getScriptRunnerContext().getMap();
                    String value = (String)m.get(nextKey = stringArray[1].trim().toUpperCase());
                    if (value == null) {
                        this.report(ScriptRunnerDbArb.format(27, nextKey));
                    } else {
                        this.report("DEFINE " + nextKey + " = \"" + value + "\"");
                    }
                } else {
                    localSubName = stringArray[1].substring(0, stringArray[1].indexOf("=")).trim().toUpperCase();
                    String setValue = "";
                    if (stringArray[1].indexOf("=") != stringArray[1].length() - 1) {
                        setValue = stringArray[1].substring(stringArray[1].indexOf("=") + 1).trim();
                        if (setValue.startsWith("\"") && setValue.endsWith("\"") && setValue.length() > 1) {
                            setValue = setValue.substring(1, setValue.length() - 1);
                        } else if (setValue.startsWith("'") && setValue.endsWith("'") && setValue.length() > 1) {
                            setValue = setValue.substring(1, setValue.length() - 1);
                        }
                        Map map = this.getScriptRunnerContext().getMap();
                        map.put(localSubName, setValue);
                    } else {
                        this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString(6)));
                    }
                }
            }
        } else if (this.cmd.getStmtId() == "87") {
            this.cmd.setSql(this.removeDashNewline(this.cmd.getSql()));
            String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
            if (!stringArray[1].trim().equals("")) {
                String theRest = stringArray[1].trim();
                Map m = this.getScriptRunnerContext().getMap();
                while (!theRest.trim().equals("")) {
                    stringArray = this.nextWordAndRest(theRest);
                    String localVarName = stringArray[0].toUpperCase();
                    theRest = stringArray[1];
                    m.remove(localVarName);
                }
            }
        } else if (this.cmd.getStmtId() == "2") {
            this.cmd.setSql(this.removeDashNewline(this.cmd.getSql()));
            String[] stringArray = this.nextWordAndRest(this.cmd.getSql());
            if (!stringArray[1].trim().equals("")) {
                String localVarName = "";
                String rest = "";
                stringArray = this.nextWordAndRest(stringArray[1]);
                localVarName = stringArray[0].toUpperCase();
                rest = stringArray[1].trim();
                String restUpper = rest.toUpperCase();
                if (restUpper.endsWith("HIDE") && restUpper.length() > 4) {
                    restUpper = restUpper.substring(0, restUpper.length() - 4).trim();
                    rest = rest.substring(0, rest.length() - 4).trim();
                }
                if (restUpper.endsWith("NOPROMPT") && restUpper.length() > 8) {
                    restUpper = restUpper.substring(0, restUpper.length() - 8).trim();
                    rest = rest.substring(0, rest.length() - 8).trim();
                }
                int index = restUpper.indexOf("PROMPT");
                String promptText = "";
                boolean errorOut = false;
                if (index != -1) {
                    stringArray = this.nextWordAndRest(rest = rest.substring(index));
                    if (stringArray[1] == "") {
                        this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString(20)));
                        errorOut = true;
                    } else {
                        promptText = stringArray[1].trim();
                        if (promptText.startsWith("\"") && promptText.endsWith("\"") && promptText.length() > 1) {
                            promptText = promptText.substring(1, promptText.length() - 1);
                        } else if (promptText.startsWith("'") && promptText.endsWith("'") && promptText.length() > 1) {
                            promptText = promptText.substring(1, promptText.length() - 1);
                        }
                    }
                }
                if (!errorOut) {
                    String retVal = this.getPromptedField(promptText);
                    Map m = this.getScriptRunnerContext().getMap();
                    m.put(localVarName, retVal);
                }
            } else {
                this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString(0)));
            }
        } else if (this.cmd.getStmtId() == "73") {
            this.cmd.setSql(this.removeDashNewline(this.cmd.getSql().toLowerCase()));
            String[] retVal = this.nextWordAndRest(this.cmd.getSql());
            if (retVal != null && (retVal = this.nextWordAndRest(retVal[1])) != null) {
                String command = retVal[0];
                if ((retVal[0].equals("def") || retVal[0].equals("defi") || retVal[0].equals("defin") || retVal[0].equals("define") || retVal[0].equals("scan")) && (retVal = this.nextWordAndRest(retVal[1])) != null) {
                    String setChar = retVal[0];
                    boolean quoted = false;
                    String originalSetChar = setChar;
                    if (setChar.startsWith("'") && setChar.endsWith("'") && setChar.length() == 3) {
                        setChar = setChar.substring(1, 2);
                        quoted = true;
                    }
                    if (setChar.startsWith("\"") && setChar.endsWith("\"") && setChar.length() == 3) {
                        setChar = setChar.substring(1, 2);
                        quoted = true;
                    }
                    if (setChar.equals("on")) {
                        if (command.startsWith("def")) {
                            this.getScriptRunnerContext().setSubstitutionOn(true);
                            this.getScriptRunnerContext().setSubstitutionChar('&');
                            return;
                        }
                        this.getScriptRunnerContext().setScanOn(true);
                        return;
                    }
                    if (setChar.equals("off")) {
                        if (command.startsWith("def")) {
                            this.getScriptRunnerContext().setSubstitutionOn(false);
                            return;
                        }
                        this.getScriptRunnerContext().setScanOn(false);
                        return;
                    }
                    if (!(setChar.length() != 1 || Character.isWhitespace(setChar.charAt(0)) || Character.isLetterOrDigit(setChar.charAt(0)) || command.equals("scan") || setChar.charAt(0) == '\"' && !quoted || setChar.charAt(0) == '\'' && !quoted || originalSetChar.equals("\"\"\"") || originalSetChar.equals("'''") || this.getScriptRunnerContext().getScanOn() && this.getScriptRunnerContext().getSubstitutionOn() && setChar.equals(Character.toString(this.getScriptRunnerContext().getSubstitutionChar())))) {
                        this.getScriptRunnerContext().setSubstitutionOn(true);
                        this.getScriptRunnerContext().setSubstitutionChar(setChar.charAt(0));
                        return;
                    }
                    String errorReport = ScriptRunnerDbArb.format(38, "set " + command);
                    this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), errorReport));
                    return;
                }
            }
            this.report(ScriptRunnerDbArb.format(21, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig()));
        } else if (this.cmd.getStmtId() != "22") {
            this.report(ScriptRunnerDbArb.format(21, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig()));
        }
    }

    private String[] get3Fields(String connectName, String connectPassword, String connectDB, boolean retry) {
        String[] retVal = new String[]{connectName, connectPassword, connectDB};
        this.iconnectName = connectName;
        this.iconnectPassword = connectPassword;
        this.iconnectDB = connectDB;
        this.retryText = retry ? ScriptRunnerDbArb.getString(13) : "";
        try {
            Runnable showModalDialog = new Runnable(){

                public void run() {
                    SQLPLUS.this.iconnectName = (String)JOptionPane.showInputDialog(null, ScriptRunnerDbArb.getString(7), SQLPLUS.this.retryText + ScriptRunnerDbArb.getString(18), -1, null, null, SQLPLUS.this.iconnectName);
                    if (SQLPLUS.this.iconnectName != null) {
                        SQLPLUS.this.iconnectPassword = (String)JOptionPane.showInputDialog(null, ScriptRunnerDbArb.getString(8), ScriptRunnerDbArb.getString(19), -1, null, null, SQLPLUS.this.iconnectPassword);
                        if (SQLPLUS.this.iconnectPassword != null) {
                            SQLPLUS.this.iconnectDB = (String)JOptionPane.showInputDialog(null, ScriptRunnerDbArb.getString(25), ScriptRunnerDbArb.getString(5), -1, null, null, SQLPLUS.this.iconnectDB);
                        }
                    }
                }
            };
            SwingUtilities.invokeAndWait(showModalDialog);
        }
        catch (InterruptedException e) {
            return retVal;
        }
        catch (InvocationTargetException e) {
            return retVal;
        }
        if (this.iconnectName == null || this.iconnectPassword == null || this.iconnectDB == null) {
            return null;
        }
        String[] retVal2 = new String[]{this.iconnectName, this.iconnectPassword, this.iconnectDB};
        return retVal2;
    }

    private String getPromptedField(String prompt) {
        String retVal = "";
        this.promptName = prompt;
        try {
            Runnable showModalDialog = new Runnable(){

                public void run() {
                    SQLPLUS.this.substitutionString = (String)JOptionPane.showInputDialog(null, SQLPLUS.this.promptName, ScriptRunnerDbArb.getString(10), -1, null, null, "");
                }
            };
            SwingUtilities.invokeAndWait(showModalDialog);
        }
        catch (InterruptedException e) {
            return "";
        }
        catch (InvocationTargetException e) {
            return "";
        }
        if (this.substitutionString == null) {
            this.substitutionString = "";
        }
        return this.substitutionString;
    }

    private Connection getConnection(String connectName, String connectPassword, String connectDB) {
        Connection myconn;
        if (connectDB == null || connectDB.equals("")) {
            try {
                String url = ((OracleConnection)this.getScriptRunnerContext().getBaseConnection()).getURL();
                myconn = DriverManager.getConnection(url, connectName, connectPassword);
            }
            catch (Exception e) {
                myconn = null;
            }
        } else {
            int match = -1;
            ArrayList<TCPTNSEntry> myTCPEntry = null;
            myTCPEntry = TNSHelper.getTNSEntries();
            if (myTCPEntry != null) {
                for (int i = 0; i < myTCPEntry.size(); ++i) {
                    if (!myTCPEntry.get(i).getName().toUpperCase().equals(connectDB.toUpperCase())) continue;
                    match = i;
                    break;
                }
            }
            if (match == -1) {
                String connectDBnoDot = connectDB;
                int indexdot = connectDBnoDot.indexOf(".");
                if (indexdot != -1) {
                    connectDBnoDot = connectDBnoDot.substring(0, indexdot);
                }
                if (myTCPEntry != null) {
                    for (int i = 0; i < myTCPEntry.size(); ++i) {
                        String theEntry = myTCPEntry.get(i).getName();
                        int indexdot2 = theEntry.indexOf(".");
                        if (indexdot2 != -1) {
                            theEntry = theEntry.substring(0, indexdot2);
                        }
                        if (!theEntry.toUpperCase().equals(connectDBnoDot.toUpperCase())) continue;
                        match = i;
                        break;
                    }
                }
            }
            if (match == -1) {
                return null;
            }
            myconn = null;
            try {
                String url = myTCPEntry.get(match).getJDBCUrl();
                myconn = DriverManager.getConnection(url, connectName, connectPassword);
            }
            catch (SQLException e) {
                myconn = null;
            }
        }
        return myconn;
    }

    private String[] nextWordAndRest(String in) {
        if ((in = in.trim()).length() == 0) {
            return null;
        }
        int i = 0;
        boolean found = false;
        String rest = "";
        String firstWord = "";
        for (i = 0; i < in.length(); ++i) {
            if (!Character.isWhitespace(in.charAt(i))) continue;
            found = true;
            break;
        }
        if (found) {
            rest = in.substring(i).trim();
            firstWord = in.substring(0, i);
        } else {
            firstWord = in;
        }
        String[] stringArray = new String[]{firstWord, rest};
        return stringArray;
    }

    private String[] nextToChar(String in, char sep) {
        String theRest;
        String retVal;
        int position = in.indexOf(sep);
        if (position == -1) {
            retVal = in;
            theRest = "";
        } else {
            theRest = position == in.length() - 1 ? "" : in.substring(position + 1);
            retVal = in.substring(0, position);
        }
        String[] stringArray = new String[]{retVal, theRest};
        return stringArray;
    }

    private String removeDashNewline(String in) {
        int eatWhite;
        StringBuffer op = new StringBuffer();
        int currentlyAt = 0;
        do {
            int match;
            if ((match = in.indexOf("-", currentlyAt)) == -1) {
                op.append(in.substring(currentlyAt));
                break;
            }
            eatWhite = match + 1;
            for (eatWhite = match + 1; eatWhite < in.length() && (in.substring(eatWhite, eatWhite + 1).equals(" ") || in.substring(eatWhite, eatWhite + 1).equals("\t")); ++eatWhite) {
            }
            if (eatWhite < in.length() && (in.substring(eatWhite, eatWhite + 1).equals("\r") || in.substring(eatWhite, eatWhite + 1).equals("\n"))) {
                op.append(in.substring(currentlyAt, match));
                if (++eatWhite >= in.length() || in.substring(eatWhite, eatWhite + 1).equals("\r") || in.substring(eatWhite, eatWhite + 1).equals("\n")) {
                    // empty if block
                }
                currentlyAt = ++eatWhite;
                continue;
            }
            op.append(in.substring(currentlyAt, eatWhite));
            currentlyAt = eatWhite;
        } while (eatWhite != in.length());
        return op.toString();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }
}

