/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.scriptrunner.SQL;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;

public class ScriptParser {
    static final int INITIAL = 0;
    static final int INSINGLELINECOMMENT = 1;
    static final int INMULTILINECOMMENT = 2;
    static final int INALIAS = 3;
    static final int INSINGLEQUOTE = 4;
    static final int INQUOTEDQUOTE = 5;
    private static String[][] startAndEnd = new String[][]{{"", "", "0"}, {"--", "\n", "1"}, {"/*", "*/", "2"}, {"\"", "\"", "3"}, {"'", "'", "4"}, {"q'", "'", "5"}};
    private Connection conn;
    private SQL sql;
    private ArrayList sqlArray = new ArrayList();
    private String rawSQL;
    private BufferedReader reader = null;
    private int readerLineCnt = 0;
    private int startReaderLineCnt = 0;
    private int state = 0;
    private String quoteString = "";

    public ScriptParser(InputStream in) {
        this.scriptParserInit(in, null);
    }

    public ScriptParser(InputStream in, Connection conn) {
        this.scriptParserInit(in, conn);
    }

    public void scriptParserInit(InputStream in, Connection conn) {
        this.conn = conn;
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    public ScriptParser(String s) {
        this.scriptParserInit(s, null);
    }

    public ScriptParser(String s, Connection conn) {
        this.scriptParserInit(s, conn);
    }

    public void scriptParserInit(String s, Connection conn) {
        this.conn = conn;
        this.rawSQL = s;
        this.reader = new BufferedReader(new StringReader(s));
    }

    public void setSQL(SQL sql) {
        this.sql = sql;
    }

    public static void main(String[] args) throws Exception {
        File f = new File(args[0]);
        FileInputStream in = new FileInputStream(f);
        ScriptParser s = new ScriptParser(in);
        s.parse();
    }

    public void parse() {
        StringBuffer currentStatement = null;
        String stmtClass = null;
        String stmtId = null;
        String line = null;
        String runnable = null;
        String resultsType = null;
        String[] tokens = null;
        String leftOver = null;
        int lineCnt = 0;
        this.readerLineCnt = 0;
        this.startReaderLineCnt = 0;
        try {
            while (true) {
                int quotes;
                int i;
                this.state = 0;
                int embeddedSemicolon = 0;
                String quoteString = "";
                this.startReaderLineCnt = this.readerLineCnt;
                lineCnt = 1;
                currentStatement = new StringBuffer();
                if (leftOver != null) {
                    line = leftOver;
                    leftOver = null;
                } else {
                    line = this.getTop();
                    if (line == null) break;
                }
                stmtClass = null;
                stmtId = null;
                runnable = null;
                resultsType = null;
                int ii = SQLStatementTypes.stmts.length;
                for (i = 0; i < ii && stmtClass == null; ++i) {
                    if (line.indexOf(SQLStatementTypes.stmts[i][0]) != 0 && (i != 0 || line != null && !line.equals(""))) continue;
                    stmtClass = SQLStatementTypes.stmts[i][1];
                    stmtId = SQLStatementTypes.stmts[i][2];
                    runnable = SQLStatementTypes.stmts[i][3];
                    if (SQLStatementTypes.stmts[i].length < 5) continue;
                    resultsType = SQLStatementTypes.stmts[i][4];
                }
                if (stmtClass == null) {
                    tokens = line.trim().split("[ \n\r\t]");
                    if (tokens[0] != null && tokens[0].length() > 0 && tokens[0].charAt(tokens[0].length() - 1) == ';') {
                        tokens[0] = tokens[0].replaceAll(";", "");
                    }
                    ii = SQLStatementTypes.tokenStmts.length;
                    for (i = 0; i < ii && stmtClass == null; ++i) {
                        if (!tokens[0].toLowerCase().equals(SQLStatementTypes.tokenStmts[i][0])) continue;
                        stmtClass = SQLStatementTypes.tokenStmts[i][1];
                        stmtId = SQLStatementTypes.tokenStmts[i][2];
                        runnable = SQLStatementTypes.tokenStmts[i][3];
                        if (SQLStatementTypes.tokenStmts[i].length < 5) continue;
                        resultsType = SQLStatementTypes.tokenStmts[i][4];
                    }
                    if (stmtClass == null) {
                        stmtClass = "4";
                        stmtId = "1";
                        runnable = "N";
                    }
                    String strippedLine = this.stripLine(line);
                    if (stmtClass.equals("10")) {
                        if (this.checkCreateType(strippedLine).equals("plsql")) {
                            stmtClass = "3";
                            stmtId = "27";
                            runnable = "Y";
                        } else {
                            stmtClass = "2";
                            stmtId = "26";
                            runnable = "Y";
                        }
                    } else if (stmtClass.equals("9")) {
                        if (this.checkSetType(strippedLine).equals("sql")) {
                            stmtClass = "2";
                            stmtId = "74";
                            runnable = "Y";
                        } else {
                            stmtClass = "4";
                            stmtId = "73";
                            runnable = "N";
                        }
                    }
                }
                boolean searching = true;
                boolean enquote = false;
                if (stmtClass.equals("2")) {
                    while (searching) {
                        if (line == null) {
                            quotes = 0;
                        } else {
                            int[] retval = this.numberOfQuotes(line);
                            quotes = retval[0];
                            embeddedSemicolon = retval[1];
                        }
                        if (quotes % 2 != 0) {
                            boolean bl = enquote = !enquote;
                        }
                        if (line != null && !enquote) {
                            if (line.trim().endsWith(";") && embeddedSemicolon == 0) {
                                searching = false;
                                line = line.substring(0, line.lastIndexOf(";"));
                            } else if (line.trim().endsWith("\n/") || line.trim().equals("/")) {
                                searching = false;
                                line = line.substring(0, line.lastIndexOf("/"));
                            } else if (line.trim().equals(".")) {
                                searching = false;
                                line = line.substring(0, line.lastIndexOf("."));
                            }
                            currentStatement.append(line + "\n");
                            if (searching) {
                                line = this.reader.readLine();
                                ++lineCnt;
                                ++this.readerLineCnt;
                            }
                        } else {
                            currentStatement.append(line + "\n");
                            line = this.reader.readLine();
                            ++lineCnt;
                            ++this.readerLineCnt;
                        }
                        if (line != null) continue;
                        searching = false;
                    }
                } else if (stmtClass.equals("3")) {
                    while (searching) {
                        if (line == null) {
                            quotes = 0;
                        } else {
                            int[] retval = this.numberOfQuotes(line);
                            quotes = retval[0];
                            embeddedSemicolon = retval[1];
                        }
                        if (line != null && (quotes == 0 || quotes % 2 == 1)) {
                            if (line.trim().endsWith("\n/") || line.trim().equals("/")) {
                                searching = false;
                                line = line.substring(0, line.lastIndexOf("/"));
                            } else if (line.trim().equals(".")) {
                                searching = false;
                                line = line.substring(0, line.lastIndexOf("."));
                            }
                        }
                        currentStatement.append(line + "\n");
                        if (searching) {
                            line = this.reader.readLine();
                            ++lineCnt;
                            ++this.readerLineCnt;
                        }
                        if (line != null) continue;
                        searching = false;
                    }
                } else if (stmtClass.equals("4")) {
                    while (searching) {
                        if (line.trim().endsWith("-")) {
                            searching = true;
                            currentStatement.append(line + "\n");
                            line = this.reader.readLine();
                            ++lineCnt;
                            ++this.readerLineCnt;
                            if (line != null) continue;
                            searching = false;
                            continue;
                        }
                        searching = false;
                        currentStatement.append(line + "\n");
                    }
                } else if (stmtClass.equals("5")) {
                    currentStatement.append(line + "\n");
                } else if (!stmtClass.equals("6") && !stmtClass.equals("8")) {
                    if (stmtClass.equals("1")) {
                        System.err.println(ScriptRunnerDbArb.format(30, line));
                    } else if (stmtClass.equals("7")) {
                        while (searching) {
                            int nearEndOfComment = line.indexOf("*/");
                            if (nearEndOfComment >= 0) {
                                searching = false;
                                if (nearEndOfComment + 2 == line.length()) {
                                    leftOver = "";
                                } else {
                                    leftOver = line.substring(nearEndOfComment + 2);
                                    line = line.substring(0, nearEndOfComment + 2);
                                }
                                currentStatement.append(line + "\n");
                                continue;
                            }
                            currentStatement.append(line + "\n");
                            line = this.reader.readLine();
                            ++lineCnt;
                            ++this.readerLineCnt;
                            if (line != null) continue;
                            searching = false;
                            currentStatement.append("*/");
                        }
                    }
                }
                if (currentStatement.length() <= 0) continue;
                while (currentStatement.charAt(currentStatement.length() - 1) == '\n' || currentStatement.charAt(currentStatement.length() - 1) == '\r') {
                    currentStatement.deleteCharAt(currentStatement.length() - 1);
                }
                SQLCommand cmd = new SQLCommand(currentStatement.toString());
                cmd.setRunnable(runnable);
                cmd.setStmtClass(stmtClass);
                cmd.setStmtId(stmtId);
                cmd.setLines(lineCnt);
                cmd.setResultsType(resultsType);
                cmd.startLine = this.startReaderLineCnt;
                cmd.endLine = this.readerLineCnt - 1;
                if (cmd.getStmtClass().equals("4") && cmd.getStmtId().equals("32")) {
                    this.parseDescribe(cmd);
                }
                this.sqlArray.add(cmd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String stripLine(String line) {
        String comp = line;
        comp = comp.replaceAll(" ", "");
        comp = comp.replaceAll("\n", "");
        comp = comp.replaceAll("\r", "");
        comp = comp.replaceAll("\t", "");
        comp = comp.toLowerCase();
        return comp;
    }

    public String checkCreateType(String line) {
        String ret = "sql";
        int ii = SQLStatementTypes.sqlCreate.length;
        for (int i = 0; i < ii; ++i) {
            if (line.indexOf(SQLStatementTypes.sqlCreate[i]) != 0) continue;
            ret = "plsql";
        }
        return ret;
    }

    public String checkSetType(String line) {
        String ret = "sqlplus";
        int ii = SQLStatementTypes.setCmds.length;
        for (int i = 0; i < ii && !ret.equals("sql"); ++i) {
            if (line.indexOf(SQLStatementTypes.setCmds[i]) != 0) continue;
            ret = "sql";
        }
        return ret;
    }

    private String getTop() {
        String top = null;
        try {
            top = this.reader.readLine();
            ++this.readerLineCnt;
            if (top == null) {
                return null;
            }
            while (top.trim().equals("")) {
                top = this.reader.readLine();
                ++this.readerLineCnt;
                if (top != null) continue;
                return null;
            }
            this.startReaderLineCnt = this.readerLineCnt - 1;
            if (top.trim().toLowerCase().startsWith("create") || top.trim().toLowerCase().startsWith("drop") || top.trim().toLowerCase().startsWith("alter")) {
                String currLine = "";
                while (top.indexOf(";") == -1 && top.indexOf("/") == -1 && top.toLowerCase().indexOf("begin") == -1 && currLine != null) {
                    currLine = this.reader.readLine();
                    if (currLine != null) {
                        top = top + "\n" + currLine;
                    }
                    ++this.readerLineCnt;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return top;
    }

    public String getRawSQL() {
        return this.rawSQL;
    }

    public void setRawSQL(String rawSQL) {
        this.rawSQL = rawSQL;
    }

    public SQLCommand[] getSqlStatements() {
        return this.sqlArray.toArray(new SQLCommand[this.sqlArray.size()]);
    }

    public void parseDescribe(SQLCommand cmd) {
        StringTokenizer st = new StringTokenizer(cmd.getSql(), " .");
        String[] res = new String[2];
        String command = st.nextToken();
        res[0] = cmd.getSql().indexOf(".") > -1 ? st.nextToken().replaceAll("\"", "").toUpperCase() : "";
        try {
            res[1] = st.nextToken();
        }
        catch (NoSuchElementException nsee) {
            res[1] = "unknown_table";
        }
        res[1] = res[1].replaceAll("\n", "");
        res[1] = res[1].replaceAll("\r", "");
        res[1] = res[1].replaceAll(";", "");
        String objType = this.getObjType(res[1], res[0]);
        if (objType.equals("SYNONYM")) {
            String[] details = this.getBaseSynonymObj(res[1], res[0]);
            objType = details[2];
            res[0] = details[0];
            res[1] = details[1];
        }
        String displayName = ScriptRunnerDbArb.getString(32);
        String displayNull = ScriptRunnerDbArb.getString(33);
        String displayType = ScriptRunnerDbArb.getString(34);
        String displayArgumentName = ScriptRunnerDbArb.getString(35);
        String displayDefault = ScriptRunnerDbArb.getString(36);
        res[1] = res[1].indexOf("\"") > -1 ? res[1].replaceAll("\"", "") : res[1].replaceAll("\"", "").toUpperCase();
        if (objType.equals("TABLE") || objType.equals("VIEW") || objType.endsWith("MATERIALIZED VIEW")) {
            if (!res[0].equals("")) {
                cmd.setSql("select t.column_name \"" + displayName + "\", \n" + "decode(t.nullable,'Y',null,'NOT NULL') \"" + displayNull + "\", \n" + "UPPER(t.data_type)||  \n" + "case when (   t.data_type='VARCHAR' \n" + "           OR t.data_type = 'VARCHAR2' \n" + "           OR t.data_type ='RAW' \n" + "           OR t.data_type='CHAR') AND (\n" + "           t.data_length <> 0 AND \n" + "           nvl(t.data_length,-1) <> -1)   " + "     then \n" + "           case when(t.char_used ='C' and 'BYTE' =(select value from nls_session_parameters where PARAMETER='NLS_LENGTH_SEMANTICS')) then '(' || t.char_length || ' CHAR)'\n" + "                when(t.char_used ='B' and 'CHAR' =(select value from nls_session_parameters where PARAMETER='NLS_LENGTH_SEMANTICS')) then '(' || t.data_length || ' BYTE)'\n" + "                else '(' || t.char_length || ')' \n" + "           end    \n" + "     when (t.data_type='NVARCHAR2' OR t.data_type='NCHAR') then  \n" + "     '(' || t.data_length/2 || ')'   \n" + "     when (t.data_type like 'TIMESTAMP%' OR t.data_type like 'INTERVAL DAY%' OR t.data_type like 'INTERVAL YEAR%' OR t.data_type = 'DATE' OR(t.data_type = 'NUMBER' AND (t.data_precision = 0 OR nvl(t.data_precision,-1) = -1))) then\n" + "      '' \n" + "     when (t.data_scale  = 0 OR nvl(t.data_scale,-1) = -1) then\n" + "      '('|| t.data_precision ||')'\n" + "     else\n" + "        '('|| t.data_precision ||',' ||t.data_scale ||')'    \n" + "end \"" + displayType + "\"   \n" + "from sys.all_tab_columns t, sys.all_col_comments c where t.column_name = c.column_name and c.owner = t.owner and c.table_name = t.table_name and t.owner = :1 and t.table_name = :2 order by t.column_id\n");
                cmd.addBind(res[0]);
                cmd.addBind(res[1]);
            } else {
                cmd.setSql("select t.column_name \"" + displayName + "\", \n" + "decode(t.nullable,'Y',null,'NOT NULL') \"" + displayNull + "\", \n" + "UPPER(t.data_type)||  \n" + "case when (   t.data_type='VARCHAR' \n" + "           OR t.data_type = 'VARCHAR2' \n" + "           OR t.data_type ='RAW' \n" + "           OR t.data_type='CHAR') AND (\n" + "           t.data_length <> 0 AND \n" + "           nvl(t.data_length,-1) <> -1)  " + "     then \n" + "           case when(t.char_used ='C' and 'BYTE' =(select value from nls_session_parameters where PARAMETER='NLS_LENGTH_SEMANTICS')) then '(' || t.char_length || ' CHAR)'\n" + "                when(t.char_used ='B' and 'CHAR' =(select value from nls_session_parameters where PARAMETER='NLS_LENGTH_SEMANTICS')) then '(' || t.data_length || ' BYTE)'\n" + "                else '(' || t.char_length || ')' \n" + "           end    \n" + "     when (t.data_type='NVARCHAR2' OR t.data_type='NCHAR') then  \n" + "     '(' || t.data_length/2 || ')'   \n" + "     when (t.data_type like 'TIMESTAMP%' OR t.data_type like 'INTERVAL DAY%' OR t.data_type like 'INTERVAL YEAR%' OR t.data_type = 'DATE' OR(t.data_type = 'NUMBER' AND (t.data_precision = 0 OR nvl(t.data_precision,-1) = -1))) then\n" + "      '' \n" + "     when (t.data_scale  = 0 OR nvl(t.data_scale,-1) = -1) then\n" + "      '('|| t.data_precision ||')'\n" + "     else\n" + "        '('|| t.data_precision ||',' ||t.data_scale ||')'    \n" + "end \"" + displayType + "\"   \n" + "from sys.all_tab_columns t, sys.all_col_comments c where t.column_name = c.column_name and c.owner = t.owner and c.table_name = t.table_name and  UPPER(t.owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')) and t.table_name = :1 order by t.column_id\n");
                cmd.addBind(res[1]);
            }
        } else if (objType.startsWith("PACKAGE")) {
            if (!res[0].equals("")) {
                if (this.isDefaultDetailsAvailable()) {
                    cmd.setSql("select decode(t.overload,null,t.object_name,t.object_name||' ('||to_char(t.overload)||')')||decode(t.position,0,' (FUNCTION)','') procedure,\n nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + displayArgumentName + "\",\n" + " decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + displayType + "\" ,\n" + " t.in_out \"IN/OUT\",\n" + " decode(d.default#,1,'DEFAULT','') \"" + displayDefault + "\"\n" + " from all_arguments t ,sys.argument$ d\n" + " where owner= :1 \n" + " and package_name= :2 \n" + " and data_level < 1 \n" + " and d.obj#=t.object_id \n" + " and d.procedure$ = t.object_name\n" + " and d.position# || d.argument = t.position || t.argument_name\n" + " order by t.object_name,t.overload,t.position");
                } else {
                    cmd.setSql("select decode(t.overload,null,t.object_name,t.object_name||' ('||to_char(t.overload)||')')||decode(t.position,0,' (FUNCTION)','') procedure,\n nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + displayArgumentName + "\",\n" + " decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + displayType + "\" ,\n" + " t.in_out \"IN/OUT\",\n" + " 'unknown' \"" + displayDefault + "\"\n" + " from all_arguments t" + " where owner= :1 \n" + " and package_name= :2 \n" + " and data_level < 1 \n" + " order by t.object_name,t.overload,t.position");
                }
                cmd.addBind(res[0]);
                cmd.addBind(res[1]);
            } else {
                if (this.isDefaultDetailsAvailable()) {
                    cmd.setSql("select decode(t.overload,null,t.object_name,t.object_name||' ('||to_char(t.overload)||')')||decode(t.position,0,' (FUNCTION)','') procedure,\n nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"Argument Name\",\n decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + displayType + "\" ,\n" + " t.in_out \"IN/OUT\",\n" + " decode(d.default#,1,'DEFAULT','') \"" + displayDefault + "\"\n" + " from all_arguments t ,sys.argument$ d\n" + " where UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))\n" + " and package_name= :1 \n" + " and d.obj#=t.object_id \n" + " and d.procedure$ = t.object_name\n" + " and d.position# || d.argument = t.position || t.argument_name\n" + " and data_level < 1 \n" + " order by t.object_name,t.overload,t.position");
                } else {
                    cmd.setSql("select decode(t.overload,null,t.object_name,t.object_name||' ('||to_char(t.overload)||')')||decode(t.position,0,' (FUNCTION)','') procedure,\n nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + displayArgumentName + "\",\n" + " decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + displayType + "\" ,\n" + " t.in_out \"IN/OUT\",\n" + " 'unknown' \"" + displayDefault + "\"\n" + " from all_arguments t " + " where UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))\n" + " and package_name= :1 \n" + " and data_level < 1 \n" + " order by t.object_name,t.overload,t.position");
                }
                cmd.addBind(res[1]);
            }
        } else if (objType.equals("FUNCTION") || objType.equals("PROCEDURE")) {
            if (!res[0].equals("")) {
                if (this.isDefaultDetailsAvailable()) {
                    cmd.setSql("  select \n  nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + displayArgumentName + "\",\n" + "  decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + displayType + "\" ,\n" + "  t.in_out \"In/Out\", \n" + "  decode(d.default#, NULL,NULL,'DEFAULT') \"" + displayDefault + "\" \n" + "  from all_arguments t,\n" + "  sys.argument$ d\n" + "  where owner= :1 \n" + "  and object_name= :2 \n" + "  and t.object_id = d.obj#\n" + "  and t.POSITION = d.POSITION#\n" + "  order by object_name,overload,position");
                } else {
                    cmd.setSql("  select \n  nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + displayArgumentName + "\",\n" + "  decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + displayType + "\" ,\n" + "  t.in_out \"In/Out\", \n" + "  'unknown' \"" + displayDefault + "\" \n" + "  from all_arguments t\n" + "  where owner= :1 \n" + "  and object_name= :2 \n" + "  order by object_name,overload,position");
                }
                cmd.addBind(res[0]);
                cmd.addBind(res[1]);
            } else {
                if (this.isDefaultDetailsAvailable()) {
                    cmd.setSql("  select \n  nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + displayArgumentName + "\",\n" + "  decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + displayType + "\" ,\n" + "  t.in_out \"In/Out\", \n" + "  decode(d.default#, NULL,NULL,'DEFAULT') \"" + displayDefault + "\" \n" + "  from all_arguments t,\n" + "  sys.argument$ d\n" + "  where UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))\n" + "  and object_name= :1 \n" + "  and t.object_id = d.obj#\n" + "  and t.POSITION = d.POSITION#\n" + "  order by object_name,overload,position");
                } else {
                    cmd.setSql("  select \n  nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + displayArgumentName + "\",\n" + "  decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + displayType + "\" ,\n" + "  t.in_out \"In/Out\", \n" + "  'unknown' \"" + displayDefault + "\" \n" + "  from all_arguments t\n" + "  where UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))\n" + "  and object_name= :1 \n" + "  order by object_name,overload,position");
                }
                cmd.addBind(res[1]);
            }
        } else if (objType.startsWith("TYPE")) {
            String sqlStr = " select  replace(text,chr(10)) \"user type definition\" from all_source ";
            if (!res[0].equals("")) {
                sqlStr = sqlStr + " where owner = :3 and name = :4 ";
                cmd.setSql(sqlStr);
                cmd.addBind(res[0]);
                cmd.addBind(res[1]);
            } else {
                sqlStr = sqlStr + " where name = :4 ";
                cmd.setSql(sqlStr);
                cmd.addBind(res[1]);
            }
        } else {
            cmd.setSql("select '" + ScriptRunnerDbArb.format(1, res[1]) + "' \"ERROR:\"  from dual");
        }
        cmd.setStmtClass("2");
        cmd.setResultsType("1");
    }

    private String[] getBaseSynonymObj(String synonymName, String synonymOwner) {
        String sql = "select table_owner ,table_name from all_synonyms where  synonym_name = '";
        String strippedSynonymName = synonymName.replaceAll("\"", "");
        sql = synonymName.startsWith("\"") ? sql + strippedSynonymName + "'" : sql + strippedSynonymName.toUpperCase() + "'";
        sql = !synonymOwner.trim().equals("") ? sql + " and owner ='" + synonymOwner + "'" : sql + " and ( owner = 'PUBLIC'  OR UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')) )";
        String result = this.executeQuery(sql);
        String table_owner = "";
        String table_name = "";
        String obj_type = "";
        if (result == null || result.trim().equals("")) {
            result = "";
        } else {
            table_owner = result.substring(0, result.indexOf(":"));
            table_name = result.substring(result.indexOf(":") + 1);
            table_name = table_name.substring(0, table_name.length() - 1);
            obj_type = this.getObjType(table_name, table_owner);
        }
        String[] res = new String[]{table_owner, table_name, obj_type};
        return res;
    }

    private boolean isDefaultDetailsAvailable() {
        String sql = "select 'available' from sys.argument$ where rownum <=1";
        String result = this.executeQuery(sql);
        return result.equals("available");
    }

    private boolean isSystemTable(String tablename) {
        String strippedTablename = tablename.replaceAll("\"", "");
        String sql = "";
        sql = tablename.startsWith("\"") ? "select table_name from dictionary where table_name = '" + strippedTablename + "'" : "select table_name from dictionary where table_name = '" + strippedTablename.toUpperCase() + "'";
        String result = this.executeQuery(sql);
        return result != null && !result.trim().equals("");
    }

    private String getObjType(String objName, String ownerName) {
        String sql = " select object_type  from all_objects  where object_name ='";
        String strippedObjName = objName.replaceAll("\"", "");
        sql = objName.startsWith("\"") ? sql + strippedObjName + "'" : sql + strippedObjName.toUpperCase() + "'";
        String query = "";
        query = ownerName.equals("") ? sql + " and UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))" : sql + " and owner= '" + ownerName + "'";
        String result = this.executeQuery(query);
        if (result == null) {
            result = "";
        }
        if (ownerName.equals("") && result.trim().equals("")) {
            query = sql + "and OBJECT_TYPE ='SYNONYM'";
            result = this.executeQuery(query);
            if (result == null) {
                result = "";
            } else if (!result.trim().equals("")) {
                result = "SYNONYM";
            }
        }
        if (result.indexOf("TABLE PARTITION") != -1) {
            result = "TABLE";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeQuery(String sql) {
        String result = "";
        Statement stmt = null;
        ResultSet rs = null;
        if (this.conn == null) {
            return null;
        }
        try {
            int i;
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(sql);
            rs.next();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numCols = rsmd.getColumnCount();
            if (numCols == 1) {
                result = result + rs.getString(1);
            } else {
                for (i = 1; i <= numCols; ++i) {
                    result = result + rs.getString(i) + ":";
                }
            }
            while (rs.next()) {
                result = result + "\n";
                if (numCols == 1) {
                    result = result + rs.getString(1);
                    continue;
                }
                for (i = 1; i <= numCols; ++i) {
                    result = result + rs.getString(i) + ":";
                }
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
        return result;
    }

    private int[] numberOfQuotes(String inString) {
        int noOfQuotes = 0;
        int position = 0;
        int embeddedSemicolon = 0;
        while (true) {
            int newPos;
            if (this.state == 0) {
                int nextMatch;
                int lowestMatch = 100000;
                int matchVal = 0;
                int i = 1;
                for (i = 1; i < startAndEnd.length; ++i) {
                    nextMatch = inString.indexOf(startAndEnd[i][0], position);
                    if (nextMatch == -1 || nextMatch >= lowestMatch || i == 5 && nextMatch + 2 == inString.length()) continue;
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                i = 5;
                nextMatch = inString.indexOf("Q'", position);
                if (nextMatch != -1 && nextMatch < lowestMatch && (i != 5 || nextMatch + 2 != inString.length())) {
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                if (matchVal == 5) {
                    this.quoteString = inString.substring(lowestMatch + 2, lowestMatch + 3);
                    this.quoteString = this.getEndQuoteString(this.quoteString);
                }
                if (matchVal == 5) {
                    ++noOfQuotes;
                    this.state = 5;
                    position = lowestMatch + 3;
                    continue;
                }
                if (matchVal == 4) {
                    ++noOfQuotes;
                    this.state = 4;
                    position = lowestMatch + 1;
                    continue;
                }
                if (matchVal == 0) {
                    int[] retval = new int[]{noOfQuotes, 0};
                    return retval;
                }
                this.state = matchVal;
                position = lowestMatch + startAndEnd[matchVal][0].length();
                continue;
            }
            String endString = startAndEnd[this.state][1];
            if (this.state == 5) {
                endString = this.quoteString + endString;
            }
            if ((newPos = inString.indexOf(endString, position)) == -1) {
                if (this.state == 1) {
                    this.state = 0;
                    if (inString.trim().endsWith(";")) {
                        embeddedSemicolon = 1;
                    }
                } else if (this.state != 0 && inString.trim().endsWith(";")) {
                    embeddedSemicolon = 1;
                }
                int[] retval = new int[]{noOfQuotes, embeddedSemicolon};
                return retval;
            }
            position = newPos + endString.length();
            if (this.state == 4 || this.state == 5) {
                ++noOfQuotes;
                this.quoteString = "";
            }
            this.state = 0;
        }
    }

    boolean isQuoteStringValid(String quoteString) {
        boolean retVal = true;
        if (quoteString.equals("\t") || quoteString.equals("\r") || quoteString.equals("\n") || quoteString.equals(" ")) {
            retVal = false;
        }
        return retVal;
    }

    String getEndQuoteString(String inQuote) {
        String retVal = inQuote;
        if (retVal.equals("[")) {
            retVal = "]";
        } else if (retVal.equals("{")) {
            retVal = "}";
        } else if (retVal.equals("<")) {
            retVal = ">";
        } else if (retVal.equals("(")) {
            retVal = ")";
        }
        return retVal;
    }
}

