/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.scriptrunner.CommandRegistry;
import oracle.dbtools.raptor.scriptrunner.PLSQL;
import oracle.dbtools.raptor.scriptrunner.SQL;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLPLUS;
import oracle.dbtools.raptor.scriptrunner.ScriptParser;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.ide.Ide;
import oracle.jdbc.driver.OracleDriver;

public class ScriptRunner
extends Thread {
    static final int DEFAULT = 0;
    static final int ACCEPTINGSUBSTITUTION = 1;
    private Connection conn;
    private String directory = null;
    private ScriptRunnerContext scriptRunnerContext = null;
    private boolean printComments = false;
    private BufferedOutputStream out = null;
    private final String ENCODING = "UTF-8";
    private String substitutionString = "";
    private String variableName = "";
    private SQL sql;
    private PLSQL plsql;
    private boolean interrupted = false;
    public boolean finished = false;
    private SQLCommand[] cmds;

    public void interrupt() {
        this.interrupted = true;
        if (this.sql != null) {
            this.sql.interrupt();
        }
        super.interrupt();
    }

    public ScriptRunner() {
    }

    public void setStmt(String s) {
        ScriptParser parser = new ScriptParser(s, this.conn);
        parser.parse();
        this.cmds = parser.getSqlStatements();
    }

    public void setStmt(InputStream in) {
        ScriptParser parser = new ScriptParser(in, this.conn);
        parser.parse();
        this.cmds = parser.getSqlStatements();
    }

    public ScriptRunner(String s) {
        ScriptParser parser = new ScriptParser(s);
        parser.parse();
        this.cmds = parser.getSqlStatements();
    }

    public ScriptRunner(InputStream in) {
        ScriptParser parser = new ScriptParser(in);
        parser.parse();
        this.cmds = parser.getSqlStatements();
    }

    public void run(SQLCommand cmd) throws IOException {
        boolean isError;
        if (this.scriptRunnerContext.getSubstitutionOn() && this.scriptRunnerContext.getScanOn() && (isError = this.replaceSubstitution(cmd))) {
            return;
        }
        CommandRegistry.fireBeginListeners(this.conn, this.getScriptRunnerContext(), cmd);
        if (cmd.getStmtClass().equals("8")) {
            if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
                this.printComment(cmd.getSql());
            }
        } else if (cmd.getStmtClass().equals("2")) {
            if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
                this.sql = new SQL(cmd, this.out);
                this.sql.setScriptRunnerContext(this.getScriptRunnerContext());
                this.sql.setConn(this.conn);
                if (cmd.getStmtId().equals("32")) {
                    byte[] bytes2 = (cmd.getSQLOrig() + "\n").getBytes("UTF-8");
                    this.out.write(bytes2);
                }
                this.sql.run();
                this.setScriptRunnerContext(this.sql.getScriptRunnerContext());
                this.sql = null;
            }
        } else if (cmd.getStmtClass().equals("3")) {
            if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
                PLSQL plsql = new PLSQL(cmd, this.out);
                plsql.setScriptRunnerContext(this.getScriptRunnerContext());
                plsql.setConn(this.conn);
                plsql.run();
                this.setScriptRunnerContext(plsql.getScriptRunnerContext());
                plsql = null;
            }
        } else if (cmd.getStmtClass().equals("4")) {
            if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
                SQLPLUS sqlplus = new SQLPLUS(cmd, this.out);
                sqlplus.setScriptRunnerContext(this.getScriptRunnerContext());
                sqlplus.setConn(this.conn);
                sqlplus.setDirectory(this.directory);
                sqlplus.run();
                this.conn = sqlplus.getConn();
                this.setScriptRunnerContext(sqlplus.getScriptRunnerContext());
                Object var2_5 = null;
            }
        } else if (cmd.getStmtClass().equals("5")) {
            if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
                this.printComment(cmd.getSql());
            }
        } else if (cmd.getStmtClass().equals("6")) {
            if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
                this.printComment(cmd.getSql());
            }
        } else if (cmd.getStmtClass().equals("7")) {
            if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
                this.printComment(cmd.getSql());
            }
        } else if (cmd.getStmtClass().equals("1")) {
            if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
                this.unknown(ScriptRunnerDbArb.getString(28), cmd);
            }
        } else if (cmd.getStmtClass().equals("9")) {
            if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
                this.unknown("set", cmd);
            }
        } else if (cmd.getStmtClass().equals("10")) {
            if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
                this.unknown("create", cmd);
            }
        } else if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), cmd)) {
            this.unknown("class", cmd);
        }
        CommandRegistry.fireEndListeners(this.conn, this.getScriptRunnerContext(), cmd);
    }

    public void run() {
        block19: {
            if (this.scriptRunnerContext.getTopLevel()) {
                this.scriptRunnerContext.setBaseConnection(this.conn);
            }
            if (this.out == null) {
                this.out = new BufferedOutputStream(System.out);
            }
            int ii = this.cmds.length;
            for (int i = 0; i < ii; ++i) {
                try {
                    if (this.interrupted) {
                        this.interrupted = false;
                        break;
                    }
                    this.run(this.cmds[i]);
                    String s = DBUtil.getInstance().getDBMSOUTPUT(this.conn);
                    this.out.write(s.getBytes());
                    if (this.scriptRunnerContext.getExited()) {
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        this.out.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.finished = true;
            }
            if (this.scriptRunnerContext.getTopLevel() && this.scriptRunnerContext.getCloseConnection()) {
                try {
                    this.conn.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (this.scriptRunnerContext.getTopLevel()) {
                if (this.scriptRunnerContext.getExited()) {
                    this.scriptRunnerContext.reInitOnExit();
                } else {
                    this.scriptRunnerContext.reInitNoExit();
                }
            }
            try {
                this.out.flush();
            }
            catch (IOException e) {
                if (this.interrupted) break block19;
                e.printStackTrace();
            }
        }
    }

    public void finished() {
    }

    private void unknown(String text, SQLCommand cmd) {
        try {
            Ide.getStatusBar().setText(ScriptRunnerDbArb.getString(28));
            String localString = ScriptRunnerDbArb.format(16, new Integer(cmd.startLine + 1), cmd.getSQLOrig(), ScriptRunnerDbArb.format(29, text));
            this.out.write(localString.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printComment(String s) throws IOException {
        if (this.printComments) {
            this.out.write(s.getBytes("UTF-8"));
        }
    }

    private boolean replaceSubstitution(SQLCommand cmd) {
        String endCharacters = "@\"'. =*-;,/~\n\r|%^()\t!<>+:&";
        String in = cmd.getSql();
        boolean escapeNextChar = false;
        StringBuffer outStringBuffer = new StringBuffer();
        StringBuffer matchStringBuffer = new StringBuffer();
        String substitutionString = new Character(this.scriptRunnerContext.getSubstitutionChar()).toString();
        int state = 0;
        boolean atChar = false;
        int inLength = in.length();
        boolean atAt = false;
        block4: for (int i = 0; i < inLength; ++i) {
            char inChar = in.charAt(i);
            switch (state) {
                case 0: {
                    if (inChar == this.scriptRunnerContext.getSubstitutionChar() && !escapeNextChar) {
                        state = 1;
                        matchStringBuffer = new StringBuffer();
                        matchStringBuffer.append(inChar);
                        continue block4;
                    }
                    if (this.scriptRunnerContext.getEscape() && inChar == this.scriptRunnerContext.getEscapeChar() && !escapeNextChar) {
                        escapeNextChar = true;
                        continue block4;
                    }
                    outStringBuffer.append(inChar);
                    continue block4;
                }
                case 1: {
                    if (inChar == this.scriptRunnerContext.getTerminateChar()) {
                        if (matchStringBuffer.toString().equals("")) {
                            this.report(ScriptRunnerDbArb.format(16, new Integer(cmd.startLine + 1), cmd.getSQLOrig(), ScriptRunnerDbArb.getString(14)));
                            return true;
                        }
                        outStringBuffer.append(this.getSubString(matchStringBuffer.toString()));
                        state = 0;
                        continue block4;
                    }
                    if (!(endCharacters.indexOf(inChar) == -1 || inChar == this.scriptRunnerContext.getSubstitutionChar() && matchStringBuffer.toString().equals(substitutionString))) {
                        if (Character.isWhitespace(inChar) && matchStringBuffer.toString().endsWith(substitutionString)) continue block4;
                        outStringBuffer.append(this.getSubString(matchStringBuffer.toString()));
                        --i;
                        state = 0;
                        continue block4;
                    }
                    matchStringBuffer.append(inChar);
                }
            }
        }
        if (state == 1) {
            if (matchStringBuffer.toString().equals("")) {
                this.report(ScriptRunnerDbArb.format(16, new Integer(cmd.startLine + 1), cmd.getSQLOrig(), ScriptRunnerDbArb.getString(14)));
                return true;
            }
            outStringBuffer.append(this.getSubString(matchStringBuffer.toString()));
        }
        cmd.setSql(outStringBuffer.toString());
        return false;
    }

    private String getSubString(String subVal) {
        String toUpper = subVal.toUpperCase();
        boolean atAt = false;
        String returnedString = "";
        String contextSubString = Character.toString(this.scriptRunnerContext.getSubstitutionChar());
        if (toUpper.equals(contextSubString + contextSubString) || toUpper.equals(contextSubString)) {
            return subVal;
        }
        if (toUpper.startsWith(contextSubString + contextSubString)) {
            atAt = true;
            toUpper = toUpper.substring(2);
        } else if (toUpper.startsWith(contextSubString)) {
            toUpper = toUpper.substring(1);
        }
        Map map = this.scriptRunnerContext.getMap();
        String match = (String)map.get(toUpper);
        if (match == null) {
            match = this.getOneField(toUpper);
            if (atAt) {
                map.put(toUpper, match);
            }
        }
        return match;
    }

    private String getOneField(String varName) {
        String retVal = "";
        this.variableName = varName;
        try {
            Runnable showModalDialog = new Runnable(){

                public void run() {
                    ScriptRunner.this.substitutionString = (String)JOptionPane.showInputDialog(null, ScriptRunner.this.variableName + ":", ScriptRunnerDbArb.getString(9), -1, null, null, "");
                }
            };
            SwingUtilities.invokeAndWait(showModalDialog);
        }
        catch (InterruptedException e) {
            return "";
        }
        catch (InvocationTargetException e) {
            return "";
        }
        if (this.substitutionString == null) {
            this.substitutionString = "";
        }
        return this.substitutionString;
    }

    public BufferedOutputStream getOut() {
        return this.out;
    }

    public void setOut(BufferedOutputStream out) {
        this.out = out;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean isPrintComments() {
        return this.printComments;
    }

    public void setPrintComments(boolean printComments) {
        this.printComments = printComments;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public static void usage() {
        System.out.println("Usage: java oracle.dbdeveloper.db.scripts.ScriptRunner username/password@host:port:sid @file1 @file2 @file3 ...");
        System.exit(1);
    }

    public static String[] nextToChar(String in, char sep) {
        int position = in.indexOf(sep);
        if (position == -1) {
            ScriptRunner.usage();
        }
        String theRest = position == in.length() - 1 ? "" : in.substring(position + 1);
        String[] stringArray = new String[]{in.substring(0, position), theRest};
        return stringArray;
    }

    public static void main(String[] args) throws SQLException {
        block10: {
            if (args.length == 0) {
                ScriptRunner.usage();
            }
            DriverManager.registerDriver((Driver)new OracleDriver());
            String[] stringArray = ScriptRunner.nextToChar(args[0], '/');
            String username = stringArray[0];
            stringArray = ScriptRunner.nextToChar(stringArray[1], '@');
            String password = stringArray[0];
            String machinePortSid = stringArray[1];
            if (machinePortSid.indexOf(58) == -1) {
                machinePortSid = "127.0.0.1:1521:" + machinePortSid;
            }
            String url = "jdbc:oracle:thin:@" + machinePortSid;
            Connection conn = DriverManager.getConnection(url, username, password);
            conn.setAutoCommit(false);
            System.out.println("Running.....");
            int current = 0;
            try {
                int ii = args.length;
                for (int i = 1; i < ii; ++i) {
                    current = i;
                    long start = System.currentTimeMillis();
                    System.out.println("File:" + args[i]);
                    String inputFile = args[i];
                    FileInputStream fileInputStream = null;
                    if (inputFile.startsWith("@") && inputFile.length() > 1) {
                        inputFile = inputFile.substring(1);
                    }
                    if (inputFile.endsWith(".sql")) {
                        fileInputStream = new FileInputStream(new File(inputFile));
                    } else {
                        try {
                            fileInputStream = new FileInputStream(new File(inputFile + ".sql"));
                        }
                        catch (FileNotFoundException fnfe) {
                            fileInputStream = new FileInputStream(new File(inputFile));
                        }
                    }
                    ScriptRunner runner = new ScriptRunner(fileInputStream);
                    runner.setConn(conn);
                    runner.run();
                    System.out.println("Elapsed:" + (System.currentTimeMillis() - start));
                }
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("File:" + args[current] + " not found.");
                if (args.length - 1 <= current) break block10;
                System.out.println("Skipping remaining files.");
            }
        }
        System.out.println("Exiting");
    }

    protected void report(String s) {
        if (this.out != null) {
            try {
                this.out.write(s.getBytes("UTF-8"));
                this.out.write(10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getStatusLine() {
        return Ide.getStatusBar().getText();
    }

    public void setStatusLine(String statusLine) {
        Ide.getStatusBar().setText(statusLine);
    }

    public SQLCommand[] getCmds() {
        return this.cmds;
    }

    public void setCmds(SQLCommand[] cmds) {
        this.cmds = cmds;
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.scriptRunnerContext;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.scriptRunnerContext = scriptRunnerContext;
    }
}

