/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import oracle.javatools.db.Database;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdeveloper.cm.CMUtils;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.DefaultConnectionStore;
import oracle.jdeveloper.cm.JdbcConnectionWrapper;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdeveloper.cm.dt.browser.DatabaseBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connections {
    private ConnectionManager _cm;
    private ConnectionsProvider _cp;
    private static Connections _connections;
    private static final Object LOCK;

    public Connections() {
        this.setCm(ConnectionManager.getInstance());
        this.setCp(ConnectionsProvider.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connections getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_connections == null) {
                _connections = new Connections();
            }
        }
        return _connections;
    }

    public Database getDatabase(Connection conn) {
        Database ret = null;
        try {
            String[] names = this.getCm().getConnectionNames();
            Object lookupConn = null;
            DatabaseConnectionNode dbNode = null;
            for (int i = 0; ret == null && i < names.length; ++i) {
                dbNode = this.getDBConnectionNode(names[i]);
                if (!dbNode.isOpen() || !this.getConnection(names[i]).equals(conn)) continue;
                ret = this.getDatabase(names[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public Database getDatabase(String connName) {
        return this.getDatabase(connName, true);
    }

    public Database getDatabase(String connName, boolean forceOpen) {
        DatabaseBrowser browser;
        DatabaseConnectionNode dbNode = (DatabaseConnectionNode)this.getCp().getConnectionNode(connName);
        if (forceOpen) {
            dbNode.ensureOpen();
        }
        return (browser = (DatabaseBrowser)dbNode.getConnectionBrowser()) != null ? browser.getDatabase() : null;
    }

    public Connection getConnection(String name) {
        DatabaseBrowser browser;
        DatabaseConnectionNode dbNode = (DatabaseConnectionNode)this.getCp().getConnectionNode(name);
        if (dbNode != null) {
            dbNode.ensureOpen();
        }
        return (browser = (DatabaseBrowser)dbNode.getConnectionBrowser()) != null ? browser.getDatabase().getConnection() : null;
    }

    public DatabaseConnectionNode getDBConnectionNode(String connName) {
        return (DatabaseConnectionNode)this._cp.getConnectionNode(connName);
    }

    public String[] getConnNames() {
        String[] ret = null;
        try {
            ret = this.getCm().getConnectionNames();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public ConnectionManager getCm() {
        return this._cm;
    }

    public void setCm(ConnectionManager cm) {
        this._cm = cm;
    }

    public ConnectionsProvider getCp() {
        return this._cp;
    }

    public void setCp(ConnectionsProvider cp) {
        this._cp = cp;
    }

    public static String getConnName(URL u) {
        String ret = "";
        if (u.getPath().indexOf("/") > 0) {
            ret = u.getPath().substring(u.getPath().indexOf("/") + 1);
        }
        return ret;
    }

    public Connection getTestConnection(String connName) throws Exception {
        DriverManager.registerDriver((Driver)new OracleDriver());
        DefaultConnectionStore store = new DefaultConnectionStore(System.getProperty("sdev.testConnectionFile"), true);
        this._cm.setConnectionStore((ConnectionStore)store);
        JdbcConnectionWrapper cw = (JdbcConnectionWrapper)Connections.getInstance().getCm().getConnection(connName);
        String url = CMUtils.getUrl((String)"JDBC", (ConnectionDescriptor)cw.getDescriptor());
        Connection conn = DriverManager.getConnection(url, cw.getDescriptor().getUsername(), cw.getDescriptor().getPassword());
        return conn;
    }

    public ArrayList<String> getTestConnectionNames() {
        ArrayList<String> connNames = new ArrayList<String>();
        connNames.add("10.2");
        connNames.add("9.2");
        connNames.add("8");
        return connNames;
    }

    public static void main(String[] args) throws Exception {
        String sql = "select product,version from PRODUCT_COMPONENT_VERSION";
        Connection conn = Connections.getInstance().getTestConnection("8");
        ResultSet rs = conn.prepareStatement(sql).executeQuery();
        while (rs.next()) {
            System.out.println(rs.getString(1) + ":" + rs.getString(2));
        }
        rs.close();
        conn.close();
        conn = Connections.getInstance().getTestConnection("9.2");
        rs = conn.prepareStatement(sql).executeQuery();
        while (rs.next()) {
            System.out.println(rs.getString(1) + ":" + rs.getString(2));
        }
        rs.close();
        conn.close();
        conn = Connections.getInstance().getTestConnection("10.2");
        rs = conn.prepareStatement(sql).executeQuery();
        while (rs.next()) {
            System.out.println(rs.getString(1) + ":" + rs.getString(2));
        }
        rs.close();
        conn.close();
    }

    static {
        LOCK = new Object();
    }
}

