/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.dbtools.raptor.ColumnTreeNode;
import oracle.dbtools.raptor.explorer.dt.IViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Node;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.TopLevelObjectID;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.RecycledObjectNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.RelationNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.SchemaFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.TriggerNode;
import oracle.jdeveloper.cm.dt.net.JDevCmURLFileSystemHelper;
import oracle.jdevimpl.cm.dt.browser.jdbc.OtherSchemas;

public class DBObject {
    protected Node _node;
    protected String _objectName;
    protected String _schemaName;
    protected String _objectId;
    protected String _objectType;
    protected String _childName;
    protected SchemaObject _schemaObject;
    protected Database _db;
    private HashMap _dict;
    public static final String DBOBJECT_KEY = "DB_OBJECT";

    public DBObject(Node node) {
        this._node = node instanceof IViewerNode ? (Node)((IViewerNode)node).getDatabaseNode() : node;
        this.loadDBData();
    }

    public HashMap getDictionary() {
        if (this._dict == null) {
            this._dict = new HashMap();
            this._dict.put("OBJECT_NAME", this.getObjectName());
            this._dict.put("OBJECT_TYPE", this.getObjectType());
            this._dict.put("OBJECT_OWNER", this.getSchemaName());
            this._dict.put("COLUMN_NAME", this.getChildName());
            this._dict.put("OBJECT_ID", this.getObjectId());
            this._dict.put("CHILD_NAME", this.getChildName());
            try {
                this._dict.put("USER", this.getDatabase().getConnection().getMetaData().getUserName());
            }
            catch (SQLException e) {
                ExceptionHandler.handleException(e);
            }
        }
        return this._dict;
    }

    public void loadDBData() {
        if (this._node instanceof ColumnTreeNode) {
            this.processNonPlSql(((ColumnTreeNode)this._node).getParent());
            this._childName = ((ColumnTreeNode)this._node).getShortLabel();
            this._objectType = "COLUMN";
        } else if (this._node instanceof PlSqlBaseNode || this._node instanceof TriggerNode) {
            this.processPlSqlNode((PlSqlBaseNode)this._node);
        } else if (this._node instanceof RecycledObjectNode) {
            this.processOCBNode((OCBBaseNode)this._node);
            this._childName = ((RecycledObjectNode)this._node).getRecycledObject().getOriginalName();
        } else if (this._node instanceof OCBBaseNode) {
            this.processOCBNode((OCBBaseNode)this._node);
        } else if (this._node instanceof SchemaFolder) {
            this.processSchemaFolder((SchemaFolder)this._node);
        } else if (this._node instanceof OCBBaseFolder) {
            this.processFolder((OCBBaseFolder)this._node);
        } else if (this._node instanceof OtherSchemas) {
            this.processFolder((OtherSchemas)this._node);
        } else if (this._node instanceof DatabaseConnectionNode) {
            this.processConnectionNode((DatabaseConnectionNode)this._node);
        } else if (this._node instanceof RelationNode) {
            this.processNonPlSql((RelationNode)this._node);
        }
    }

    private void processConnectionNode(DatabaseConnectionNode node) {
        this._db = Connections.getInstance().getDatabase(node.getConnectionName(), false);
        this._objectType = "CONNECTION";
        this._objectName = node.getLongLabel();
    }

    private void processFolder(OtherSchemas schemas) {
        this._db = ((SchemaFolder)schemas.getChildren().next()).getDatabase();
        this._objectType = "USER_FOLDER";
    }

    private void processFolder(OCBBaseFolder folder) {
        this._db = folder.getDatabase();
        this._objectType = folder.getObjectType() + "_FOLDER";
    }

    private void processSchemaFolder(SchemaFolder folder) {
        this._db = folder.getDatabase();
        this._schemaName = folder.getName();
        this._objectName = folder.getName();
        this._objectType = "USER";
    }

    public void processOCBNode(OCBBaseNode node) {
        this._objectName = node.getName();
        this._schemaName = node.getSchema();
        this._objectType = node instanceof PlSqlFolder ? "PACKAGE_PARENT" : node.getObjectType();
        this._db = node.getDatabase();
    }

    private void processNonPlSql(RelationNode relationNode) {
        this._objectName = relationNode.getName();
        this._objectType = relationNode.getObjectType();
        this._schemaName = relationNode.getSchema();
        this._db = relationNode.getDatabase();
    }

    private void processPlSqlNode(PlSqlBaseNode plsqlNode) {
        URL url = plsqlNode.getURL();
        Object id = null;
        try {
            Database db = plsqlNode.getDatabase();
            this._objectType = plsqlNode.isBody() ? "PACKAGE BODY" : CmUtil.getDbObjectType((URL)url);
            this._schemaName = CmUtil.getUserName((URL)url);
            this._objectName = JDevCmURLFileSystemHelper.getRealName((String)this._objectType, (String)CmUtil.getName((URL)url));
            AbstractSchemaObject plsql = (AbstractSchemaObject)db.getObject(this._objectType, db.getSchema(this._schemaName), this._objectName);
            this._schemaObject = plsql;
            if (plsql != null && !plsqlNode.isBody() && plsql.getID() != null && ((TopLevelObjectID)plsql.getID()).getID() > 0) {
                this._objectId = ((TopLevelObjectID)plsql.getID()).getID() + "";
            }
            this._db = plsqlNode.getDatabase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Node getNode() {
        return this._node;
    }

    public void setNode(Node node) {
        this._node = node;
        this.loadDBData();
    }

    public String getObjectName() {
        return this._objectName;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public String getObjectId() {
        DBObjectID idObj;
        if (this._objectId == null && this.getSchemaObject() != null && (idObj = ((OCBBaseNode)this._node).getSchemaObject().getID()) != null && idObj instanceof TopLevelObjectID) {
            this._objectId = ((TopLevelObjectID)((OCBBaseNode)this._node).getSchemaObject().getID()).getID() + "";
        }
        return this._objectId;
    }

    public String getObjectType() {
        return this._objectType;
    }

    public String getChildName() {
        return this._childName;
    }

    public SchemaObject getSchemaObject() {
        if (this._schemaObject == null && this._node instanceof OCBBaseNode) {
            this._schemaObject = ((OCBBaseNode)this._node).getSchemaObject();
        }
        return this._schemaObject;
    }

    public Database getDatabase() {
        if (this._db == null && this._objectType.equals("CONNECTION")) {
            this._db = Connections.getInstance().getDatabase(this._objectName);
        }
        return this._db;
    }
}

