/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.util.ModelUtil;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class DataTypesUtil {
    public static boolean isEqual(Object obj1, Object obj2, Connection conn, int columType) {
        String s;
        if (DataTypesUtil.isExtendedType(obj1, columType)) {
            return ModelUtil.areEqual((Object)obj1, (Object)obj2);
        }
        if (obj1 != null && obj2 != null && (s = DataTypesUtil.stringValue(obj1, conn)) != null) {
            return s.equals(obj2);
        }
        return false;
    }

    public static String stringValue(Object obj, Connection conn) {
        if (obj == null) {
            return null;
        }
        String str = null;
        Object origValue = null;
        if (obj instanceof CLOB) {
            try {
                origValue = obj;
                str = ((CLOB)obj).getSubString(1L, (int)((CLOB)obj).length());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof BLOB) {
            origValue = obj;
            str = Translate.translate("(BLOB)");
        } else if (obj instanceof RAW) {
            origValue = obj;
            str = Translate.translate("(RAW)");
        } else if (obj instanceof BFILE) {
            origValue = obj;
            str = Translate.translate("(BFILE)");
        } else if (obj instanceof TIMESTAMPTZ) {
            str = (String)NLSUtils.getValue(conn, (TIMESTAMPTZ)obj);
        } else if (obj instanceof TIMESTAMPLTZ) {
            str = (String)NLSUtils.getValue(conn, (TIMESTAMPLTZ)obj);
        } else if (obj instanceof TIMESTAMP) {
            str = (String)NLSUtils.getValue(conn, (TIMESTAMP)obj);
        } else if (obj instanceof DATE) {
            str = (String)NLSUtils.getValue(conn, (DATE)obj);
        } else if (obj instanceof Date) {
            try {
                str = NLSUtils.formatDate(conn, new DATE((Date)obj));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof NUMBER) {
            str = (String)NLSUtils.getValue(conn, (NUMBER)obj);
        } else if (obj instanceof OPAQUE) {
            try {
                str = ((OPAQUE)obj).getSQLTypeName().trim();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof STRUCT) {
            try {
                str = ((STRUCT)obj).getSQLTypeName().trim();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof Datum) {
            try {
                str = ((Datum)obj).stringValue();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            str = obj.toString();
        }
        return str;
    }

    public static boolean isExtendedType(Object obj, int colType) {
        return obj instanceof ExtendedType || obj instanceof BFILE || colType == -13 || obj instanceof BLOB || colType == 2004;
    }

    public static void main(String[] args) {
    }
}

