/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import oracle.dbtools.raptor.utils.HistoryComparator;
import oracle.dbtools.raptor.utils.HistoryItem;
import oracle.ide.Ide;

public class History {
    TreeSet past = new TreeSet(new HistoryComparator());
    private int maxHistorySize = 100;
    private String historyFileName = Ide.getHomeDirectory() + "history.ser";

    public History() {
        this.intialize();
    }

    public synchronized int getMaxHistorySize() {
        return this.maxHistorySize;
    }

    public synchronized void setMaxHistorySize(int p1) {
        this.maxHistorySize = p1;
    }

    public synchronized void update(HistoryItem hi) {
        if (!this.past.contains(hi)) {
            // empty if block
        }
        this.past.add(hi);
        if (this.past.size() > this.getMaxHistorySize()) {
            Object oldest = this.findOldest(this.past);
            this.past.remove(oldest);
        }
        if (hi.getClass().toString().endsWith("SQLHistoryItem")) {
            this.serialize(hi);
        }
    }

    private Object findOldest(TreeSet past) {
        Iterator it = past.iterator();
        HistoryItem oldestItem = null;
        Date oldestDate = null;
        HistoryItem currItem = null;
        Date currDate = null;
        if (it != null) {
            oldestItem = (HistoryItem)it.next();
            oldestDate = oldestItem.getTimestamp();
        }
        while (it.hasNext()) {
            currItem = (HistoryItem)it.next();
            currDate = currItem.getTimestamp();
            if (!currDate.before(oldestDate)) continue;
            oldestItem = currItem;
            oldestDate = currDate;
        }
        return oldestItem;
    }

    private void serialize(HistoryItem hi) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.historyFileName));
            out.writeObject(this.past);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intialize() {
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(this.historyFileName);
            in = new ObjectInputStream(fis);
            this.past = (TreeSet)in.readObject();
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public List asList() {
        return Arrays.asList(this.past.toArray());
    }

    public String[] getHistory() {
        String[] s = new String[this.past.size()];
        int i = 0;
        for (HistoryItem hi : this.past) {
            s[i++] = hi.getData().toString();
        }
        return s;
    }
}

