/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.Reader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.metadata.MetaData;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.util.Assert;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;

public class MetaDataDDLGenerator {
    private static final String META_SQL = "SELECT DBMS_METADATA.GET_DDL(:TYPE,:NAME,:OWNER) SQL FROM SYS.DUAL";
    private static final String USER_META_SQL = "SELECT DBMS_METADATA.GET_DDL(:TYPE,:NAME) SQL FROM SYS.DUAL";
    private static final String TABLE_SQL = "declare   owner  varchar2(2000) := ?;    object varchar2(2000) := ?;    h  number;    h2 number; begin    h := dbms_metadata.open('TABLE');    dbms_metadata.set_filter(h,'SCHEMA',owner);    dbms_metadata.set_filter(h,'NAME',object);    dbms_metadata.set_filter(h,'EXCLUDE_PATH_EXPR','in (''TABLE_DATA'',''STATISTICS'',''POST_INSTANCE'',''INSTANCE_CALLOUT'',''PROCACT_INSTANCE'',''PRE_TABLE_ACTION'',''POST_TABLE_ACTION'')');    h2 := DBMS_METADATA.ADD_TRANSFORM(h,'DDL');    dbms_metadata.set_transform_param(h2,'SQLTERMINATOR',true);   ? := h;end;";
    private static final String TABLE_SQL_CLOB = "begin  ? := dbms_metadata.fetch_clob(?); end;";

    public static String getDDLFromGenerator(DBObject dbObject) {
        Database database = dbObject.getDatabase();
        String code = null;
        if (database != null) {
            OracleDDLGenerator generator = new OracleDDLGenerator((DBObjectProvider)database);
            Ddl d = generator.getCreateDDL(dbObject.getSchemaObject(), false, false);
            code = d.getDdl();
        }
        return code;
    }

    public static String getDDL(DBObject dbObject) {
        String ret = MetaData.getDDL(dbObject);
        if (ret == null && dbObject.getObjectType().equals("TABLE")) {
            ret = MetaDataDDLGenerator.getTableMetaData(dbObject);
        } else if (ret == null && dbObject.getObjectType().equals("USER")) {
            ret = MetaDataDDLGenerator.getUserFromMeta(dbObject);
        } else if (ret == null) {
            ret = MetaDataDDLGenerator.getDDLFromMeta(dbObject);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserFromMeta(DBObject dbObject) {
        String code = null;
        DBUtil dbUtil = new DBUtil();
        dbUtil.setRaiseError(false);
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("TYPE", dbObject.getObjectType().replace(" ", "_"));
        binds.put("NAME", dbObject.getObjectName());
        ResultSet rs = dbUtil.executeQuery(dbObject.getDatabase().getConnectionName(), USER_META_SQL, binds);
        try {
            if (rs.next()) {
                code = rs.getString(1);
            }
        }
        catch (Exception e) {
            String string = "-- DBMS_METADATA was unable to generate SQL. Now using internal DDL generator\n-- To Test DBMS_METADATA : select dbms_metadata.get_ddl('TABLE','DUAL','SYS') from dual;\n" + MetaDataDDLGenerator.getDDLFromGenerator(dbObject);
            return string;
        }
        finally {
            try {
                if (rs != null && rs.getStatement() != null) {
                    rs.getStatement().close();
                }
            }
            catch (SQLException e) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {}
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDDLFromMeta(DBObject dbObject) {
        String code = null;
        DBUtil dbUtil = new DBUtil();
        dbUtil.setRaiseError(false);
        HashMap<String, String> binds = new HashMap<String, String>();
        if (dbObject.getObjectType().equals("DATABASE LINK")) {
            binds.put("TYPE", "DB_LINK");
        } else {
            binds.put("TYPE", dbObject.getObjectType().replace(" ", "_"));
        }
        binds.put("NAME", dbObject.getObjectName());
        binds.put("OWNER", dbObject.getSchemaName());
        ResultSet rs = dbUtil.executeQuery(dbObject.getDatabase().getConnectionName(), META_SQL, binds);
        try {
            if (rs.next()) {
                code = rs.getString(1);
            }
        }
        catch (Exception e) {
            String string = "-- DBMS_METADATA was unable to generate SQL. Now using internal DDL generator\n-- To Test DBMS_METADATA : select dbms_metadata.get_ddl('TABLE','DUAL','SYS') from dual;\n" + MetaDataDDLGenerator.getDDLFromGenerator(dbObject);
            return string;
        }
        finally {
            try {
                if (rs != null && rs.getStatement() != null) {
                    rs.getStatement().close();
                }
            }
            catch (SQLException e) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {}
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableMetaData(DBObject dbObject) {
        StringBuilder ret = new StringBuilder();
        OracleCallableStatement stmt = null;
        OracleCallableStatement stmt2 = null;
        Assert.startTiming((String)MetaDataDDLGenerator.class.toString(), (String)".getTableMetaData", (boolean)false);
        try {
            int read;
            stmt = (OracleCallableStatement)dbObject.getDatabase().getConnection().prepareCall(TABLE_SQL);
            stmt.setString(1, dbObject.getSchemaName());
            stmt.setString(2, dbObject.getObjectName());
            stmt.registerOutParameter(3, 2);
            stmt.execute();
            BigDecimal handle = stmt.getBigDecimal(3);
            boolean cnt = false;
            CLOB ddl = null;
            stmt2 = (OracleCallableStatement)dbObject.getDatabase().getConnection().prepareCall(TABLE_SQL_CLOB);
            stmt2.registerOutParameter(1, 2005);
            stmt2.setBigDecimal(2, handle);
            stmt2.execute();
            ddl = stmt2.getCLOB(1);
            Reader reader = ddl.getCharacterStream();
            char[] buffer = new char[8192];
            while ((read = reader.read(buffer)) != -1) {
                ret.append(buffer, 0, read);
            }
        }
        catch (Exception e) {
            if (ret.length() < 10) {
                String string = "-- DBMS_METADATA was unable to use TABLE_EXPORT to generate sql.  Now trying to use TABLE.\n" + MetaDataDDLGenerator.getDDLFromMeta(dbObject);
                return string;
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {}
        }
        Assert.endTiming((String)MetaDataDDLGenerator.class.toString(), (String)".getTableMetaData", (String)MetaDataDDLGenerator.class.toString(), (boolean)false);
        return ret.toString();
    }
}

