/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.utils.Connections;
import oracle.i18n.text.OraDecimalFormatSymbols;
import oracle.i18n.text.OraNumberFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLSUtils {
    private static final HashMap<Object, HashMap<String, String>> nlsMappings = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateNLS(Connection conn) {
        Statement stmt = null;
        ResultSet rset = null;
        try {
            HashMap<Object, Object> nlsMap = nlsMappings.get(conn) == null ? new HashMap() : nlsMappings.get(conn);
            stmt = conn.prepareStatement("select parameter,value from nls_session_parameters union all SELECT 'DB_TIMEZONE' name, DBTIMEZONE  value FROM DUAL");
            rset = stmt.executeQuery();
            while (rset.next()) {
                nlsMap.put(rset.getString(1), rset.getString(2));
            }
            nlsMappings.put(conn, nlsMap);
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public static void populateNLS(OracleDatabase db) {
        NLSUtils.populateNLS(db.getConnection());
    }

    public static HashMap<String, String> getNLSMap(Connection conn) {
        if (nlsMappings.get(conn) == null) {
            NLSUtils.populateNLS(conn);
        }
        return nlsMappings.get(conn);
    }

    public static String formatDate(Connection conn, DATE date) throws SQLException {
        HashMap<String, String> nlsMap = NLSUtils.getNLSMap(conn);
        String result = null;
        try {
            OraDATEFormat formatDate = new OraDATEFormat(nlsMap.get("NLS_DATE_FORMAT"), OraLocaleInfo.getInstance((String)nlsMap.get("NLS_LANGUAGE"), (String)nlsMap.get("NLS_TERRITORY")));
            result = formatDate.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getDateFormat(OracleDatabase db) {
        if (db == null) {
            return null;
        }
        return NLSUtils.getDateFormat(db.getConnection());
    }

    public static String getDateFormat(Connection conn) {
        if (conn == null) {
            return null;
        }
        HashMap<String, String> nlsMap = NLSUtils.getNLSMap(conn);
        return nlsMap.get("NLS_DATE_FORMAT");
    }

    public static String getTimeStampFormat(Connection conn) {
        if (conn == null) {
            return null;
        }
        HashMap<String, String> nlsMap = NLSUtils.getNLSMap(conn);
        return nlsMap.get("NLS_TIMESTAMP_FORMAT");
    }

    public static String getTimeStampTZFormat(Connection conn) {
        if (conn == null) {
            return null;
        }
        HashMap<String, String> nlsMap = NLSUtils.getNLSMap(conn);
        return nlsMap.get("NLS_TIMESTAMP_TZ_FORMAT");
    }

    public static String getFormat(Connection conn, String prop) {
        if (conn == null) {
            return null;
        }
        HashMap<String, String> nlsMap = NLSUtils.getNLSMap(conn);
        return nlsMap.get(prop);
    }

    public static String getDateFormat(String connName) {
        OracleDatabase db = null;
        try {
            db = (OracleDatabase)Connections.getInstance().getDatabase(connName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return NLSUtils.getDateFormat(db);
    }

    public static String formatDate(String connName, DATE date) throws SQLException {
        OracleDatabase db = null;
        try {
            db = (OracleDatabase)Connections.getInstance().getDatabase(connName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return NLSUtils.formatDate(db.getConnection(), date);
    }

    public static String formatTIMESTAMP(Connection conn, TIMESTAMP time) {
        String ret = null;
        HashMap<String, String> nlsMap = NLSUtils.getNLSMap(conn);
        try {
            OraTIMESTAMPFormat formatTimestamp = new OraTIMESTAMPFormat(nlsMap.get("NLS_TIMESTAMP_FORMAT"), OraLocaleInfo.getInstance((String)nlsMap.get("NLS_LANGUAGE"), (String)nlsMap.get("NLS_TERRITORY")));
            nlsMap.put("NLS_TIMESTAMP_FORMAT", formatTimestamp.toPattern());
            ret = formatTimestamp.format(time);
        }
        catch (ParseException e) {
            System.err.println("Could not format :" + nlsMap.get("NLS_TIMESTAMP_FORMAT"));
        }
        return ret;
    }

    public static String formatTIMESTAMPTZ(Connection conn, TIMESTAMPTZ time) {
        String ret = null;
        HashMap<String, String> nlsMap = NLSUtils.getNLSMap(conn);
        try {
            OraTIMESTAMPTZFormat formatTimestampTZ = new OraTIMESTAMPTZFormat(nlsMap.get("NLS_TIMESTAMP_TZ_FORMAT"), OraLocaleInfo.getInstance((String)nlsMap.get("NLS_LANGUAGE"), (String)nlsMap.get("NLS_TERRITORY")));
            nlsMap.put("NLS_TIMESTAMP_TZ_FORMAT", formatTimestampTZ.toPattern());
            ret = formatTimestampTZ.format(time);
        }
        catch (ParseException e) {
            System.err.println("Could not format :" + nlsMap.get("NLS_TIMESTAMP_TZ_FORMAT"));
        }
        return ret;
    }

    public static String formatTIMESTAMPLTZ(Connection conn, TIMESTAMPLTZ time) {
        String ret = null;
        HashMap<String, String> nlsMap = NLSUtils.getNLSMap(conn);
        try {
            OraTIMESTAMPFormat formatTimestamp = new OraTIMESTAMPFormat(nlsMap.get("NLS_TIMESTAMP_FORMAT"), OraLocaleInfo.getInstance((String)nlsMap.get("NLS_LANGUAGE"), (String)nlsMap.get("NLS_TERRITORY")), nlsMap.get("DB_TIMEZONE"));
            ret = formatTimestamp.format(time);
        }
        catch (ParseException e) {
            System.err.println("Could not format :" + nlsMap.get("NLS_TIMESTAMP_FORMAT"));
        }
        return ret;
    }

    public static String formatNUMBER(Connection conn, NUMBER num) {
        String ret = null;
        ret = num.stringValue();
        if (ret.indexOf(46) != -1) {
            HashMap<String, String> nlsMap = NLSUtils.getNLSMap(conn);
            char decimalSeparator = new OraDecimalFormatSymbols(OraLocaleInfo.getInstance((String)nlsMap.get("NLS_LANGUAGE"), (String)nlsMap.get("NLS_TERRITORY"))).getDecimalSeparator();
            try {
                BigDecimal bd = num.bigDecimalValue();
                ret = bd.toPlainString();
                if (decimalSeparator != '.') {
                    ret = ret.replace('.', decimalSeparator);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static Object getValue(Connection conn, Object obj) {
        if (obj == null) {
            return obj;
        }
        String retVal = "";
        try {
            retVal = obj instanceof Clob ? ((Clob)obj).getSubString(1L, (int)((Clob)obj).length()) : (obj instanceof OPAQUE ? ((OPAQUE)obj).getSQLTypeName().trim() : (obj instanceof TIMESTAMP && conn != null ? NLSUtils.formatTIMESTAMP(conn, (TIMESTAMP)obj) : (obj instanceof TIMESTAMPTZ && conn != null ? NLSUtils.formatTIMESTAMPTZ(conn, (TIMESTAMPTZ)obj) : (obj instanceof TIMESTAMPLTZ && conn != null ? NLSUtils.formatTIMESTAMPLTZ(conn, (TIMESTAMPLTZ)obj) : (obj instanceof DATE && conn != null ? NLSUtils.formatDate(conn, (DATE)obj) : (obj instanceof Date && conn != null ? NLSUtils.formatDate(conn, new DATE((Date)obj)) : (obj instanceof NUMBER && conn != null ? NLSUtils.formatNUMBER(conn, (NUMBER)obj) : (obj instanceof Datum ? ((Datum)obj).stringValue() : obj.toString()))))))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static void main(String[] args) {
        OraNumberFormat formatNumber = OraNumberFormat.getNumberInstance((OraLocaleInfo)OraLocaleInfo.getInstance((String)"AMERICAN", (String)"AMERICA"));
        formatNumber.setGroupingUsed(false);
        formatNumber.setParseIntegerOnly(false);
        BigDecimal bd = new BigDecimal("123456789123456789.987654321987654321");
        System.out.println("mask:" + OraNumberFormat.getDefaultNumberFormatPattern((OraLocaleInfo)OraLocaleInfo.getInstance((String)"AMERICAN", (String)"AMERICA")));
        System.out.println("unformatted:" + bd);
        System.out.println("formatted  :" + formatNumber.format(bd));
    }
}

