/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

public class TCPTNSEntry {
    public static int SPEC_SHORT_FORMAT = 1;
    public static int SPEC_LONG_FORMAT = 2;
    private static int spec_format = 0;
    private static String SPEC_PROTOCOL = "(PROTOCOL=TCP)";
    private static String SPEC_HOST = "(HOST=";
    private static String SPEC_PORT = "(PORT=";
    private static String SPEC_SERVICE_NAME = "(SERVICE_NAME=";
    private static String SPEC_SID = "(SID=";
    private String name = null;
    private String hostname = null;
    private String portno = null;
    private String sid = null;
    private String servicename = null;
    private String desc = null;

    public TCPTNSEntry(String tnsName, String descriptor) {
        spec_format = SPEC_LONG_FORMAT;
        this.name = tnsName;
        this.desc = descriptor;
    }

    TCPTNSEntry(String item, int spec_format) {
        TCPTNSEntry.spec_format = spec_format;
        String copy = item.toUpperCase();
        this.populate(copy);
    }

    protected void populate(String item) {
        String copy = item.toUpperCase();
        int start = 0;
        int end = copy.indexOf("=", start);
        this.name = item.substring(start, end);
        if (spec_format == SPEC_SHORT_FORMAT) {
            start = copy.indexOf(SPEC_PORT, 0) + SPEC_PORT.length();
            end = copy.indexOf(")", start);
            this.portno = item.substring(start, end);
            start = copy.indexOf(SPEC_HOST, 0) + SPEC_HOST.length();
            end = copy.indexOf(")", start);
            this.hostname = item.substring(start, end);
            start = copy.indexOf(SPEC_SERVICE_NAME, 0);
            if (start > 0) {
                end = copy.indexOf(")", start += SPEC_SERVICE_NAME.length());
                this.servicename = item.substring(start, end);
            }
            if ((start = copy.indexOf(SPEC_SID, 0)) > 0) {
                end = copy.indexOf(")", start += SPEC_SID.length());
                this.sid = item.substring(start, end);
            }
        } else if (spec_format == SPEC_LONG_FORMAT) {
            this.desc = item.substring(end + 1);
        }
    }

    public String getJDBCUrl() {
        String url = null;
        if (spec_format == SPEC_SHORT_FORMAT) {
            if (this.servicename != null) {
                url = "jdbc:oracle:thin:@\\\\" + this.hostname + ":" + this.portno + "\\" + this.servicename;
            } else if (this.sid != null) {
                url = "jdbc:oracle:thin:@" + this.hostname + ":" + this.portno + ":" + this.sid;
            }
        } else if (spec_format == SPEC_LONG_FORMAT) {
            url = "jdbc:oracle:thin:@" + this.desc;
        }
        return url;
    }

    public static void printUrl(String[] items) {
        for (int i = 0; i < items.length; ++i) {
            TCPTNSEntry te = new TCPTNSEntry(items[i].replaceAll("\\s", ""), SPEC_LONG_FORMAT);
            System.out.println(te.getJDBCUrl());
        }
    }

    public static void main(String[] args) {
        String[] items = new String[]{"ORCL=(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=localhost)(PORT=1521))(CONNECT_DATA=(SERVER=DEDICATED)(SERVICE_NAME=orcl)))", "spx2tcp  = (description= (address_list=(address=(protocol=spx)(service=orasrvc1))(address=(protocol=tcp)(port=1580)(host=spcstn)))(connect_data=(sid=cman))(source_route=yes))", "tcp_mv713 =\n  (DESCRIPTION =\n    (ADDRESS=      (PROTOCOL=TCP) (HOST=hostname) (PORT=1521))\n    (CONNECT_DATA= (SID=MV713))\n  )", "mv713 = \n  (DESCRIPTION =\n    (ADDRESS=      (PROTOCOL=IPC) (KEY=700))\n    (CONNECT_DATA= (SID=MV713)) \n  )", "EXTPROC_CONNECTION_DATA=(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=IPC)(KEY=EXTPROC1)))"};
        try {
            TCPTNSEntry.printUrl(items);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPortno() {
        return this.portno;
    }

    public String getSid() {
        return this.sid;
    }

    public String getServicename() {
        return this.servicename;
    }
}

