/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ds.db.DatabaseFactory;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.net.JDevCmURLFileSystemHelper;

public abstract class DatabaseEditorNode
extends Node {
    protected Database _db;
    private static Map _protocols = new HashMap();

    public static boolean isDatabaseEditorNodeURL(URL url) {
        return url != null && DatabaseEditorNode.isDatabaseEditorProtocol(url.getProtocol());
    }

    public static boolean isDatabaseEditorProtocol(String protocol) {
        return _protocols.containsKey(protocol);
    }

    public static void registerProtocol(String protocol, Class nodeClass) {
        if (nodeClass == null || !DatabaseEditorNode.class.isAssignableFrom(nodeClass)) {
            throw new IllegalArgumentException("The nodeClass must be a subclass of DatabaseEditorNode");
        }
        _protocols.put(protocol, nodeClass);
        URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)JDevCmURLFileSystemHelper.getInstance());
    }

    public static String getConnectionName(URL url) {
        return url != null ? url.getPath() : null;
    }

    public static DatabaseEditorNode findOrCreateNode(URL url) {
        String protocol;
        Class cls;
        DatabaseEditorNode node = null;
        if (url != null && (cls = (Class)_protocols.get(protocol = url.getProtocol())) != null) {
            try {
                node = (DatabaseEditorNode)NodeFactory.findOrCreate((Class)cls, (URL)url);
            }
            catch (ClassCastException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (InstantiationException ex) {
                // empty catch block
            }
        }
        return node;
    }

    protected DatabaseEditorNode() {
    }

    public String getConnectionName() {
        return DatabaseEditorNode.getConnectionName(this.getURL());
    }

    public Database getDatabase() {
        if (this._db == null) {
            this.ensureOpen();
        }
        return this._db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cleanupClose() {
        if (this._db != null) {
            try {
                this._db.close();
            }
            catch (Exception exception) {
            }
            finally {
                this._db = null;
            }
        }
    }

    protected void closeImpl() throws IOException {
        this._cleanupClose();
        super.closeImpl();
    }

    protected void openImpl() throws IOException {
        super.openImpl();
        if (this._db == null) {
            try {
                final String connName = this.getConnectionName();
                ProgressRunnable runnable = new ProgressRunnable(){

                    protected Object doWork() throws CMException {
                        return DatabaseFactory.createDatabase((String)connName);
                    }

                    protected void finish(Object result) {
                        if (result instanceof Database) {
                            DatabaseEditorNode.this._db = (Database)result;
                        }
                    }
                };
                runnable.setMessage(ConnectionArb.format((int)453, (Object)connName));
                runnable.setTitle(ConnectionArb.getString((int)452));
                runnable.start(true);
            }
            catch (ProgressException ex) {
                this._cleanupClose();
                Throwable t = ex.getCause();
                if (t instanceof CMException && ((CMException)t).isWrapper()) {
                    t = ((CMException)t).unwrap();
                }
                if (t instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog((Component)IdeUtil.getMainWindow(), (String)ConnectionArb.getString((int)454), (SQLException)((SQLException)t));
                }
                ExceptionDialog.showExceptionDialog((Component)IdeUtil.getMainWindow(), (Throwable)t);
            }
        }
    }

    public long getTimestamp() {
        return -1L;
    }
}

