/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.base;

import java.awt.Component;
import java.sql.Connection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import oracle.dbdev.oviewer.base.ViewerEditor;
import oracle.dbdev.oviewer.base.ViewerNode;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Node;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;

public abstract class TableBasedViewer
extends ViewerEditor
implements IDBEditor {
    private ResultSetTable _table;
    protected DBObject _dbObject;
    protected DBObject _lastdbObject;
    private IdeAction _refreshAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");
    private SchemaObjectListener L = new SchemaObjectListener(){

        public void schemaObjectUpdated(DBObjectChange change) {
            TableBasedViewer.this.updateContent(true);
        }
    };

    protected TableBasedViewer() {
        this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Translate.translate((String)"Refresh"), null, null, (Icon)IdeArb.getIcon((int)324), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction arg0, Context arg1) {
                TableBasedViewer.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction arg0, Context arg1) {
                return false;
            }
        });
        ((Toolbar)super.getFixedTopMargin()).add((ToggleAction)this._refreshAction.newLocalAction((View)this));
    }

    protected abstract String getSelectStatement();

    public abstract String getDefaultExportName();

    protected JComponent createViewerUI() {
        this._table = new ResultSetTable();
        this._table.setAutoResizeMode(0);
        return this._table;
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute == "background_color") {
            return this._table.getBackground();
        }
        return super.getEditorAttribute(attribute);
    }

    public Component getScrollableTopMargin() {
        JTableHeader tableHeader = this._table.getTableHeader();
        return tableHeader;
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    protected void updateContent(boolean force) {
        ViewerNode viewerNode = this.getViewerNode();
        this._dbObject = new DBObject((Node)viewerNode);
        if (force || this._lastdbObject != this._dbObject) {
            SchemaObject oldObj = null;
            SchemaObject newObj = null;
            if (this._lastdbObject != null) {
                oldObj = this._lastdbObject.getSchemaObject();
            }
            if (this._dbObject != null) {
                newObj = this._dbObject.getSchemaObject();
            }
            if (oldObj != newObj) {
                if (oldObj != null) {
                    oldObj.removeObjectListener(this.L);
                }
                if (newObj != null) {
                    newObj.addObjectListener(this.L);
                }
            }
            this.updateTitle(this._dbObject.getObjectName());
            if (this.getDefaultExportName() == null) {
                this._table.setDefaultExportName(this._dbObject.getObjectName());
            } else {
                this._table.setDefaultExportName(this._dbObject.getObjectName() + this.getDefaultExportName());
            }
            Database database = viewerNode.getDatabase();
            if (database != null) {
                Connection connection = database.getConnection();
                DBUtil dbUtil = new DBUtil();
                String selectStatement = this.getSelectStatement();
                this._table.setQuery(connection, null, selectStatement, dbUtil.getObjectBinds(selectStatement, this._dbObject));
            }
            TableBasedViewer.updateToolbarActions((Toolbar)this._toolbar);
            this._lastdbObject = this._dbObject;
        }
    }

    protected ResultSetTableModel getTableModel() {
        return (ResultSetTableModel)this._table.getModel();
    }

    protected JTable getTable() {
        return this._table;
    }

    public Object getPrintable() {
        return this._table;
    }

    public Database getDatabase() {
        return this._dbObject.getDatabase();
    }

    public Connection getConnection() {
        return this._dbObject.getDatabase().getConnection();
    }
}

