/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.base;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.dbdev.oviewer.base.NavSelectionListener;
import oracle.dbdev.oviewer.base.ViewerEditor;
import oracle.dbdev.oviewer.base.ViewerEditorAddin;
import oracle.dbdev.oviewer.base.ViewerNode;
import oracle.dbdev.oviewer.base.ViewerPrintFactory;
import oracle.dbdev.oviewer.xmleditor.XMLEditor;
import oracle.dbtools.raptor.controls.IResultSetTableDrillDown;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.AbstractFolderedXml;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Resource;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerAddin
implements Addin,
Controller {
    private static int _showDbBrowser;
    private HashMap<String, ArrayList<ViewerEditorAddin>> _editorsAddins = new HashMap();
    private HashMap<String, ArrayList<XMLEditor>> _editors = new HashMap();
    private HashMap<String, ArrayList<Query>> _sharedQueries = new HashMap();

    public void initialize() {
        this.createActions();
        EditorManager editorManager = EditorManager.getEditorManager();
        ViewerNode.createInstance();
        NavSelectionListener.initialize();
        ResultSetTable.setDrillDown((IResultSetTableDrillDown)NavSelectionListener.getInstance());
        this.loadXMLEditors();
        PrintManager.getPrintManager().registerDocumentPrintFactory(ViewerEditor.class, ViewerPrintFactory.class);
    }

    public void addTab(String name, Class node, Class editor) {
        this.addTab(name, node, editor, null);
    }

    public void addTab(String name, Class node, Class editor, XMLEditor xmlEditor) {
        if (this._editorsAddins.get(node.toString()) == null) {
            this._editorsAddins.put(node.toString(), new ArrayList());
        }
        ViewerEditorAddin editorAddin = new ViewerEditorAddin(name, node, editor);
        if (xmlEditor != null) {
            editorAddin.setXMLEditor(xmlEditor);
        }
        this._editorsAddins.get(node.toString()).add(editorAddin);
        if (EditorManager.getEditorManager() != null) {
            EditorManager.getEditorManager().registerDynamic((EditorAddin)editorAddin);
        }
    }

    public XMLEditor getXMLEditor(Class dbNode, int num) {
        if (!Node.class.isAssignableFrom(dbNode)) {
            return null;
        }
        XMLEditor ret = null;
        ArrayList<ViewerEditorAddin> editors = this._editorsAddins.get(dbNode.toString());
        if (editors != null && editors.size() > num) {
            ret = editors.get(num).getXMLEditor();
        }
        return ret;
    }

    public HashMap<String, ArrayList<XMLEditor>> getXMLEditors() {
        return this._editors;
    }

    public void loadXMLEditors() {
        XMLParser parser = new XMLParser();
        parser.processXML(Resource.getResourceAsStream(this.getClass(), (String)"editors.xml"));
        if (System.getProperty("raptor.user.editors") != null) {
            try {
                parser.processXML(new FileInputStream(System.getProperty("raptor.user.editors")));
            }
            catch (FileNotFoundException e1) {
                System.err.print("Could Not load User Editors:" + e1.getMessage());
            }
        }
        Set<String> set = this._editors.keySet();
        Iterator<String> iter = set.iterator();
        Class<?> editor = null;
        while (iter.hasNext()) {
            String key = iter.next();
            for (int i = 0; i < this._editors.get(key).size(); ++i) {
                try {
                    editor = this._editors.get(key).get(i).getEditorClass() == null ? this.getClass().getClassLoader().loadClass("oracle.dbdev.oviewer.xmleditor.holders.XMLBasedEditor" + i) : this._editors.get(key).get(i).getEditorClass();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                this.addTab(this._editors.get(key).get(i).getTitle(), this._editors.get(key).get(i).getNodeClass(), editor, this._editors.get(key).get(i));
            }
        }
    }

    private void createActions() {
        _showDbBrowser = Ide.findOrCreateCmdID((String)"ShowDbBrowser");
        IdeAction action = IdeAction.get((int)_showDbBrowser, null, (String)"Show Object Browser", (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(66), (ArrayResourceBundle)IdeArb.getInstance(), (int)160, null, (boolean)true);
        action.addController((Controller)this);
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId != _showDbBrowser) {
            return false;
        }
        boolean canDo = this.whenShowBrowser(context, false);
        action.setEnabled(canDo);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId != _showDbBrowser) {
            return false;
        }
        this.whenShowBrowser(context, true);
        return true;
    }

    boolean whenShowBrowser(Context context, boolean doit) {
        boolean ret = false;
        Node node = context.getNode();
        if (node instanceof DatabaseNode) {
            context = new Context(context);
            ViewerNode viewerNode = ViewerNode.getInstance();
            context.setNode((Node)viewerNode);
            EditorManager editorManager = EditorManager.getEditorManager();
            EditorAddin bestEditorAddin = editorManager.getBestEditorAddin((Node)viewerNode);
            if (bestEditorAddin != null) {
                ret = true;
                if (doit) {
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                    editorManager.openEditor(openEditorOptions);
                }
            }
        }
        return ret;
    }

    private final class XMLParser
    extends AbstractFolderedXml {
        private XMLParser() {
        }

        public void openFolder(String name, String desc, String tip, org.w3c.dom.Node node) {
        }

        public void closeFolder() {
        }

        public void newItem(org.w3c.dom.Node node) {
            try {
                XMLEditor editor = new XMLEditor();
                String type = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"type");
                if (type != null && type.equals("sharedQuery")) {
                    String id = XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"id");
                    ViewerAddin.this._sharedQueries.put(id, Query.getQueries((org.w3c.dom.Node)node));
                } else if (type != null && type.equals("editor")) {
                    editor.setTitle(XMLHelper.getNodeValue((org.w3c.dom.Node)node, (String)"title"));
                    editor.setNode(XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"node"));
                    editor.setEditorClass(XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"editorClass"));
                    editor.setVertical(XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"vertical"));
                    editor.setDisplay(XMLHelper.getAttributeNode((org.w3c.dom.Node)node, (String)"display"));
                    String queryID = XMLHelper.getAttributeNode((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"query"), (String)"id");
                    if (queryID != null && !queryID.equals("")) {
                        editor.setQueries((ArrayList)ViewerAddin.this._sharedQueries.get(queryID));
                    } else {
                        editor.setQueries(Query.getQueries((org.w3c.dom.Node)node));
                    }
                    if (XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"bottomquery") != null) {
                        editor.setSubTitle(XMLHelper.getNodeValue((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"bottomquery"), (String)"title"));
                        queryID = XMLHelper.getAttributeNode((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"bottomquery"), (String)"query"), (String)"id");
                        if (queryID != null && !queryID.equals("")) {
                            editor.setBottomQueries((ArrayList)ViewerAddin.this._sharedQueries.get(queryID));
                        } else {
                            editor.setBottomQueries(Query.getQueries((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"bottomquery")));
                        }
                    }
                    editor.setSubQueries(Query.getQueries((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"subquery")));
                    if (editor.getSubQueries() != null && editor.getSubQueries().size() > 0) {
                        editor.setSubQueryType(XMLHelper.getAttributeNode((org.w3c.dom.Node)XMLHelper.getChildNode((org.w3c.dom.Node)node, (String)"subquery"), (String)"type"));
                    }
                    if (ViewerAddin.this._editors.get(editor.getNodeClass().toString()) == null) {
                        ViewerAddin.this._editors.put(editor.getNodeClass().toString(), new ArrayList());
                    }
                    ((ArrayList)ViewerAddin.this._editors.get(editor.getNodeClass().toString())).add(editor);
                    ViewerAddin.this.addTab(editor.getTitle(), XMLEditor.class, editor.getNodeClass(), editor);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

