/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.base;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import oracle.dbdev.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.dt.ConnectionContext;
import oracle.jdeveloper.cm.dt.ConnectionNode;

public abstract class ViewerEditor
extends Editor
implements Controller {
    private JComponent _panel;
    protected Toolbar _toolbar;
    private boolean _visible;
    private boolean _inSync;
    private boolean _pinEnabled = true;
    private IdeAction pinAction = IdeAction.get((int)PIN_EDITOR_CMD_ID, null, (String)IdeArb.getString((int)29), null, null, (Icon)IdeArb.getIcon((int)31), null, (boolean)true);
    private IdeAction _toolbarAction;
    private JMenu _actionMenu;
    private boolean _initActions = false;
    static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");

    protected abstract JComponent createViewerUI();

    protected abstract void updateContent();

    protected abstract void cleanUp();

    public abstract Object getPrintable();

    public ViewerEditor() {
        this.pinAction.addController((Controller)this);
    }

    public void open() {
    }

    public Component getGUI() {
        if (this._panel == null) {
            this._panel = this.createViewerUI();
        }
        return this._panel;
    }

    public void addMenuButton() {
        if (this._toolbarAction == null) {
            this._toolbarAction = XMLBasedObjectAction.getInstance().getIdeAction().newLocalAction((View)this);
            ToolButton btn = ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._toolbarAction);
            btn.setText("Actions...");
            btn.setIcon(IdeArb.getIcon((int)143));
            btn.setToolTipText("Available Actions");
        }
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID = change.getMessageID();
        if (messageID == ViewerNode.RELATION_NODE_CHANGED_MESSAGE_ID) {
            this.whenDbNodeChanged();
        } else if (messageID == ViewerNode.RELATION_NODE_MODIFIED_MESSAGE_ID && this.isVisible()) {
            this.updateContent();
        }
    }

    public Component getFixedTopMargin() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            if (this._pinEnabled) {
                this._toolbar.addToggleButton((ToggleAction)this.pinAction.newLocalAction((View)this));
            }
        }
        return this._toolbar;
    }

    public void editorShown() {
        this.whenVisibilityChanges(true);
    }

    public void editorHidden() {
        this.whenVisibilityChanges(false);
    }

    public boolean isVisible() {
        return this._visible;
    }

    private void whenVisibilityChanges(boolean visible) {
        this._visible = visible;
        if (this._visible) {
            if (!this._inSync) {
                this.whenDbNodeChanged();
            }
            ViewerEditor.updateToolbarActions((Toolbar)this._toolbar);
            if (!this._initActions) {
                this.addMenuButton();
                this._initActions = true;
            }
        }
    }

    protected void whenDbNodeChanged() {
        if (this.isVisible() && this.getContext().getNode() instanceof ViewerNode) {
            ((ViewerNode)this.getContext().getNode()).addNodeListener(new NodeListener(){

                public void nodeWillClose(NodeEvent e) {
                    ViewerEditor.this.cleanUp();
                }
            });
            ViewerNode viewerNode = this.getViewerNode();
            Context context = this.getContext();
            Node relationNode = (Node)viewerNode.getDatabaseNode();
            context.setSelection(new Element[]{relationNode});
            this.updateContent();
        } else {
            this._inSync = false;
        }
    }

    protected ViewerNode getViewerNode() {
        return this.getViewerNode(this.getContext());
    }

    private ViewerNode getViewerNode(Context context) {
        if (context.getNode() instanceof ViewerNode) {
            return (ViewerNode)context.getNode();
        }
        return null;
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == PIN_EDITOR_CMD_ID && this._pinEnabled) {
            action.setEnabled(true);
            if (context.getNode() instanceof ViewerNode) {
                ViewerNode viewerNode = (ViewerNode)context.getNode();
                action.setState(viewerNode.getPinned());
            }
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == PIN_EDITOR_CMD_ID) {
            ViewerNode viewerNode;
            viewerNode.setPinned(!(viewerNode = (ViewerNode)context.getNode()).getPinned());
            return true;
        }
        return false;
    }

    public boolean isPinEnabled() {
        return this._pinEnabled;
    }

    public void setPinEnabled(boolean enabled) {
        this._pinEnabled = enabled;
    }

    public Context getContext(EventObject eo) {
        Database db;
        ViewerNode vn;
        Context ctx = super.getContext(eo);
        if (ctx != null && (vn = this.getViewerNode(ctx)) != null && (db = vn.getDatabase()) != null) {
            ConnectionContext.setConnectionNode((Context)ctx, (ConnectionNode)Connections.getInstance().getDBConnectionNode(db.getConnectionName()));
        }
        return ctx;
    }
}

