/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.base;

import oracle.dbdev.oviewer.base.ViewerNode;
import oracle.dbdev.oviewer.xmleditor.XMLEditor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.MenuSpec;

class ViewerEditorAddin
extends EditorAddin {
    public static float INIT_WEIGHT = 0.5f;
    public static float DELTA_WEIGHT = 0.001f;
    private static float _weight = INIT_WEIGHT;
    private final String LABEL;
    private final Class NODE_CLASS;
    private final Class EDITOR_CLASS;
    private float _myWeight;
    private XMLEditor _editor;

    public ViewerEditorAddin(String label, Class nodeClass, Class editorClass) {
        this.LABEL = label;
        this.NODE_CLASS = nodeClass;
        this.EDITOR_CLASS = editorClass;
        this._myWeight = _weight;
        _weight -= DELTA_WEIGHT;
    }

    public MenuSpec getMenuSpecification() {
        return new MenuSpec(this.LABEL, null, null, -1);
    }

    public Class getEditorClass() {
        return this.EDITOR_CLASS;
    }

    public boolean restoreAtStartup() {
        return false;
    }

    public float getEditorWeight() {
        return this._myWeight;
    }

    public float getEditorWeight(Element element) {
        float ret = Float.NaN;
        if (element instanceof ViewerNode) {
            ViewerNode viewerNode = (ViewerNode)element;
            Node relationNode = (Node)viewerNode.getDatabaseNode();
            if (relationNode != null) {
                Class<?> relationClass = relationNode.getClass();
                if (this.NODE_CLASS.equals(relationClass)) {
                    ret = this._myWeight;
                }
            } else if (this.NODE_CLASS.equals(viewerNode.getDBObject().getNode().getClass())) {
                ret = this._myWeight;
            }
        }
        return ret;
    }

    public void setXMLEditor(XMLEditor xmlEditor) {
        this._editor = xmlEditor;
    }

    public XMLEditor getXMLEditor() {
        return this._editor;
    }
}

