/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.oviewer.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbdev.oviewer.base.ViewerEditor;
import oracle.dbdev.oviewer.base.ViewerNode;
import oracle.dbdev.oviewer.table.SortColumnPicker;
import oracle.dbtools.raptor.controls.CopyableResultSetTableAdapter;
import oracle.dbtools.raptor.controls.EditableResultSetTable;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseNode;

public class DataEditor
extends ViewerEditor
implements Controller,
ViewerNode.DirtyComponent,
IDBEditor,
IActionUpdater {
    private static final String QUERY_NAME = "SELECT * FROM {0}";
    private static final String QUERY_SCHEMA_AND_NAME = "SELECT * FROM {0}.{1}";
    private Component _rowHeader;
    private EditableResultSetTable _tblData = new EditableResultSetTable((IActionUpdater)this);
    private Component view = null;
    protected CopyableResultSetTableAdapter _adapter;
    static final int INSERT_ROW_CMD_ID = Ide.findOrCreateCmdID((String)"LDE_Insert_Row");
    static final int DELETE_ROW_CMD_ID = Ide.findOrCreateCmdID((String)"LDE_Delete_Row");
    static final int COMMIT_CHANGES_CMD_ID = Ide.findOrCreateCmdID((String)"LDE_Commit_Changes");
    static final int ROLLBACK_CHANGES_CMD_ID = Ide.findOrCreateCmdID((String)"LDE_Rollback_Changes");
    static final int SORT_CMD_ID = Ide.findOrCreateCmdID((String)"LDE_Sort");
    static final int REFRESH_CMD_ID = Ide.findOrCreateCmdID((String)"LDE_Refresh");
    private boolean _opened = false;
    private String _tableName = null;
    private String _schemaName = null;
    private JLabel filterLabel;
    private JTextField filter;
    private SortColumnPicker sortPanel = new SortColumnPicker();
    private DBObject _dbObject;

    public DataEditor() {
        this._rowHeader = this._tblData.getRowHeader();
        this._tblData.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataEditor.this.updateSelection();
            }
        });
        KeyStroke[] keys = new KeyStroke[]{KeyStroke.getKeyStroke("control C")};
        KeyUtil.removeKeyStrokesFromInputMaps((JComponent)this._tblData, (KeyStroke[])keys);
        this._tblData.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataEditor.this.updateVisibleActions();
            }
        });
        this._tblData.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataEditor.this.updateVisibleActions();
                DataEditor.this._tblData.getRowHeader().repaint();
                DataEditor.this._tblData.repaint();
            }
        });
        this.registerTable((JTable)this._tblData);
        this.createActions();
        this.filterLabel = new JLabel(CreateDialogArb.getString((int)527));
        this.filter = new JTextField("");
        this.filter.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    DataEditor.this._tblData.setWhere(DataEditor.this.filter.getText());
                    DataEditor.this.refreshView();
                }
            }
        });
        Dimension d = this.filter.getSize();
        Assert.println((String)d.toString());
    }

    public void open() {
        boolean refreshSortFilter = false;
        DBObject dbObject = new DBObject((Node)this.getViewerNode());
        if (dbObject != null) {
            this._tblData.setDefaultExportName(dbObject.getObjectName());
            Database db = dbObject.getDatabase();
            Schema schema = dbObject.getSchemaObject().getSchema();
            try {
                String schemaName = AbstractDBObjectProvider.convertObject((oracle.javatools.db.DBObject)schema);
                String relName = db.quoteIdentifier(dbObject.getObjectName(), true);
                if (!schemaName.equals(this._schemaName) || !relName.equals(this._tableName)) {
                    refreshSortFilter = true;
                }
            }
            catch (DBException ex) {
                // empty catch block
            }
        }
        this._getTableData(!this._opened);
        if (!this._opened) {
            this._tblData.showLogPage(false);
            this._opened = true;
        }
        if (refreshSortFilter) {
            int nCol = this._tblData.getColumnCount();
            String[] columns = new String[nCol];
            for (int i = 1; i < nCol + 1; ++i) {
                columns[i - 1] = this._tblData.getColumnDBName(i - 1);
            }
            this.sortPanel.init(columns);
            this.filter.setText("");
        }
        this._dbObject = dbObject;
    }

    public void close() {
        this._tblData.closeModel();
    }

    public boolean saveChanges() {
        boolean ret = this._tblData.save();
        if (ret) {
            this.markDirty(false);
        } else if (this._tblData.getUpdatedByAnotherUser()) {
            String message = ConnectionArb.getString((int)678);
            boolean rollback = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)ConnectionArb.getString((int)665), null);
            if (rollback) {
                this.rollbackChanges();
            }
        }
        return ret;
    }

    public boolean rollbackChanges() {
        boolean ret = this._tblData.rollback();
        if (ret) {
            this.markDirty(false);
        }
        return ret;
    }

    public boolean insertRow() {
        boolean ret = this._tblData.insertRow();
        if (ret) {
            this.markDirty(true);
        }
        return ret;
    }

    public boolean deleteRow() {
        boolean ret = this._tblData.deleteRow();
        if (ret) {
            this.markDirty(true);
        }
        return ret;
    }

    public Controller getController() {
        return this;
    }

    public Component getScrollableLeftMargin() {
        return this._rowHeader;
    }

    public Component getScrollableTopMargin() {
        return this._tblData.getTableHeader();
    }

    public Component getGUI() {
        if (this.view == null) {
            this._createGUI();
        }
        return this.view;
    }

    public Component getFixedTopMargin() {
        if (this._toolbar == null) {
            DatabaseNode node = this.getViewerNode().getDatabaseNode();
            super.getFixedTopMargin();
            if (node.getObjectType().equals("TABLE")) {
                this._toolbar.add((ToggleAction)IdeAction.get((int)REFRESH_CMD_ID).newLocalAction((View)this));
                this._toolbar.add((ToggleAction)IdeAction.get((int)INSERT_ROW_CMD_ID).newLocalAction((View)this));
                this._toolbar.add((ToggleAction)IdeAction.get((int)DELETE_ROW_CMD_ID).newLocalAction((View)this));
                this._toolbar.add((ToggleAction)IdeAction.get((int)COMMIT_CHANGES_CMD_ID).newLocalAction((View)this));
                this._toolbar.add((ToggleAction)IdeAction.get((int)ROLLBACK_CHANGES_CMD_ID).newLocalAction((View)this));
                this._toolbar.addSeparator();
                JButton button = new JButton((Action)IdeAction.find((int)SORT_CMD_ID).newLocalAction((View)this));
                button.setToolTipText(Translate.translate((String)"Sort"));
                this._toolbar.add((Component)button);
                this._toolbar.addSeparator();
                this._toolbar.add((Component)this.filterLabel);
                this._toolbar.add((Component)this.filter);
                this.filter.setSize(200, 0);
            } else {
                this._toolbar.add((ToggleAction)IdeAction.get((int)REFRESH_CMD_ID).newLocalAction((View)this));
                this._toolbar.addSeparator();
                JButton button = new JButton((Action)IdeAction.find((int)SORT_CMD_ID).newLocalAction((View)this));
                button.setToolTipText(Translate.translate((String)"Sort"));
                this._toolbar.add((Component)button);
                this._toolbar.addSeparator();
                this._toolbar.add((Component)this.filterLabel);
                this._toolbar.add((Component)this.filter);
                this.filter.setSize(200, 0);
            }
        }
        return this._toolbar;
    }

    public Component getDefaultFocusComponent() {
        return this._tblData;
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute.equals("menu_id")) {
            return "Ta&ble";
        }
        return super.getEditorAttribute(attribute);
    }

    private void refreshData() {
        if (this.getChanged()) {
            String message = MessageFormat.format(IdeArb.getString((int)217), this._tableName);
            int confirm = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)message, (String)this._tableName, null);
            switch (confirm) {
                case 1: {
                    if (this.saveChanges()) break;
                    return;
                }
                case 0: {
                    if (this.rollbackChanges()) break;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        this._tblData.setWhere(this.filter.getText());
        this.refreshView();
    }

    private void sortData() {
        if (this.getChanged()) {
            String message = MessageFormat.format(IdeArb.getString((int)217), this._tableName);
            int confirm = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)message, (String)this._tableName, null);
            switch (confirm) {
                case 1: {
                    if (this.saveChanges()) break;
                    return;
                }
                case 0: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        Object[] options = new Object[]{CreateDialogArb.getString((int)522), CreateDialogArb.getString((int)523)};
        JOptionPane optionPane = new JOptionPane(null, -1, 0, null, options, options[0]);
        optionPane.add(this.sortPanel);
        ArrayList toList = this.sortPanel.getToList();
        ArrayList fromList = this.sortPanel.getFromList();
        JDialog sortDialog = optionPane.createDialog((Component)Ide.getMainWindow(), CreateDialogArb.getString((int)526));
        sortDialog.setSize(new Dimension(500, 400));
        sortDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        sortDialog.setVisible(true);
        Assert.println((String)optionPane.getValue().toString());
        if (optionPane.getValue().equals(CreateDialogArb.getString((int)522))) {
            this._tblData.setOrderBy(this.sortPanel.getOrderBy());
            this.refreshView();
        } else {
            this.sortPanel.setToList(toList);
            this.sortPanel.setFromList(fromList);
        }
    }

    private void _getTableData(boolean forceRefresh) {
        DBObject dbObject = new DBObject((Node)this.getViewerNode());
        if (dbObject != null) {
            Database db = dbObject.getDatabase();
            Schema schema = dbObject.getSchemaObject().getSchema();
            try {
                String sql;
                String schemaName = AbstractDBObjectProvider.convertObject((oracle.javatools.db.DBObject)schema);
                String relName = db.quoteIdentifier(dbObject.getObjectName(), true);
                if (!forceRefresh && schemaName.equals(this._schemaName) && relName.equals(this._tableName) && dbObject.getDatabase().getConnectionName().equals(this._dbObject.getDatabase().getConnectionName())) {
                    return;
                }
                this._schemaName = schemaName;
                this._tableName = relName;
                if (ModelUtil.hasLength((String)schemaName)) {
                    schemaName = db.quoteIdentifier(schemaName, true);
                    sql = MessageFormat.format(QUERY_SCHEMA_AND_NAME, schemaName, relName);
                } else {
                    sql = MessageFormat.format(QUERY_NAME, relName);
                }
                if (this._tblData.getModel() instanceof ResultSetTableModel) {
                    ((ResultSetTableModel)this._tblData.getModel()).setSchemaName(schemaName);
                }
                if (dbObject.getObjectType().equals("TABLE")) {
                    this._tblData.setQuery(db.getConnection(), null, sql, true, db);
                } else {
                    this._tblData.setQuery(db.getConnection(), null, sql, false, db);
                }
            }
            catch (DBException ex) {
                // empty catch block
            }
        }
    }

    public boolean canRefreshView() {
        return true;
    }

    public void refreshView() {
        this._tblData.refresh();
    }

    public boolean validSelection() {
        return this._tblData.getSelectedRowCount() > 0;
    }

    public boolean getChanged() {
        return this._tblData.getChanged();
    }

    private void _createGUI() {
        this.view = this._tblData;
    }

    protected final void registerTable(JTable table) {
        this._adapter = table != null ? new CopyableResultSetTableAdapter(table) : null;
    }

    public final CopyableResultSetTableAdapter getCopyableJTableAdapter() {
        return this._adapter;
    }

    private void markDirty(boolean isDirty) {
        ViewerNode viewerNode = this.getViewerNode();
        if (isDirty) {
            viewerNode.addDirtyComponent(this);
        } else {
            viewerNode.removeDirtyComponent(this);
        }
    }

    public void save(ViewerNode viewerNode) throws IOException {
        if (!this.saveChanges()) {
            throw new IOException("Failed to save the changes");
        }
    }

    protected JComponent createViewerUI() {
        return this._tblData;
    }

    protected void updateContent() {
        this.open();
        this.updateVisibleActions();
    }

    private void createActions() {
        IdeAction.get((int)INSERT_ROW_CMD_ID, null, (String)ConnectionArb.getString((int)674), null, null, (Icon)ConnectionArb.getIcon((int)493), null, (boolean)true);
        IdeAction.get((int)DELETE_ROW_CMD_ID, null, (String)ConnectionArb.getString((int)675), null, null, (Icon)ConnectionArb.getIcon((int)494), null, (boolean)true);
        IdeAction.get((int)COMMIT_CHANGES_CMD_ID, null, (String)ConnectionArb.getString((int)676), null, null, (Icon)ConnectionArb.getIcon((int)679), null, (boolean)true);
        IdeAction.get((int)ROLLBACK_CHANGES_CMD_ID, null, (String)ConnectionArb.getString((int)677), null, null, (Icon)ConnectionArb.getIcon((int)680), null, (boolean)true);
        IdeAction.get((int)SORT_CMD_ID, null, (String)CreateDialogArb.getString((int)525), null, null, (Icon)ConnectionArb.getIcon((int)407), null, (boolean)true);
        IdeAction.get((int)REFRESH_CMD_ID, null, (String)CreateDialogArb.getString((int)524), null, null, (Icon)IdeArb.getIcon((int)324), null, (boolean)true);
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        super.updateVisibleActions(updateMessage);
        DataEditor.updateToolbarActions((Toolbar)this._toolbar);
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == INSERT_ROW_CMD_ID) {
            action.setEnabled(this._tblData.getValid() && !this._tblData.getUpdatedByAnotherUser());
        } else if (commandId == DELETE_ROW_CMD_ID) {
            action.setEnabled(this._tblData.getValid() && this.validSelection() && !this._tblData.getUpdatedByAnotherUser());
        } else if (commandId == COMMIT_CHANGES_CMD_ID) {
            boolean isEnabled = false;
            if (this._tblData.getValid() && !this._tblData.getUpdatedByAnotherUser() && this.getChanged()) {
                isEnabled = true;
            }
            action.setEnabled(isEnabled);
        } else if (commandId == ROLLBACK_CHANGES_CMD_ID) {
            action.setEnabled(this._tblData.getValid() && this.getChanged());
        } else {
            this.markDirty(this._tblData.getValid() && this.getChanged());
            return super.update(action, context);
        }
        this.markDirty(this._tblData.getValid() && this.getChanged());
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == INSERT_ROW_CMD_ID) {
            this.insertRow();
        } else if (commandId == DELETE_ROW_CMD_ID) {
            this.deleteRow();
        } else if (commandId == COMMIT_CHANGES_CMD_ID) {
            this.saveChanges();
        } else if (commandId == ROLLBACK_CHANGES_CMD_ID) {
            this.rollbackChanges();
        } else if (commandId == SORT_CMD_ID) {
            this.sortData();
        } else if (commandId == REFRESH_CMD_ID) {
            this.refreshData();
        } else {
            return super.handleEvent(action, context);
        }
        this.markDirty(this._tblData.getValid() && this.getChanged());
        return true;
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID = change.getMessageID();
        if (messageID == ViewerNode.RELATION_NODE_MODIFIED_MESSAGE_ID) {
            if (this.isVisible()) {
                this._getTableData(true);
            }
        } else {
            super.update(observed, change);
        }
    }

    public Object getPrintable() {
        return this._tblData;
    }

    public Database getDatabase() {
        if (this._dbObject != null) {
            return this._dbObject.getDatabase();
        }
        return null;
    }

    public Connection getConnection() {
        if (this._dbObject != null) {
            return this._dbObject.getDatabase().getConnection();
        }
        return null;
    }

    protected void cleanUp() {
        if (this._tblData.getModel() instanceof ResultSetTableModel) {
            ((ResultSetTableModel)this._tblData.getModel()).close();
        }
    }

    public void updateActions() {
        this.updateVisibleActions();
    }
}

